function eraTf2a,s,ihour,imin,sec,rad

;  int eraTf2a(char s, int ihour, int imin, double sec, double *rad)
;  /*
;  **  - - - - - - - -
;  **   e r a T f 2 a
;  **  - - - - - - - -
;  **
;  **  Convert hours, minutes, seconds to radians.
;  **
;  **  Given:
;  **     s         char    sign:  '-' = negative, otherwise positive
;  **     ihour     int     hours
;  **     imin      int     minutes
;  **     sec       double  seconds
;  **
;  **  Returned:
;  **     rad       double  angle in radians
;  **
;  **  Returned (function value):
;  **               int     status:  0 = OK
;  **                                1 = ihour outside range 0-23
;  **                                2 = imin outside range 0-59
;  **                                3 = sec outside range 0-59.999...
;  **
;  **  Notes:
;  **
;  **  1)  The result is computed even if any of the range checks fail.
;  **
;  **  2)  Negative ihour, imin and/or sec produce a warning status, but
;  **      the absolute value is used in the conversion.
;  **
;  **  3)  If there are multiple errors, the status value reflects only the
;  **      first, the smallest taking precedence.
;  **
;  **  Copyright (C) 2013-2015, NumFOCUS Foundation.
;  **  Derived, with permission, from the SOFA library.  See notes at end of file.
;  */
  
@erfam  
;  /* Compute the interval. */
if  s eq '-' then sign = -1.0d else sign= 1.0d 
  rad  = sign *  $
  ( 60.0d * ( 60.0d * ( abs(ihour) ) + $
  (  abs(imin) ) ) + $
  abs(sec) ) * ERFA_DS2R;
  
;  /* Validate arguments and return status. */
  if ( ihour lt 0 || ihour gt 23 ) then return, 1;
  if ( imin lt 0 || imin gt 59 ) then return, 2;
  if ( sec lt 0.0 || sec ge 60.0 ) then return, 3;
  return, 0;
  

;/*----------------------------------------------------------------------


end