pro eraTrxp,r,p,trp


;  void eraTrxp(double r[3][3], double p[3], double trp[3])
;  /*
;  **  - - - - - - - -
;  **   e r a T r x p
;  **  - - - - - - - -
;  **
;  **  Multiply a p-vector by the transpose of an r-matrix.
;  **
;  **  Given:
;  **     r        double[3][3]   r-matrix
;  **     p        double[3]      p-vector
;  **
;  **  Returned:
;  **     trp      double[3]      r * p
;  **
;  **  Note:
;  **     It is permissible for p and trp to be the same array.
;  **
;  **  Called:
;  **     eraTr        transpose r-matrix
;  **     eraRxp       product of r-matrix and p-vector
;  **
;  **  Copyright (C) 2013-2015, NumFOCUS Foundation.
;  **  Derived, with permission, from the SOFA library.  See notes at end of file.
;  */
  
  tr=dblarr(3,3);
  
;  /* Transpose of matrix r. */
  eraTr,r, tr;
  
 ; /* Matrix tr * vector p -> vector trp. */
  eraRxp,tr, p, trp;
  

;/*----------------------------------------------------------------------



end