pro eraTrxpv,r,pv,trpv

;void eraTrxpv(double r[3][3], double pv[2][3], double trpv[2][3])
;/*
;**  - - - - - - - - -
;**   e r a T r x p v
;**  - - - - - - - - -
;**
;**  Multiply a pv-vector by the transpose of an r-matrix.
;**
;**  Given:
;**     r        double[3][3]    r-matrix
;**     pv       double[2][3]    pv-vector
;**
;**  Returned:
;**     trpv     double[2][3]    r * pv
;**
;**  Note:
;**     It is permissible for pv and trpv to be the same array.
;**
;**  Called:
;**     eraTr        transpose r-matrix
;**     eraRxpv      product of r-matrix and pv-vector
;**
;**  Copyright (C) 2013-2015, NumFOCUS Foundation.
;**  Derived, with permission, from the SOFA library.  See notes at end of file.
;*/

   tr=dblarr(3,3);

;/* Transpose of matrix r. */
   eraTr,r, tr;

;/* Matrix tr * vector pv -> vector trpv. */
   eraRxpv,tr, pv, trpv;

  


;/*----------------------------------------------------------------------

end