; erfam
; Oliver Pfuhl 2017Mar01: ported erfa C-routines to IDL

;  #define ERFAMHDEF
;  
;  /*
;  **  - - - - - - - -
;  **   e r f a m . h
;  **  - - - - - - - -
;  **
;  **  Macros used by ERFA library.
;  **
;  **  Copyright (C) 2013-2015, NumFOCUS Foundation.
;  **  Derived, with permission, from the SOFA library.  See notes at end of file.
;  */
;  
;  /* Star-independent astrometry parameters */
;  typedef struct {
;  double pmt;        /* PM time interval (SSB, Julian years) */
;  double eb[3];      /* SSB to observer (vector, au) */
;  double eh[3];      /* Sun to observer (unit vector) */
;  double em;         /* distance from Sun to observer (au) */
;  double v[3];       /* barycentric observer velocity (vector, c) */
;  double bm1;        /* sqrt(1-|v|^2): reciprocal of Lorenz factor */
;  double bpn[3][3];  /* bias-precession-nutation matrix */
;  double along;      /* longitude + s' + dERA(DUT) (radians) */
;  double phi;        /* geodetic latitude (radians) */
;  double xpl;        /* polar motion xp wrt local meridian (radians) */
;  double ypl;        /* polar motion yp wrt local meridian (radians) */
;  double sphi;       /* sine of geodetic latitude */
;  double cphi;       /* cosine of geodetic latitude */
;  double diurab;     /* magnitude of diurnal aberration vector */
;  double eral;       /* "local" Earth rotation angle (radians) */
;  double refa;       /* refraction constant A (radians) */
;  double refb;       /* refraction constant B (radians) */
;} eraASTROM;
;/* (Vectors eb, eh, em and v are all with respect to BCRS axes.) */
;
;/* Body parameters for light deflection */
;typedef struct {
;double bm;         /* mass of the body (solar masses) */
;double dl;         /* deflection limiter (radians^2/2) */
;double pv[2][3];   /* barycentric PV of the body (au, au/day) */
;} eraLDBODY;

;/* Pi */
ERFA_DPI=3.141592653589793238462643d

;/* 2Pi */
ERFA_D2PI=6.283185307179586476925287d

;/* Radians to degrees */
ERFA_DR2D=57.29577951308232087679815d

;/* Degrees to radians */
ERFA_DD2R=1.745329251994329576923691d-2

;/* Radians to arcseconds */
ERFA_DR2AS=206264.8062470963551564734d

;/* Arcseconds to radians */
ERFA_DAS2R=4.848136811095359935899141d-6

;/* Seconds of time to radians */
ERFA_DS2R=7.272205216643039903848712d-5

;/* Arcseconds in a full circle */
ERFA_TURNAS=1296000.0d

;/* Milliarcseconds to radians */
ERFA_DMAS2R=ERFA_DAS2R / 1d3

;/* Length of tropical year B1900 (days) */
ERFA_DTY=365.242198781d

;/* Seconds per day. */
ERFA_DAYSEC=86400.0d

;/* Days per Julian year */
ERFA_DJY=365.25d

;/* Days per Julian century */
ERFA_DJC=36525.0d

;/* Days per Julian millennium */
ERFA_DJM=365250.0d

;/* Reference epoch (J2000.0), Julian Date */
ERFA_DJ00=2451545.0d

;/* Julian Date of Modified Julian Date zero */
ERFA_DJM0=2400000.5d

;/* Reference epoch (J2000.0), Modified Julian Date */
ERFA_DJM00=51544.5d

;/* 1977 Jan 1.0 as MJD */
ERFA_DJM77=43144.0d

;/* TT minus TAI (s) */
ERFA_TTMTAI=32.184d

;/* Astronomical unit (m) */
ERFA_DAU=149597870d3

;/* Speed of light (m/s) */
ERFA_CMPS=299792458.0d

;/* Light time for 1 au (s) */
ERFA_AULT=499.004782d

;/* Speed of light (AU per day) */
ERFA_DC=(ERFA_DAYSEC / ERFA_AULT)

;/* L_G = 1 - d(TT)/d(TCG) */
ERFA_ELG=6.969290134d-10

;/* L_B = 1 - d(TDB)/d(TCB), and TDB (s) at TAI 1977/1/1.0 */
ERFA_ELB=1.550519768d-8
ERFA_TDB0=-6.55d-5

;/* Schwarzschild radius of the Sun (au) */
;/* = 2 * 1.32712440041e20 / (2.99792458e8)^2 / 1.49597870700e11 */
ERFA_SRS=1.97412574336d-8




