pro testscript

;astrom={astro, pmt:0d,eb:dblarr(3), eh:dblarr(3),em:0d,v:dblarr(3),bm1:0d,bpn:dblarr(3,3),along:0d,phi:0d,xpl:0d,ypl:0d,sphi:0d,cphi:0d,diurab:0d,eral:0d,refa:0d,refb:0d}
deg2rad = 180D/!dpi

date1=2400000.5d
date2=53423.2d
latitude = -24.62743941D;
longitude = -70.40498688D; # Longitude of Paranal , in degrees
;height of observatory
altitude_obs = 2681D; in [m]


cd,'/Users/pfuhl/mpe/GRAV_COM2/data/alfCru/'
filelist=file_search('GRAVI*p2vmreduced.fits')
nfiles=n_elements(filelist)

file=filelist[0]


primhdr=headfits(file,exten=0)
RA_Tel =SXPAR(primhdr,'RA');seems to telescope pointing,ie. observed coordinates
DEC_Tel =SXPAR(primhdr,'DEC')
mjd_obs=SXPAR(primhdr,'MJD-OBS')
get_object_info,file,ra,dec,dra,ddec,tel1,tel2,tel3,tel4,geolat,geolon,elevation,TEMPERATURE=temperature,PRESSURE=pressure,humidity=humidity




;eraEpv00,date1,date2,pvh,pvb
 arcsec2deg=3600d
dc=dec/deg2rad
deltaRA=dra/cos(dc) / arcsec2deg
rc=(ra-0d*deltaRA)/deg2rad


pr=0d;proper motion
pd=0d;proper motion
px=0d;parallax
rv=0d;radial vel
utc1=date1
utc2=mjd_obs
dut1=0d
elong=longitude/deg2rad;longitude rad
phi=latitude/deg2rad;latitude rad
hm=altitude_obs;height in m
phpa=0d;pressure;mbar
tc=0d;temperature;temp in C
rh=0d;humidity; [0,1]
wl=0d;2.2d;wavelength in mum
xp=0d
yp=0d

ri=rc
di=dc
dummy=eraatio13(ri,di,utc1,utc2,dut1,elong,phi,hm,xp,yp,phpa,tc,rh,wl,aob,zob,hob,dob,rob)
;dummy=eraatco13(rc,dc,pr,pd,px,rv,utc1,utc2,dut1,elong,phi,hm,xp,yp,phpa,tc,rh,wl,aob,zob,hob,dob,rob,eo)


;eq2hor_OP,RA,DEC, mjd_obs+date1, alt_target, az_target,HA_target,RA_OBS=ra_obs,DEC_OBS=dec_obs,  LAT=latitude , LON=longitude, PRECESS_=1, $
; NUTATE_= 1, REFRACT_= 1, ABERRATION_= 1,  ALTITUDE=altitude_obs,PRESSURE=pressure,TEMPERATURE=temperature


print,rc*deg2rad,dc*deg2rad
print,rob*deg2rad,dob*deg2rad
print,aob*deg2rad,(90.-zob*deg2rad)
print,hob*deg2rad+360d,format='(D16.10)'
stop
end