function testscript_manual
;the script tests all the functions below. 
;the results are to be compared with the results on the manual of SOFA astrometry tools p.20

  astrom={astro, pmt:0d,eb:dblarr(3), eh:dblarr(3),em:0d,v:dblarr(3),bm1:0d,bpn:dblarr(3,3),along:0d,phi:0d,xpl:0d,ypl:0d,sphi:0d,cphi:0d,diurab:0d,eral:0d,refa:0d,refb:0d}

;  double bm;         /* mass of the body (solar masses) */
 ; double dl;         /* deflection limiter (radians^2/2) */
  ;double pv[2][3];   /* barycentric PV of the body (au, au/day) */
LDBODY={bm:0d,dl:0d,pv:dblarr(2,3)};

pvh=dblarr(2,3) & pvb=dblarr(2,3)



@erfam
 ; /* Site longitude, latitude (radians) and height above the geoid (m). */
dummy=  eraAf2a('-', 5, 41, 54.2d, elong );
 dummy= eraAf2a('-', 15, 57, 42.8d, phi );
  hm = 625.0d;
;  /* Ambient pressure (HPa), temperature (C) and rel. humidity (frac). */
  phpa = 952.0d;
  tc = 18.5d;
  rh = 0.83d;
;  /* Effective color (microns). */
  wl = 0.55d;

;  /* UTC date. */
  if  eraDtf2d( "UTC", 2013, 4, 2, 23, 15, 43.55d,  utc1, utc2 ) then return, -1;
;  /* TT date. */
  if ( eraUtctai( utc1, utc2, tai1, tai2 ) ) then return, -1
  if ( eraTaitt( tai1, tai2, tt1, tt2 ) ) then return, -1


 ; /* EOPs:  polar motion in radians, UT1-UTC in seconds. */
  xp = 50.995d-3 * ERFA_DAS2R;
  yp = 376.723d-3 * ERFA_DAS2R;
  dut1 = 155.0675d-3;
;  /* Corrections to IAU 2000A CIP (radians). */
  dx = 0.269d-3 * ERFA_DAS2R;
  dy = -0.274d-3 * ERFA_DAS2R;
  
;  /* Star ICRS RA,Dec (radians). */
  if ( eraTf2a(  ' ', 14, 34, 16.81183d, rc ) )  then return, -1;
  if ( eraAf2a( '-', 12, 31, 10.3965d, dc ) ) then return, -1
  
reprd,"ICRS, epoch J2000.0:", rc, dc 

;* Proper motion: RA/Dec derivatives, epoch J2000.0. */
pr = atan( -354.45d-3 * ERFA_DAS2R, cos(dc) );
pd = 595.35d-3 * ERFA_DAS2R

;/* Parallax (arcsec) and recession speed (km/s). */
px = 164.99d-3;
rv = 0.0d;

;/* ICRS to CIRS (geocentric observer). */
eraAtci13, rc, dc, pr, pd, px, rv, tt1, tt2, ri, di, eo ;
reprd, "catalog -> CIRS:", ri, di ;

;/* CIRS to ICRS (astrometric). */
eraAtic13, ri, di, tt1, tt2, rca, dca, eo ;
reprd, "CIRS -> astrometric:", rca, dca ;

;/* ICRS (astrometric) to CIRS (geocentric observer). */
eraAtci13, rca, dca, 0.0, 0.0, 0.0, 0.0, tt1, tt2, ri, di, eo ;
reprd , "astrometric -> CIRS:", ri, di ;

;/* Apparent place. */
ra = eraAnp( ri - eo );
da = di;
reprd , "geocentric apparent:", ra, da ;


;/* CIRS to topocentric. */
if ( eraAtio13( ri, di, utc1, utc2, dut1, elong, phi, hm, xp, yp,0.0d, 0.0d, 0.0d, 0.0d,aot, zot, hot, dot, rot ) ) then return, -1;
reprd , "CIRS -> topocentric:", rot, dot ;


;/* CIRS to observed. */
if ( eraAtio13( ri, di, utc1, utc2, dut1, elong, phi, hm, xp, yp,phpa, tc, rh, wl,aob, zob, hob, dob, rob ) ) then return, -1;
reprd , "CIRS -> observed:", rob, dob ;


;/* ICRS to observed. */
if ( eraAtco13( rc, dc, pr, pd, px, rv, utc1, utc2, dut1,elong, phi, hm, xp, yp, phpa, tc, rh, wl,aob, zob, hob, dob, rob, eo ) ) then return, -1;
reprd, "ICRS -> observed:", rob, dob ;


;/* ICRS to CIRS using some user-supplied parameters. */
;/* SOFA heliocentric Earth ephemeris. */



if ( eraEpv00( tt1, tt2, pvh, pvb ) ) then return, -1;
;/* JPL DE405 barycentric Earth ephemeris. */
pvb[0,0] = -0.9741704366519668d;
pvb[0,1] = -0.2115201000882231d;
pvb[0,2] = -0.0917583114068277d;
pvb[1,0] =  0.0036436589347388d;
pvb[1,1] = -0.0154287318503146d;
pvb[1,2] = -0.0066892203821059d;

;/* IAU 2000A CIP. */
eraPnm00a, tt1, tt2, r ;
eraBpn2xy, r, x, y ;
;/* Apply IERS corrections. */
x += dx;
y += dy;
;/* SOFA CIO locator. */

s = eraS06( tt1, tt2, x, y );

;/* Populate the context. */
eraApci, tt1, tt2, pvb, pvh[0,*], x, y, s, astrom ;
;/* Carry out the transformation and report the results. */
eraAtciq , rc, dc, pr, pd, px, rv, astrom, ri, di ;
reprd , "ICRS -> CIRS (JPL, IERS):", ri, di ;

b=replicate(ldbody,3)
;/* The same but with Saturn then Jupiter then Sun light deflection. */
b[0].bm = 0.00028574d;
b[0].dl = 3d-10;
b[0].pv[0,0] = -7.8101442680818964d;
b[0].pv[0,1] = -5.6095668114887358d;
b[0].pv[0,2] = -1.9807981923749924d;
b[0].pv[1,0] =  0.0030723248971152d;
b[0].pv[1,1] = -0.0040699547707598d;
b[0].pv[1,2] = -0.0018133584165345d;
b[1].bm = 0.00095435d;
b[1].dl = 3d-9;
b[1].pv[0,0] =  0.7380987962351833d;
b[1].pv[0,1] =  4.6365869247538951d;
b[1].pv[0,2] =  1.9693136030111202d;
b[1].pv[1,0] = -0.0075581692172088d;
b[1].pv[1,1] =  0.0012691372216750d;
b[1].pv[1,2] =  0.0007279990012801d;

b[2].bm = 1.0d;
b[2].dl = 6d-6;
b[2].pv[0,0] = -0.0007121743770509d;
b[2].pv[0,1] = -0.0023047830339257d;
b[2].pv[0,2] = -0.0010586596574639d;
b[2].pv[1,0] =  0.0000062923521264d;
b[2].pv[1,1] = -0.0000003308883872d;
b[2].pv[1,2] = -0.0000002964866231d;
eraAtciqn, rc, dc, pr, pd, px, rv, astrom, 3, b, ri, di ;
reprd , "ICRS -> CIRS (+ planets):", ri, di ;

;/* CIRS to ICRS (astrometric). */
eraAticqn, ri, di, astrom, 3, b, rca, dca ;
reprd , "CIRS -> astrometric:", rca, dca ;


return,0
end