function gv_erfaPLUV,mjd,rc,dc,pmra,pmdc,parallax,sysvel,dut1,lat,lon,elev,xp,yp,tel1,tel2,tel3,tel4,phpa=phpa,wl=wl,rh=rh,tc=tc,ucoord=ucoord,vcoord=vcoord,wcoord=wcoord,eu=eu_out,ev=ev_out,ew=ew_out,eaz=eaz_out,ezd=ezd_out,hob=hob
; Oliver Pfuhl 2017Aug01   Program to calculate UV coordinates from array location and object coordinates
  if n_elements(phpa) lt 1 then phpa=0d
  if n_elements(wl) lt 1 then wl=0d
  if n_elements(rh) lt 1 then rh=0d
  if n_elements(tc) lt 1 then tc=0d
  
  ; /* Step for finite difference, 10 arcsec chosen for optimal accuracy */
  eps = 10.0d / 3600.0d /180d*!dpi; // [rad]
  ez = [0.0d, 0.0d, 1.0d]; // Zenith direction in ENU frame
  baseline=dblarr(6,3)
  ;  /* Prepare centered finite differences
  ;  * eU corresponds to +RA
  ;  * eV corresponds to +DEC */
  h=dtp2s(+eps, 0.0d, rc, dc, ra=rcUp, dec=dcUp);
  h=dtp2s(-eps, 0.0d, rc, dc, ra=rcUm, dec=dcUm);
  h=dtp2s(0.0d, +eps, rc, dc, ra=rcVp, dec=dcVp);
  h=dtp2s(0.0d, -eps, rc, dc, ra=rcVm, dec=dcVm);
  signvec=[1d,1d,-1d]
  baseline[0,*]=tel1-tel2
  baseline[1,*]=tel1-tel3
  baseline[2,*]=tel1-tel4
  baseline[3,*]=tel2-tel3
  baseline[4,*]=tel2-tel4
  baseline[5,*]=tel3-tel4
  for i=0,5 do begin
    baseline[i,*]=baseline[i,*]*signvec
  endfor
  ;eraASTROM astrom;
  ucoord=dblarr(6,n_elements(mjd))
  vcoord=dblarr(6,n_elements(mjd))
  wcoord=dblarr(6,n_elements(mjd))
  eu_out=dblarr(3,n_elements(mjd))
  ev_out=dblarr(3,n_elements(mjd))
  ew_out=dblarr(3,n_elements(mjd))
  eaz_out=dblarr(3,n_elements(mjd))
  ezd_out=dblarr(3,n_elements(mjd))
  
  hob=dblarr(n_elements(mjd))
  astrom={astro, pmt:0d,eb:dblarr(3), eh:dblarr(3),em:0d,v:dblarr(3),bm1:0d,bpn:dblarr(3,3),along:0d,phi:0d,xpl:0d,ypl:0d,sphi:0d,cphi:0d,diurab:0d,eral:0d,refa:0d,refb:0d}
  
  for row=0,n_elements(mjd)-1 do begin
    dummy=eraApco13(2400000.5d, mjd[row], dut1, lon, lat, elev, xp, yp, phpa, tc, rh, wl, astrom, eo)
    
    ;added by OP to get hour angle
    astrom_copy=astrom
    ;dummy=get_hourangle(rc, dc, pmra, pmdc, parallax, sysvel, astrom_copy,hob=hob_)
    hob[row]= astrom.eral - rc;hob_;
    ;  /* Transform from celestial to intermediate, compute eU */
    dummy= eraAtcoq(rcUp, dcUp, pmra, pmdc, parallax, sysvel, astrom, enuob=enuobUp);
    dummy=eraAtcoq(rcUm, dcUm, pmra, pmdc, parallax, sysvel, astrom, enuob=enuobUm);
    
    eu=enuobUp-enuobUm;  difference (enuobUp, enuobUm, eu);
    norm=sqrt(total(eu^2d));  normalize (eu);
    norm=abs((rcup-rcum)*cos(dc));normlise to input vector to account for abberration and light deflection
    eu=eu/norm
    ;  /* Transform from celestial to intermediate, compute eV */
    dummy= eraAtcoq(rcVp, dcVp, pmra, pmdc, parallax, sysvel, astrom, enuob=enuobVp);
    dummy= eraAtcoq(rcVm, dcVm, pmra, pmdc, parallax, sysvel, astrom, enuob=enuobVm);
    ev=enuobVp-enuobVm;  difference (enuobVp, enuobVm, ev);
    norm=sqrt(total(ev^2d));  normalize (ev);
    norm=abs((dcvp-dcvm));normlise to input vector to account for abberration and light deflection
    ev=ev/norm;  normalize (ev);
    
    ;/* Transform from celestial to intermediate, compute eW */
    dummy=eraAtcoq(rc, dc, pmra, pmdc, parallax, sysvel, astrom, enuob=ew);
    ew=ew * (-1.0d)
    
    ;/* Using pointing and zenith directions, compute eAz */
    eaz=cross(ew,ez)
    norm=sqrt(total(eaz^2d));  normalize (eaz);
    eaz=eaz/norm
    
    ;/* Using pointing and azimuth directions, compute eZd */
    ezd=cross(ew, eaz);
    norm=sqrt(total(ezd^2d));  normalize (eaz);
    ezd=ezd/norm;
    
  
    for base =0,5 do begin
      uCoord[base,row] = eu[0] * baseline[base,0] + eu[1] * baseline[base,1] + eu[2] * baseline[base,2];
      vCoord[base,row] = ev[0] * baseline[base,0] + ev[1] * baseline[base,1] + ev[2] * baseline[base,2];
      wCoord[base,row] = ew[0] * baseline[base,0] + ew[1] * baseline[base,1] + ew[2] * baseline[base,2];
    endfor
    
    eu_out[*,row]=eu
    ev_out[*,row]=ev
    ew_out[*,row]=ew
    eaz_out[*,row]=eaz
    ezd_out[*,row]=ezd
  endfor
  return,1
end
