pro gravi_astrofit_plot,astrct=astrct,fitresult=fitresult,triangle=triangle,single=single,obs=obs,outname=outname,env=env,aux=aux
  ; Oliver Pfuhl 2016Apr04   Program to plot dual-field astrometric data
;
loadct,0
if n_elements(outname) lt 1 then outname='OPDFIT'
nel=n_elements(astrct)
nplot=200
fac=round(nel/nplot)
;if nel lt nplot then fac=1
vec=lindgen(nel/fac)*fac
model_tel=gvOPDModel(fitresult.result,astrct=astrct,obs=obs)
colorvec=['Crimson','lime green','sandy brown','purple','magenta','Blue']
nfiles=max(astrct.filenum+1)
noise={gd_sc_rms:dblarr(nfiles,6),gd_ft_rms:dblarr(nfiles,6),met_delta_rms:dblarr(nfiles,6),residual_rms:dblarr(nfiles,6),residual_tel_rms:dblarr(nfiles,6)}
for ifile=0,nfiles-1 do begin
  hh=where(astrct.filenum eq ifile)
   noise.gd_sc_rms[ifile,*]=stddev(astrct[hh].gd_sc,dimension=2,/nan)
   noise.gd_ft_rms[ifile,*]=stddev(astrct[hh].gd_ft,dimension=2,/nan)
   noise.residual_tel_rms[ifile,*]=stddev(astrct[hh].dopd_gd_tel-model_tel[hh].dopd,dimension=2,/nan) 
endfor
mjd0=min(astrct.mjd)
;
; cgPS_open, Filename=outname,landscape=1
 set_ps,outname+'.ps',/color
!P.Multi =0
;
; Page 0
plot,[0],[0],/nodata,color=cgcolor('white')
xstart=0.2
ystart=1.02-0.04
ystep=0.04
xstep=0.2
charsize=1
str='Array: '
xyouts,xstart,ystart,str,/normal,charsize=charsize
str=strtrim(obs.sta_name[0],2)+' '+strtrim(obs.sta_name[1],2)+' '+strtrim(obs.sta_name[2],2)+' '+strtrim(obs.sta_name[3],2)
xyouts,xstart+xstep,ystart,str,/normal,charsize=charsize
str='Resolution: '
xyouts,xstart,ystart-ystep,str,/normal,charsize=charsize
str=strtrim(obs.specmode[0],2)
xyouts,xstart+xstep,ystart-ystep,str,/normal,charsize=charsize
str='Polarisation: '
xyouts,xstart,ystart-2*ystep,str,/normal,charsize=charsize
str=strtrim(obs.polmode[0],2)
xyouts,xstart+xstep,ystart-2*ystep,str,/normal,charsize=charsize
str='MJD: '
xyouts,xstart,ystart-3*ystep,str,/normal,charsize=charsize
str=strtrim(mean(env.mjd[0]),2)
xyouts,xstart+xstep,ystart-3*ystep,str,/normal,charsize=charsize
;
ystart=ystart-5*ystep
charsize=0.8
ystep=0.03
for itarg=0,max(astrct.targnum) do begin
  ffind=where(astrct.targnum eq itarg )
  name=astrct[ffind[0]].target[0]+'-'+astrct[ffind[0]].target[1]
  str='Target '+strtrim(itarg+1,2)+': '
  xyouts,xstart,ystart-itarg*ystep,str,/normal,charsize=charsize
  str=name
  xyouts,xstart+xstep,ystart-itarg*ystep,str,/normal,charsize=charsize
endfor
xstep=0.03
ystart=ystart-5*ystep
str='Parameter'
xyouts,xstart+1*xstep,ystart-2*ystep,str,/normal,charsize=charsize
str='Error'
xyouts,xstart+10*xstep,ystart-2*ystep,str,/normal,charsize=charsize
str='Fixed'
xyouts,xstart+14*xstep,ystart-2*ystep,str,/normal,charsize=charsize
for ii=0,n_elements(fitresult.result)-1 do begin
  str=strtrim(fitresult.expl[ii],2)
  xyouts,xstart,ystart-3*ystep-ii*ystep,str,/normal,charsize=charsize
  str=fitresult.result[ii]
  xyouts,xstart+xstep,ystart-3*ystep-ii*ystep,str,/normal,charsize=charsize
  str='+/-'
  xyouts,xstart+6*xstep,ystart-3*ystep-ii*ystep,str,/normal,charsize=charsize
  str=fitresult.error[ii]
  xyouts,xstart+8*xstep,ystart-3*ystep-ii*ystep,str,/normal,charsize=charsize
  str=strtrim(fitresult.fixed[ii],2)
  xyouts,xstart+14*xstep,ystart-3*ystep-ii*ystep,str,/normal,charsize=charsize
endfor
str='!9c!X!lred!n: '
xyouts,xstart,ystart-(3+ii)*ystep,str,/normal,charsize=charsize
str=fitresult.redchi2
xyouts,xstart+xstep,ystart-(3+ii)*ystep,str,/normal,charsize=charsize
;
; Page 1
plot,[0],[0],/nodata,color=cgcolor('white')
charsize=0.7
ii=0
jj=0
xstep=0.04
ystep=0.03
xstart=0.01
ystart=0.88
for ii=0,n_elements(fitresult.corr[0,*])-1 do begin
  posx=xstart+0.05+ii*xstep
  posy=ystart-jj*ystep 
  str=fitresult.expl[ii]
  xyouts,posx,posy,str,/normal,charsize=charsize
endfor
for jj=0,n_elements(fitresult.corr[0,*])-1 do begin
  posx=xstart
  posy=ystart-0.04-(jj)*ystep 
  str=fitresult.expl[jj]
  xyouts,posx,posy,str,/normal,charsize=charsize
endfor
for ii=0,n_elements(fitresult.corr[0,*])-1 do begin
  posx=xstart+0.05+ii*xstep
  for jj=0,n_elements(fitresult.corr[0,*])-1 do begin
    posy=ystart-0.04-jj*ystep 
    str='...'
    if finite(fitresult.corr[ii,jj]) then str=strtrim(string(fitresult.corr[ii,jj],format='(F8.2)'),2)
    xyouts,posx,posy,str,/normal,charsize=0.6
    
  endfor
endfor
;
; Page 2
!P.Multi = [0, 2, 1]
ydata=astrct.dopd_gd_tel
plot,astrct.mjd[0]-mjd0,ydata,/nodata,color=cgcolor('black'),yrange=[min(ydata,/nan),max(ydata,/nan)],$
     ytitle='OPD [m]',xtitle='time [d + '+strtrim(string(mjd0),2) + ']',charsize=1
for i =0,5 do begin
  ydata=astrct.dopd_gd_tel[i]
  plotsym,0,0.9,thick=1
  oplot, astrct.mjd[0]-mjd0,ydata,color=cgcolor(colorvec[i]),psym=8
  plotsym,0,0.2,thick=2
  ydata=model_tel.dopd[i]
  oplot, astrct.mjd[0]-mjd0,ydata,color=cgcolor('black'),psym=8
endfor
xdata=astrct.ucoord
ydata=astrct.vcoord
mmin=min([min(abs(astrct.ucoord)),min(abs(astrct.vcoord))])*0.9
mmax=max([max(abs(astrct.ucoord)),max(abs(astrct.vcoord))])*1.2
plot,xdata,ydata,/nodata,color=cgcolor('black'),xrange=[-mmax,mmax],yrange=[-mmax,mmax],/ystyle,/xstyle,ytitle='V [m]',xtitle='U [m]',/isotropic,charsize=1
for i =0,5 do begin
  xdata=astrct.ucoord[i]
  ydata=astrct.vcoord[i]
  plotsym,0,0.9,thick=1
  oplot, xdata,ydata,color=cgcolor(colorvec[i]),psym=8
  oplot, -1.*xdata,-1.*ydata,color=cgcolor(colorvec[i]),psym=8
  str=astrct[0].sta_name[0,i]+'-'+astrct[0].sta_name[1,i]+': '+strtrim(string(obs.baseline[i],format='(F7.2)'),2)+' m'
  xyouts,0.4*mmax,0.90*mmax -i*0.08*mmax,str,charsize=0.7,color=cgcolor(colorvec[i])
endfor
oplot,[1.*mmax*obs.dra,-1.*mmax*obs.dra],[-1.*mmax*obs.ddec,1.*mmax*obs.ddec]
;
; Page 3
nplot2=10
fac2=round(nel/nplot2)
;if nel lt nplot then fac=1
pltv=lindgen(nel/fac2)*fac2
!P.Multi = [0, 2, 3]
!Y.OMargin = 0; [2, 8]
!X.OMargin = 0;[2, 6]
!P.Charsize=1.20
colorvec2=strarr(n_elements(astrct))
colorvec2[*]='blue'
;
if where(astrct.swapstate lt 0.) ne [-1] then colorvec2[where(astrct.swapstate lt 0.)]='Crimson'
plotsym,0,0.3,thick=1
for base=0,5 do begin
 ydata=(astrct.dopd_gd_tel[base]+fitresult.basemet[base])*astrct.swapstate
 yrange=[min(ydata,/nan),max(ydata,/nan)]
symsize=0.5
    plot,astrct.mjd[0]-mjd0,ydata,/xstyle,yrange=yrange,/nodata,title=astrct[0].sta_name[0,base]+'-'+astrct[0].sta_name[1,base],$
      ytitle='OPD [m]',xtitle='time [d + '+strtrim(string(mjd0),2) + ']',color=cgcolor('black')
     
    hhhh=where(astrct.swapstate lt 0 )
    if hhhh ne [-1] then begin
      oplot,[astrct[hhhh].mjd[0]-mjd0],[ydata[hhhh]],color=cgcolor('Crimson'),psym=1,symsize=symsize
    endif
;    
    hhhh=where(astrct.swapstate gt 0 )
    if hhhh ne [-1] then begin
      oplot,[astrct[hhhh].mjd[0]-mjd0],[ydata[hhhh]],color=cgcolor('blue'),psym=1,symsize=symsize
    endif
endfor
;
; Page 4
for base=0,5 do begin
  ydata=(astrct.dopd_gd_tel[base]) -model_tel.dopd[base]
  dx=max(astrct.mjd[0]-mjd0)-min(astrct.mjd[0]-mjd0)
  xrange=[min(astrct.mjd[0]-mjd0)-dx*0.07,max(astrct.mjd[0]-mjd0)+dx*0.07]
  yrange=[-2e-6,2e-6]
  dy=max(yrange)-min(yrange)
  symsize=0.6
  plot,astrct.mjd[0]-mjd0,ydata,/xstyle,/ystyle,yrange=yrange,xrange=xrange,/nodata, $
	  title=astrct[0].sta_name[0,base]+'-'+astrct[0].sta_name[1,base],$
    	  ytitle='Residual (Tel) [m]',xtitle='time [d + '+strtrim(string(mjd0),2) + ']',color=cgcolor('black')
  hhhh=where(astrct.swapstate lt 0 )
  if hhhh ne [-1] then begin
    oplot,[astrct[hhhh].mjd[0]-mjd0],[ydata[hhhh]],color=cgcolor('Crimson'),psym=1,symsize=symsize
  endif
  ;
  hhhh=where(astrct.swapstate gt 0 )
  if hhhh ne [-1] then begin
    oplot,[astrct[hhhh].mjd[0]-mjd0],[ydata[hhhh]],color=cgcolor('blue'),psym=1,symsize=symsize
  endif
; 
  rms_str='Total RMS: ' +strtrim(string(stddev(ydata[*]*1d9,/nan),format='(F6.1)'),2)+' nm'
  mean_str='Mean: ' +strtrim(string(mean(ydata[*]*1d9,/nan),format='(F7.1)'),2)+' nm'
 ; median_str='Median: ' +strtrim(string(median(ydata[*]*1d9),format='(F7.1)'),2)+' nm'
   noise_str='Noise RMS: ' +strtrim(string((noise.residual_tel_rms[base]*1d9),format='(F7.1)'),2)+' nm'
  xyouts,0.1*max(astrct.mjd[0]-mjd0),0.84*(yrange[1]-yrange[0])+yrange[0],noise_str,charsize=0.6,color=cgcolor('black')
  xyouts,0.1*max(astrct.mjd[0]-mjd0),0.77*(yrange[1]-yrange[0])+yrange[0],rms_str,charsize=0.6,color=cgcolor('black')
  xyouts,0.1*max(astrct.mjd[0]-mjd0),0.7*(yrange[1]-yrange[0])+yrange[0],mean_str,charsize=0.6,color=cgcolor('black')
  
  for ifile=0,max(astrct.filenum) do begin
    findf=where(astrct.filenum eq ifile)
    str=astrct[findf[0]].target[0]+'-'+astrct[findf[0]].target[1]
    xyouts,[astrct[findf[0]].mjd[0]-mjd0]-0.03*dx, mean(yrange)+0.43 *dy*(-1)^ifile,str,charsize=0.5,color=cgcolor('black')
  endfor
endfor
;
; Page 5
for base=0,5 do begin
  ydata=astrct.gd_sc[base]
  ymax=max(abs(ydata),/nan)
  yrange=[-ymax,ymax]
  symsize=0.6
  plot,astrct.mjd[0]-mjd0,ydata,/xstyle,/ystyle,yrange=yrange,/nodata,title=astrct[0].sta_name[0,base]+'-'+astrct[0].sta_name[1,base],$
    ytitle='GD SC [m]',xtitle='time [d + '+strtrim(string(mjd0),2) + ']',color=cgcolor('black')
  hhhh=where(astrct.swapstate lt 0 )
  if hhhh ne [-1] then begin
    oplot,[astrct[hhhh].mjd[0]-mjd0],[ydata[hhhh]],color=cgcolor('Crimson'),psym=1,symsize=symsize
  endif
  ;
  hhhh=where(astrct.swapstate gt 0 )
  if hhhh ne [-1] then begin
    oplot,[astrct[hhhh].mjd[0]-mjd0],[ydata[hhhh]],color=cgcolor('blue'),psym=1,symsize=symsize
  endif
endfor
;
; Page 6
for base=0,5 do begin
  ydata=astrct.gd_ft[base]
  ymax=max(abs(ydata),/nan)
  yrange=[-ymax,ymax]
  symsize=0.6
  plot,astrct.mjd[0]-mjd0,ydata,/xstyle,/ystyle,yrange=yrange,/nodata,title=astrct[0].sta_name[0,base]+'-'+astrct[0].sta_name[1,base],$
    ytitle='GD FT [m]',xtitle='time [d + '+strtrim(string(mjd0),2) + ']',color=cgcolor('black')
  hhhh=where(astrct.swapstate lt 0 )
  if hhhh ne [-1] then begin
    oplot,[astrct[hhhh].mjd[0]-mjd0],[ydata[hhhh]],color=cgcolor('Crimson'),psym=1,symsize=symsize
  endif
  ;
  hhhh=where(astrct.swapstate gt 0 )
  if hhhh ne [-1] then begin
    oplot,[astrct[hhhh].mjd[0]-mjd0],[ydata[hhhh]],color=cgcolor('blue'),psym=1,symsize=symsize
  endif
endfor
;
; Page 7
if mean(astrct.opd_met_fc_corr) ne [0] then begin
for base=0,5 do begin
  ;ydata=astrct.met_delta[base]
  ydata=astrct.opd_met_fc_corr[base]
  ymax=max(abs(ydata),/nan)
  yrange=[-2.0e-6,2.0e-6]
  symsize=0.6
  plot,astrct.mjd[0]-mjd0,ydata,/xstyle,/ystyle,yrange=yrange,/nodata,title=astrct[0].sta_name[0,base]+'-'+astrct[0].sta_name[1,base],$
    ytitle='OPD_MET_FC_CORR [m]',xtitle='time [d + '+strtrim(string(mjd0),2) + ']',color=cgcolor('black')
  hhhh=where(astrct.swapstate lt 0 )
  if hhhh ne [-1] then begin
    oplot,[astrct[hhhh].mjd[0]-mjd0],[ydata[hhhh]],color=cgcolor('Crimson'),psym=1,symsize=symsize
  endif
  ;
  hhhh=where(astrct.swapstate gt 0 )
  if hhhh ne [-1] then begin
    oplot,[astrct[hhhh].mjd[0]-mjd0],[ydata[hhhh]],color=cgcolor('blue'),psym=1,symsize=symsize
  endif
  ;noise_str='Noise RMS: ' +strtrim(string(mean(noise.met_delta_rms[*,base],/nan)*1d9,format='(F6.1)'),2)+' nm'
  rms_str='RMS: ' +strtrim(string(stddev(ydata[*]*1d9,/nan),format='(F7.1)'),2)+' nm'
  ;xyouts,0.1*max(astrct.mjd[0]-mjd0),0.84*(yrange[1]-yrange[0])+yrange[0],noise_str,charsize=0.6,color=cgcolor('black')
  xyouts,0.1*max(astrct.mjd[0]-mjd0),0.77*(yrange[1]-yrange[0])+yrange[0],rms_str,charsize=0.6,color=cgcolor('black')
endfor
endif
;
; Page 8
if mean(astrct.OPD_MET_TELFC_MCORR) ne [0] then begin
  for base=0,5 do begin
    ;ydata=astrct.met_delta[base]
    ydata=astrct.OPD_MET_TELFC_MCORR[base]
    ymax=max(abs(ydata))
    yrange=[-2.0e-6,2.0e-6]
    symsize=0.6
    plot,astrct.mjd[0]-mjd0,ydata,/xstyle,/ystyle,yrange=yrange,/nodata,title=astrct[0].sta_name[0,base]+'-'+astrct[0].sta_name[1,base],$
      ytitle='OPD_MET_TELFC_MCORR [m]',xtitle='time [d + '+strtrim(string(mjd0),2) + ']',color=cgcolor('black')
    hhhh=where(astrct.swapstate lt 0 )
    if hhhh ne [-1] then begin
      oplot,[astrct[hhhh].mjd[0]-mjd0],[ydata[hhhh]],color=cgcolor('Crimson'),psym=1,symsize=symsize
    endif
    ;
    hhhh=where(astrct.swapstate gt 0 )
    if hhhh ne [-1] then begin
      oplot,[astrct[hhhh].mjd[0]-mjd0],[ydata[hhhh]],color=cgcolor('blue'),psym=1,symsize=symsize
    endif
    ;noise_str='Noise RMS: ' +strtrim(string(mean(noise.met_delta_rms[*,base],/nan)*1d9,format='(F6.1)'),2)+' nm'
    rms_str='RMS: ' +strtrim(string(stddev(ydata[*]*1d9,/nan),format='(F7.1)'),2)+' nm'
    ;xyouts,0.1*max(astrct.mjd[0]-mjd0),0.84*(yrange[1]-yrange[0])+yrange[0],noise_str,charsize=0.6,color=cgcolor('black')
    xyouts,0.1*max(astrct.mjd[0]-mjd0),0.77*(yrange[1]-yrange[0])+yrange[0],rms_str,charsize=0.6,color=cgcolor('black')
  endfor
endif
;
; Page 9
if obs.polmode eq 'SPLIT' then begin
  for base=0,5 do begin
    ;ydata=astrct.gd_ft_pol_delta[base]
    ydata=astrct.gd_ft[base]-astrct.gd_ft_pol2[base]
    ymax=max(abs(ydata))
    yrange=[-2e-6,2e-6]
    symsize=0.6
    plot,astrct.mjd[0]-mjd0,ydata,/xstyle,/ystyle,yrange=yrange,/nodata, $
	    title=astrct[0].sta_name[0,base]+'-'+astrct[0].sta_name[1,base],$
      ytitle='GD!lFT,P1!n-GD!lFT,P2!n [m]',xtitle='time [d + '+strtrim(string(mjd0),2) + ']',color=cgcolor('black')
    hhhh=where(astrct.swapstate lt 0 )
    if hhhh ne [-1] then begin
      oplot,[astrct[hhhh].mjd[0]-mjd0],[ydata[hhhh]],color=cgcolor('Crimson'),psym=1,symsize=symsize
    endif
    ;
    hhhh=where(astrct.swapstate gt 0 )
    if hhhh ne [-1] then begin
      oplot,[astrct[hhhh].mjd[0]-mjd0],[ydata[hhhh]],color=cgcolor('blue'),psym=1,symsize=symsize
    endif
    ; noise_str='Noise RMS: ' +strtrim(string(mean(noise.met_delta_rms[*,base],/nan)*1d9,format='(F6.1)'),2)+' nm'
    rms_str='RMS: ' +strtrim(string(stddev(ydata[*]*1d9,/nan),format='(F7.1)'),2)+' nm'
    ; xyouts,0.1*max(astrct.mjd[0]-mjd0),0.84*(yrange[1]-yrange[0])+yrange[0],noise_str,charsize=0.6,color=cgcolor('black')
    xyouts,0.1*max(astrct.mjd[0]-mjd0),0.77*(yrange[1]-yrange[0])+yrange[0],rms_str,charsize=0.6,color=cgcolor('black')
  endfor  
  
; Page 10
  for base=0,5 do begin
  ;ydata=astrct.gd_pol_delta[base]
  ydata=astrct.gd_sc[base]-astrct.gd_sc_pol2[base]
  ymax=max(abs(ydata))
  yrange=[-2e-6,2e-6]
  symsize=0.6
  
  plot,astrct.mjd[0]-mjd0,ydata,/xstyle,/ystyle,yrange=yrange,/nodata, $
	  title=astrct[0].sta_name[0,base]+'-'+astrct[0].sta_name[1,base],$
    ytitle='GD!lSC,P1!n-GD!lSC,P2!n [m]',xtitle='time [d + '+strtrim(string(mjd0),2) + ']',color=cgcolor('black')
  hhhh=where(astrct.swapstate lt 0 )
  if hhhh ne [-1] then begin
    oplot,[astrct[hhhh].mjd[0]-mjd0],[ydata[hhhh]],color=cgcolor('Crimson'),psym=1,symsize=symsize
  endif
  ;
  hhhh=where(astrct.swapstate gt 0 )
  if hhhh ne [-1] then begin
    oplot,[astrct[hhhh].mjd[0]-mjd0],[ydata[hhhh]],color=cgcolor('blue'),psym=1,symsize=symsize
  endif
 ; noise_str='Noise RMS: ' +strtrim(string(mean(noise.met_delta_rms[*,base],/nan)*1d9,format='(F6.1)'),2)+' nm'
  rms_str='RMS: ' +strtrim(string(stddev(ydata[*]*1d9,/nan),format='(F7.1)'),2)+' nm'
 ; xyouts,0.1*max(astrct.mjd[0]-mjd0),0.84*(yrange[1]-yrange[0])+yrange[0],noise_str,charsize=0.6,color=cgcolor('black')
  xyouts,0.1*max(astrct.mjd[0]-mjd0),0.77*(yrange[1]-yrange[0])+yrange[0],rms_str,charsize=0.6,color=cgcolor('black')
  
  endfor
  
; Page 11
  for base=0,5 do begin
  ;ydata=astrct.gd_ft_pol_delta[base]-astrct.gd_pol_delta[base]
  ydata=(astrct.gd_ft[base]-astrct.gd_ft_pol2[base])-(astrct.gd_sc[base]-astrct.gd_sc_pol2[base])
  ymax=max(abs(ydata))
  yrange=[-2e-6,2e-6]
  symsize=0.6
  plot,astrct.mjd[0]-mjd0,ydata,/xstyle,/ystyle,yrange=yrange,/nodata,title=astrct[0].sta_name[0,base]+'-'+astrct[0].sta_name[1,base],$
    ytitle='GD!lFT,P1!n-GD!lFT,P2!n - GD!lSC,P1!n-GD!lSC,P2!n [m]',xtitle='time [d + '+strtrim(string(mjd0),2) + ']',color=cgcolor('black')
  hhhh=where(astrct.swapstate lt 0 )
  if hhhh ne [-1] then begin
    oplot,[astrct[hhhh].mjd[0]-mjd0],[ydata[hhhh]],color=cgcolor('Crimson'),psym=1,symsize=symsize
  endif
  ;
  hhhh=where(astrct.swapstate gt 0 )
  if hhhh ne [-1] then begin
    oplot,[astrct[hhhh].mjd[0]-mjd0],[ydata[hhhh]],color=cgcolor('blue'),psym=1,symsize=symsize
  endif
  ; noise_str='Noise RMS: ' +strtrim(string(mean(noise.met_delta_rms[*,base],/nan)*1d9,format='(F6.1)'),2)+' nm'
  rms_str='RMS: ' +strtrim(string(stddev(ydata[*]*1d9,/nan),format='(F7.1)'),2)+' nm'
  ; xyouts,0.1*max(astrct.mjd[0]-mjd0),0.84*(yrange[1]-yrange[0])+yrange[0],noise_str,charsize=0.6,color=cgcolor('black')
  xyouts,0.1*max(astrct.mjd[0]-mjd0),0.77*(yrange[1]-yrange[0])+yrange[0],rms_str,charsize=0.6,color=cgcolor('black')
  endfor
endif
;
; Page 12
!P.Multi = [0, 2, 2]
ydata=env.seeing
plot,env.mjd-mjd0,ydata,/xstyle,/ystyle,title='Seeing',$
  ytitle='Seeing ["]',xtitle='time [d + '+strtrim(string(mjd0),2) + ']',color=cgcolor('black'),symsize=0.5
;ydata=env.anisopl[0]
;plot,env.mjd-mjd0,ydata,/xstyle,/ystyle,title='Anisoplanatism',$
;    ytitle='Residual tilt [!9m!Xas /s!u1/2!n]',yrange=[min(env.anisopl)*0.9,max(env.anisopl)*1.1],xtitle='time [d + '+strtrim(string(mjd0),2) + ']',color=cgcolor('black'),symsize=0.5,/nodata
;   for ibase=0,5 do begin
;    ydata=env.anisopl[ibase]
;    oplot,env.mjd-mjd0,ydata,color=cgcolor(colorvec[ibase])
;    endfor 
ydata=env.anisopl[0]*obs.baseline[0] /1e6/3600./180. * !pi *1e9
plot,env.mjd-mjd0,ydata,/xstyle,/ystyle,title='Anisoplanatism',$
      ytitle='!9d!XOPD [nm s!u1/2!n]',yrange=[0,250],xtitle='time [d + '+strtrim(string(mjd0),2) + ']',color=cgcolor('black'),symsize=0.5,/nodata
    for ibase=0,5 do begin
      ydata=env.anisopl[ibase]*obs.baseline[ibase] /1e6/3600./180. * !pi *1e9
      oplot,env.mjd-mjd0,ydata,color=cgcolor(colorvec[ibase])
    endfor
ydata=env.tau0
plot,env.mjd-mjd0,ydata,/xstyle,/ystyle,title='Tau0',$
    ytitle='Tau0 [s]',xtitle='time [d + '+strtrim(string(mjd0),2) + ']',color=cgcolor('black'),symsize=0.5
  ydata=env.temp
plot,env.mjd-mjd0,ydata,/xstyle,/ystyle,title='Temperature',$
    ytitle='Temperature [K]',xtitle='time [d + '+strtrim(string(mjd0),2) + ']',color=cgcolor('black'),symsize=0.5
;
; Page 13
!P.Multi = [0, 3, 2]
for base=0,5 do begin
  ydata=astrct.met_delta[base]
  symsize=0.6
   for ifile=0,nfiles-1 do begin
     hh=where(astrct.filenum eq ifile)
     ydata[hh]=ydata[hh]-mean(ydata[hh])
   endfor
 if stddev(ydata) ne 0. then begin
  histogauss,ydata*1e9,bb,title=astrct[0].sta_name[0,base]+'-'+astrct[0].sta_name[1,base],$
    ytitle='#',xtitle='Met delta [nm]',color=cgcolor('black'),charsize=0.7,xrange=[-300,300],/xstyle,/nofit
endif     
endfor
;
; Page 14
!P.Multi = [0, 3, 2]
for base=0,5 do begin
  ydata=astrct.dopd_gd_tel[base]-model_tel.dopd[base]
  symsize=0.6
  for ifile=0,nfiles-1 do begin
    hh=where(astrct.filenum eq ifile)
    ydata[hh]=ydata[hh]-mean(ydata[hh],/nan)
  endfor
 ; plot,astrct.mjd[0]-mjd0,ydata,/xstyle,/ystyle,yrange=[-2e-6,2e-6],title=astrct[0].sta_name[0,base]+'-'+astrct[0].sta_name[1,base],$
 ;   ytitle='Met delta [m]',xtitle='time [d + '+strtrim(string(mjd0),2) + ']',color=cgcolor('black'),psym=1,symsize=symsize
  histogauss,ydata*1e9,bb,title=astrct[0].sta_name[0,base]+'-'+astrct[0].sta_name[1,base],$
    ytitle='#',xtitle='GD Residual (Tel) [nm]',color=cgcolor('black'),charsize=0.7,xrange=[-600,600],/xstyle
endfor
;
; Page 15
for base=0,5 do begin
  ydata=astrct.dopd_gd_tel[base]-model_tel.dopd[base]
  symsize=0.6
  plot,astrct.pupil_opd[base],yrange=[-5e-7,5e-7],title=astrct[0].sta_name[0,base]+'-'+astrct[0].sta_name[1,base],ytitle='OPD [m]',xtitle='# frame',$
    charsize=0.7
  oplot,astrct.met_Delta[base],psym=4,symsize=symsize,color=cgcolor('orange')
  oplot,astrct.opd_met_fc_corr[base],psym=4,symsize=symsize,color=cgcolor('gray')
  oplot,astrct.opd_met_telfc_mcorr[base],psym=4,symsize=symsize,color=cgcolor('green')
endfor
xyouts,0.8,0.96,'PUPIL_OPD',/normal,color=cgcolor('black'),charsize=0.7
xyouts,0.8,0.94,'MET_DELTA',/normal,color=cgcolor('orange'),charsize=0.7
xyouts,0.8,0.92,'OPD_MET_FC_CORR',/normal,color=cgcolor('gray'),charsize=0.7
xyouts,0.8,0.90,'OPD_MET_TELFC_MCORR',/normal,color=cgcolor('green'),charsize=0.7
;
if n_elements(aux) gt 0 then begin
    !P.Multi = [0, 2, 2]
    for tel=0,3 do begin
      xdata=aux.fiber_dx[tel]
      ydata=aux.fiber_dy[tel]
      symsize=0.6
      plot,xdata,ydata,title='GV'+strtrim(string(tel+1),2)+' AcqCam-Fiber ',ytitle='dy [pix]',xtitle='dx [pix]',/isotropic,xrange=[-2,2],yrange=[-2,2],$
        charsize=0.7,psym=3
        scat=stddev(xdata)
        mm=mean(xdata)
        str='x: '+strtrim(string(mm,format='(F10.2)'),2) + ' +/- '+strtrim(string(scat,format='(F10.2)'),2)    
        xyouts,-1.,1.8,str,charsize=charsize
        scat=stddev(ydata)
        mm=mean(ydata)
        str='y: '+strtrim(string(mm,format='(F10.2)'),2) + ' +/- '+strtrim(string(scat,format='(F10.2)'),2)
        xyouts,-1.,1.6,str,charsize=charsize
    endfor
endif
;
  
; Page 16
; Pupil offsets----------------
if n_elements(aux) gt 0 then begin
  !P.Multi = [0, 2, 2]
  
  for tel=0,3 do begin
    xdata=aux.PUPIL_U[tel]
    ydata=aux.PUPIL_V[tel]
    symsize=0.6
    plot,xdata,ydata,title='GV'+strtrim(string(tel+1),2)+' PUPIL ',ytitle='V [m]',xtitle='U [m]',/isotropic,xrange=[-0.02,0.02],yrange=[-0.02,0.02],$
      charsize=0.7,psym=3
    scat=stddev(xdata)*1000
    mm=mean(xdata)*1000
    str='x: '+strtrim(string(mm,format='(F10.2)'),2) + ' +/- '+strtrim(string(scat,format='(F10.2)'),2)+ ' mm'
    xyouts,-0.01,0.018,str,charsize=charsize
    scat=stddev(ydata)*1000
    mm=mean(ydata)*1000
    str='y: '+strtrim(string(mm,format='(F10.2)'),2) + ' +/- '+strtrim(string(scat,format='(F10.2)'),2)+ ' mm'
    xyouts,-0.01,0.016,str,charsize=charsize
    
  endfor
  
endif
;
; Page 17
!P.Multi = 0
!P.Charsize=1.
if n_elements(triangle) gt 0 then begin
  range=max([max(triangle.x)-min(triangle.x),max(triangle.y)-min(triangle.y)]) *2.5
  plot,triangle.x,triangle.y,/nodata,xrange=[median(triangle.x)-range/2,median(triangle.x)+range/2],yrange=[median(triangle.y)-range/2,median(triangle.y)+range/2],$
    /isotropic,title='Closure triangles',/xstyle,/ystyle
  for i=0,n_elements(triangle)-1 do begin
    oploterror,triangle[i].x,triangle[i].y,triangle[i].x_err,triangle[i].y_err,color=cgcolor('gray'),errcolor=cgcolor('gray')
    str=triangle[i].array_name
    xyouts,triangle[i].x+0.03*range,triangle[i].y+0.03*range,str,charsize=0.6,color=cgcolor('gray')
  endfor
  oploterror,fitresult.x,fitresult.y,fitresult.x_err,fitresult.y_err
  str=fitresult.array_name
  xyouts,fitresult.x+0.03*range,fitresult.y+0.03*range,str,charsize=0.6
  
endif
if n_elements(single) gt 0 then begin
  range=max([max(single.x)-min(single.x),max(single.y)-min(single.y)]) *2.5
  plot,single.x,triangle.y,/nodata,xrange=[median(single.x)-range/2,median(single.x)+range/2],yrange=[median(single.y)-range/2,median(single.y)+range/2],$
    /isotropic,title='Single baselines',/xstyle,/ystyle
  for i=0,n_elements(single)-1 do begin
    oploterror,single[i].x,single[i].y,single[i].x_err,single[i].y_err,color=cgcolor(colorvec[i]),errcolor=cgcolor(colorvec[i])
    str=single[i].array_name
    xyouts,single[i].x+0.03*range,single[i].y+0.03*range,str,charsize=0.6,color=cgcolor(colorvec[i])
  endfor
  oploterror,fitresult.x,fitresult.y,fitresult.x_err,fitresult.y_err
  str=fitresult.array_name
  xyouts,fitresult.x+0.03*range,fitresult.y+0.03*range,str,charsize=0.6
endif
;cgPS_close, /PDF,/Delete_PS, UNIX_CONVERT_CMD='pstopdf'
;SPAWN,'/usr/bin/ps2pdf '+outname
;SPAWN,'/usr/local/bin/ps2pdf '+outname
;file_delete,outname
 device,/close
!P.Multi = 0
end
;-------------------------------------------------------------------------------
