function gv_abberration,mjd,elong,phi,hm,xp,yp,ri,di,rc,dc,dra0=dra0,ddec0=ddec0,dRA_abb=dRA_abb,dDEC_abb=dDEC_abb


r_gcrs1=ri
d_gcrs1=di

  
  utc1=2400000.5d
  
  
  ;  /* Star-independent astrometry parameters. */
  pv=dblarr(2,3)
  
  sp=0d
  sp=eraSp00(utc1,mjd)
 theta=eraEra00(utc1,mjd) ;earth rotation angle
 
 eraPvtob,elong,phi,hm,xp,yp,sp,theta,pv  ;pv local position and velocity
 ;pv=dblarr(2,3)
 eraAPCS13,utc1,mjd,pv,astrom; conversion ICRS-GCRS 
 
 eraAticq,r_gcrs1,d_gcrs1,astrom,r_icrs1,d_icrs1
 
 rc=r_icrs1
 dc=d_icrs1
 
if keyword_set(dra0) then begin
  dra_gcrs=dra0/3600d /180d *!dpi
  ddec_gcrs=ddec0/3600d /180d *!dpi
  dist_gcrs=sqrt(dra_gcrs^2d + ddec_gcrs^2d)
  angle_gcrs=atan(dra_gcrs,ddec_gcrs)
  
  r_gcrs2=r_gcrs1+dra_gcrs/cos(d_gcrs1)
  d_gcrs2=d_gcrs1+ddec_gcrs
  

   sphcoord,r_gcrs1,d_gcrs1,dist_gcrs,angle_gcrs,r_gcrs2,d_gcrs2
 eraAticq,r_gcrs2,d_gcrs2,astrom,r_icrs2,d_icrs2
  
  POSANG,0,r_icrs1,d_icrs1,r_icrs2,d_icrs2,angle_icrs
  GCIRC, 0,r_icrs1,d_icrs1,r_icrs2,d_icrs2, DISt_icrs
  

  
  dra_icrs=sin(angle_icrs)*dist_icrs
  ddec_icrs=dist_icrs *cos(angle_icrs)
  
  dra_icrs=(r_icrs2-r_icrs1)*cos(d_gcrs1)
  ddec_icrs=d_icrs2-d_icrs1
  
  
  diffra_abb=(dra_icrs - dra_gcrs)/!dpi*180d *3600d *1e6
  diffdec_abb=(ddec_icrs - ddec_gcrs)/!dpi*180d *3600d *1e6 

  
  dra_abb=dra_icrs/dra_gcrs
 ddec_abb=ddec_icrs/ddec_gcrs
 
 
 
 print,'delta RA (ICRS - GCRS):',  diffra_abb
  print,'delta DEC (ICRS - GCRS):',diffdec_abb
  print,'Scale RA (ICRS / GCRS):',  dra_abb
  print,'Scale DEC (ICRS / GCRS):',ddec_abb
 
  
 endif 
 
return,1

end