function circular_average,angle_vec,dimension=dimension,deg=deg

if n_elements(dimension) lt 1 then dimension=1
if n_elements(deg) lt 1 then deg=0

if deg then begin
  fac=!dpi/180d
endif else begin
  fac=1d
endelse

tmp=total(exp(complex(0d,angle_vec*fac,/double)),dimension)
result=atan(imaginary(tmp),real_part(tmp))/fac
return,result
end