;-------------------------------------------------------------------------------
function getTelMetModel,metxpos,metypos,lambda,metang,pupilphase, $
	AstigmAmplitude,AstigmTheta,rmax,opd_pickup_offset,opd_focus_offset, $
	swapstate,eaz,ezd,eu,ev,fiber_du,fiber_dv,astigm_phase=astigm_phase
;
  nframes=n_elements(metang)
  modelcplx=complexarr(nframes,4)
  diff=complexarr(nframes,4)
  diffphase_ppl=fltarr(nframes,4)
  diffphase=fltarr(nframes,4)
  astigm_phase=fltarr(nframes,4)
  met_telfc_corr_new=fltarr(nframes,4)
;  
  vector1=dblarr(nframes,3)
  vector2=dblarr(nframes,3)
  vector3=dblarr(nframes,3)
  vector4=dblarr(nframes,3)
  sep=sqrt(fiber_du^2. + fiber_dv^2.)
;
  for idiode =0,3 do begin
;  
    diodeang=atan(-metypos[idiode],-metxpos[idiode])
    astang= metang - diodeang + AstigmTheta
    astradius = sqrt(metxpos[idiode]^2. + metypos[idiode]^2.) / rmax; /* normalized */
    astigm = AstigmAmplitude * sqrt(6.) * astradius * astradius * sin(2. * astang); /* in meter */
    astigm_phase[*,idiode]=astigm/lambda*2.*!pi
;    
    for ii=0,2 do vector1[*,ii]=metxpos[idiode] * eaz[ii,*]
    for ii=0,2 do vector2[*,ii]=metypos[idiode] * ezd[ii,*]
    for ii=0,2 do vector3[*,ii]=fiber_du * eu[ii,*] ;*swapstate;CHANGE
    for ii=0,2 do vector4[*,ii]=fiber_dv * ev[ii,*] ;*swapstate;CHANGE
    vector1=vector1+vector2
    vector3=vector3+vector4
    deproject = vector1[*,0]*vector3[*,0]+vector1[*,1]*vector3[*,1]+vector1[*,2]*vector3[*,2]
    deproject = deproject /1000d / 3600. / 360. * 2d*!pi; /* convert in meter */
    modelcplx[*,idiode]=exp(complex(0,(2d*!pi /lambda *(-deproject) ) ) )
    modelcplx[*,idiode]=modelcplx[*,idiode]*exp(complex(0,(1d*pupilphase) ) )*exp(complex(0,(1d*astigm_phase[*,idiode]) ) ) $
      *exp(complex(0,(1d*opd_pickup_offset*sep/lambda*2.*!pi) ) ) *exp(complex(0,(1d*opd_focus_offset/lambda*2.*!pi) ) )
    modelphase=atan(imaginary(modelcplx[*,idiode]),real_part(modelcplx[*,idiode]))
;    
  endfor
;
return,modelcplx
;  
end
;-------------------------------------------------------------------------------
function getMetReceiver,hdprim,teltype
;
strct=replicate({xpos:fltarr(4),ypos:fltarr(4),wl_laser:0d,drotoff:0.,TEL_NAME:''},4)
diode=mrdfits('/usr/share/esopipes/datastatic/gravity-1.4.0/GRAVI_DIODE_POSITION.fits',1,/silent)
for i=0,3 do begin
  for j=0,3 do begin
    str='MET '+teltype+strtrim(string(4-i),2)+' REC'+strtrim(string(j+1),2);was j+1
    ;strct[i].xpos[j]=1.*ESOkeyword(hdprim,str+'X')
   ; strct[i].ypos[j]=1.*ESOkeyword(hdprim,str+'Y')
    if teltype eq 'AT' then begin
       strct[i].xpos[j]=diode[3-i].recx[j]
       strct[i].ypos[j]=diode[3-i].recy[j]
    endif
    if teltype eq 'UT' then begin
      strct[i].xpos[j]=diode[7-i].recx[j]
      strct[i].ypos[j]=diode[7-i].recy[j]
    endif
    
  endfor
   strct[i].tel_name=teltype+strtrim(string(4-i),2)
   strct[i].wl_laser=(ESOkeyword(hdprim,'INS MLAS LWAV'))/1d9
   if strct[i].wl_laser eq 0. then strct[i].wl_laser =1.908287d-6
   strct[i].drotoff=ESOkeyword(hdprim,'INS DROTOFF'+strtrim(string(4-i),2))
endfor
;
return,strct
;
end
;-------------------------------------------------------------------------------
function MapFiberOffset,metxpos,metypos,lambda,metang,pupilphase, $
	AstigmAmplitude,AstigmTheta,rmax,opd_pickup_offset,opd_focus_offset, $
	swapstate,eaz,ezd,eu,ev,fiber_du,fiber_dv,datacplx,ang,imscale
;
nel=n_elements(metang)
resol=1
nsteps=15*resol
teltype='AT'
case teltype of
  'AT': step=0.5 ;[pix]
  'UT': step=0.5; [pix]
  else: step=0.1
endcase
      dra_Step=(findgen(nsteps)-(nsteps-1)/2)*step
      ddec_step=(findgen(nsteps)-(nsteps-1)/2)*step
      pos=fltarr(nsteps,nsteps,2)
      map0=fltarr(nsteps,nsteps)
      vec=indgen(nel)
      for ix=0,nsteps-1 do begin
        for iy=0,nsteps-1 do begin
          diffphase=[]
         ; ang=northang/180.*!pi
          fiber_du_off=( dra_Step[ix] * sin(ang +!pi/2.) + ddec_step[iy] *cos(ang +!pi/2.) )*imscale /1000. ;[arcsec]
          fiber_dv_off=( dra_Step[ix] * sin(ang) + ddec_step[iy] *cos(ang) )*imscale /1000. ;[arcsec]
;         
          fiber_du_n=fiber_du+fiber_du_off
          fiber_dv_n=fiber_dv+fiber_dv_off
          pos[ix,iy,*]=[dra_step[ix],ddec_step[iy]]
             modelcplx=getTelMetModel(metxpos,metypos,lambda,metang,pupilphase,AstigmAmplitude,AstigmTheta, $
		     rmax,opd_pickup_offset,opd_focus_offset,swapstate,eaz,ezd,eu,ev,fiber_du_n,fiber_dv_n)
             for idiode=0,3 do begin
               diff=datacplx[*,idiode]*(modelcplx[*,idiode])            
               diffphase=[diffphase,atan(imaginary(diff),real_part(diff))]
             endfor
          map0[ix,iy]=total(diffphase^2.)
        endfor
      endfor
;     
      map0=smooth(map0,resol)
      mn = Min(map0, location)
      ind = ARRAY_INDICES(map0, location)
      
      dra_best=dra_Step[ind[0]]
      ddec_best=ddec_step[ind[1]]
      if ind[0] gt 0 and ind[0] lt [nsteps-1] and ind[1] gt 0 and ind[1] lt [nsteps-1] then begin
      dra_best=dra_step[ind[0]-1]*map0[ind[0]-1,ind[1]] $
	      +dra_step[ind[0]]*map0[ind[0],ind[1]] $
	      +dra_step[ind[0]+1]*map0[ind[0]+1,ind[1]]
      dra_best=dra_best/(map0[ind[0]-1,ind[1]]+map0[ind[0],ind[1]]+map0[ind[0]+1,ind[1]])
      ddec_best=ddec_step[ind[1]-1]*map0[ind[0],ind[1]-1] $
	      +ddec_step[ind[1]]*map0[ind[0],ind[1]] $
	      +ddec_step[ind[1]+1]*map0[ind[0],ind[1]+1]
      ddec_best=ddec_best/((map0[ind[0],ind[1]-1]+map0[ind[0],ind[1]]+map0[ind[0],ind[1]+1]))
      endif
;
;print,'Tel'+strtrim(string(itel+1),2)+' fiber offset ["]'
;print,dra_best,ddec_best
test=contour(map0,dra_Step,ddec_step,/fill,n_levels=15)
;
return,[dra_best,ddec_best]
;
end
;-------------------------------------------------------------------------------
function getTelPhasefromFibOff,aux,hdprim
;
t0=systime(/seconds)
teltype=strmid(strtrim(ESOkeyword(hdprim,'T1NAME'),2),0,2)
;
metreceiver=getMetReceiver(hdprim,teltype)
northang=fltarr(4)
imscale=fltarr(4)
for i=0,3 do begin
    imscale[i]=esokeyword(hdprim,'QC ACQ FIELD'+strtrim(string(4-i),2) +' SCALE')
    northang[i]=esokeyword(hdprim,'QC ACQ FIELD'+strtrim(string(4-i),2) +' NORTH_ANGLE')
endfor
;  
AcqOffset=fltarr(4,2)
AcqOffset[0,*]=[-0.72,-0.08];[-0.7,0.0]
AcqOffset[1,*]=[-1.15,-0.37];[-1.1,-0.5]
AcqOffset[2,*]=[-1.53,-0.68];[-1.1,-0.9] 
AcqOffset[3,*]=[-0.54,-0.52];[-0.5,-0.60]
;
AstigmAmplitudeAT =   [0.1643797, 0.166604301, 0.0996125938, 0.266071934] ; /* in microns */
AstigmThetaAT = [1.116211914, 28.48113853, 0.42385066, 25.92291209];  /* in degrees */
AstigmAmplitudeUT =   [0.18216255, 0.185116601, 0.113190052, 0.242351495]; /* in microns */
AstigmThetaUT =[-2.696882009, 18.07496983, 20.56624745, 19.13334754]; /* in degrees */
;
;/* Focus offsets calibrated from AT measurements 17 November 2017 */
opd_focus_offset=dblarr(4)
opd_focus_offset[0]= -57d-9;
opd_focus_offset[1]= -90d-9;
opd_focus_offset[2]=  22d-9;
opd_focus_offset[3]= -86d-9;
; 
opd_pickup_offset=dblarr(4)
if teltype eq 'UT' then begin
   rmax=4000d
   ; /* Separation dependent offsets calibrated from AT measurements 17 November 2017 */
   AstigmAmplitude = AstigmAmplitudeUT[[3,2,1,0]] * 1e-6; /* in order GV1,2,3,4 */
   AstigmTheta = AstigmThetaUT[[3,2,1,0]] / 180d * !pi;
   opd_pickup_offset[0]=-360.0d-9
   opd_pickup_offset[1]=-320.0d-9
   opd_pickup_offset[2]=-150.0d-9
   opd_pickup_offset[3]=-400.0d-9
endif else begin
   rmax=900d
   AstigmAmplitude = AstigmAmplitudeAT[[3,2,1,0]] * 1e-6; /* in order GV1,2,3,4 */
   AstigmTheta = AstigmThetaAT[[3,2,1,0]] / 180d * !pi;
   opd_pickup_offset[0]=-102.0d-9
   opd_pickup_offset[1]=53.0d-9
   opd_pickup_offset[2]=152.0d-9
   opd_pickup_offset[3]=-107.0d-9
   opd_pickup_offset=opd_pickup_offset*1.8/8.  ;effect factor 4.444 smaller on ATs
endelse
optfib=0
; 
for itel=0,3 do begin
  ;ang=northang[itel]/180.*!pi
  ang=aux.northang[itel];   +(1- aux.swapstate)/2. * !pi
  fiber_dx= aux.fiber_dx[itel] - AcqOffset[itel,0]
  fiber_dy= aux.fiber_dy[itel] - AcqOffset[itel,1]
  fiber_du=( fiber_dx * sin(ang +!pi/2.) + fiber_dy *cos(ang +!pi/2.) )*imscale[itel] /1000. ;[arcsec]
  fiber_dv=( fiber_dx * sin(ang) + fiber_dy *cos(ang) )*imscale[itel] /1000. ;[arcsec]
  posang=(atan(aux.ddec,aux.dra) +!pi) mod !pi
  lambda=metreceiver[0].wl_laser
;      
  pupilphase=aux.pupil_opd[itel]/lambda*2.*!pi
  metang = -posang - aux.pra; /* following Stefan's slide */
;   
   ;CHANGE   
   dra_fib=aux.dra  -fiber_du;CHANGE
   ddec_fib=aux.ddec  -fiber_dv;CHANGE
   datacplx=aux.phasor_met_telfc[itel,*]
;   
  if optfib then begin 
   hhh=MapFiberOffset(metreceiver[itel].xpos,metreceiver[itel].ypos, $
	   lambda,metang,pupilphase,AstigmAmplitude[itel],AstigmTheta[itel], $
	   rmax,opd_pickup_offset[itel],$
	opd_focus_offset[itel],aux.swapstate,aux.eaz,aux.ezd,aux.eu,aux.ev, $
	dra_fib,ddec_fib,datacplx,ang,imscale[itel])
    print,'Tel'+strtrim(string(itel+1),2)+' fiber offset [pix]'
    print,hhh[0],hhh[1]
    print,median(aux.fiber_dx[itel]) ,median(aux.fiber_dy[itel])
  endif  
  modelcplx=getTelMetModel(metreceiver[itel].xpos,metreceiver[itel].ypos, $
	  lambda,metang,pupilphase,AstigmAmplitude[itel],AstigmTheta[itel], $
	  rmax,opd_pickup_offset[itel],$
          opd_focus_offset[itel],aux.swapstate,aux.eaz,aux.ezd,aux.eu,aux.ev, $
	  dra_fib,ddec_fib,astigm_phase=astigm_phase)
;
  nframes=n_elements(metang)
  diff=complexarr(nframes,4)
;                        
  diffphase=fltarr(nframes,4)
;    
  for idiode =0,3 do begin
      datacplx=aux.phasor_met_telfc[itel,idiode]
      dataphase=atan(imaginary(datacplx),real_part(datacplx))
      diff[*,idiode]=datacplx*(modelcplx[*,idiode])
      diffphase[*,idiode]=atan(imaginary(diff[*,idiode]),real_part(diff[*,idiode]))    
  endfor
  tmp=diff[*,0]*conj(diff[*,1])
  tiltx=atan(imaginary(tmp),real_part(tmp))    
  tmp=diff[*,2]*conj(diff[*,3])
  tilty=atan(imaginary(tmp),real_part(tmp))
;  
  pplot=0
  if pplot then begin
        diffphase_ppl=fltarr(nframes,4)
;        
     window,0
     !P.Multi = [0, 2, 2]
     xvec=indgen(n_elements(aux.pra))
     findf=where(aux.swapstate lt 0)
     colorvec=['green','red','blue','orange']
     for idiode =0,3 do begin
       modelphase=atan(imaginary(modelcplx[*,idiode]),real_part(modelcplx[*,idiode]))
       met_telfc_corr=aux.opd_met_telfc_corr[itel,idiode]/lambda*2.*!pi
       diffphase_ppl[*,idiode]=met_telfc_corr+diffphase[*,idiode]; +pupilphase
       datacplx=aux.phasor_met_telfc[itel,idiode]
       dataphase=atan(imaginary(datacplx),real_part(datacplx))
          plot,xvec,dataphase,psym=4,color=fsc_color('white'),/xstyle,yrange=[-!pi,!pi],/ystyle
          oplot,xvec,modelphase,color=fsc_color('green'),psym=3
          oplot,xvec,diffphase[*,idiode],color=fsc_color('red'),psym=5
         if findf ne [-1] then oplot,xvec[findf],diffphase[findf,idiode],color=fsc_color('orange'),psym=5
          oplot,xvec,aux.swapstate,color=fsc_color('brown')
           oplot,xvec,-astigm_phase[*,idiode],color=fsc_color('blue')
           oplot,xvec,-met_telfc_corr,color=fsc_color('cyan')
           oplot,xvec,pupilphase,color=fsc_color('purple'),psym=3
      ;    oplot,aux.sc_pos[itel],color=fsc_color('green')
          str='X:'+strtrim(string(metreceiver[itel].xpos[idiode]),2)+' '+'Y:'+strtrim(string(metreceiver[itel].ypos[idiode]),2)
          xyouts,0,0,str,color=fsc_color('gray')
          xyouts,0.5,0.5,'-TELFC_CORR',color=fsc_color('cyan'),/normal
          xyouts,0.4,0.5,'DEPROJECT',color=fsc_color('red'),/normal
          xyouts,0.6,0.5,'PHASOR TELFC',color=fsc_color('white'),/normal
          xyouts,0.7,0.5,'GEOM MODEL',color=fsc_color('green'),/normal
          xyouts,0.3,0.5,'ASTIGM',color=fsc_color('blue'),/normal   
          xyouts,0.8,0.5,'PUPIL OPD',color=fsc_color('purple'),/normal      
      endfor
;      
      window,1
      !P.Multi = [0, 2, 2]
      for idiode =0,3 do begin
        met_telfc_corr=aux.opd_met_telfc_corr[itel,idiode]/lambda*2.*!pi
         plot,xvec,met_telfc_corr,yrange=[-1.8,1.8],color=fsc_color('cyan'),psym=4,/xstyle
         oplot,xvec,pupilphase,color=fsc_color('purple')
         oplot,xvec,diffphase_ppl[*,idiode],color=fsc_color('orange'),psym=4
         oplot,xvec,(-diffphase[*,idiode]) ,color=fsc_color('red'),psym=4
         xyouts,0.5,0.5,'TELFC_CORR',color=fsc_color('cyan'),/normal
         xyouts,0.4,0.5,'DEPROJECT',color=fsc_color('red'),/normal
         xyouts,0.6,0.5,'DELTA',color=fsc_color('orange'),/normal
         xyouts,0.7,0.5,'PUPIL OPD',color=fsc_color('purple'),/normal
      endfor
;
;     print,'median offset: [nm/"]',median(diffphase[*,*])/(2d*!pi)*lambda /abs(sep[0])
;     print,'Sep: ',abs(sep[0])
     !P.Multi =0
  endif
;      
endfor      
;
end
;-------------------------------------------------------------------------------
function gv_erfaPLUV,mjd,rc,dc,pmra,pmdc,parallax,sysvel,dut1,lat,lon,elev, $
	xp,yp,tel1,tel2,tel3,tel4,phpa=phpa,wl=wl,rh=rh,tc=tc, $
	ucoord=ucoord,vcoord=vcoord,wcoord=wcoord,eu=eu_out,ev=ev_out,ew=ew_out, $
	eaz=eaz_out,ezd=ezd_out,hob=hob
;
; Oliver Pfuhl 2017Aug01   Program to calculate UV coordinates from array location and object coordinates
;
  if n_elements(phpa) lt 1 then phpa=0d
  if n_elements(wl) lt 1 then wl=0d
  if n_elements(rh) lt 1 then rh=0d
  if n_elements(tc) lt 1 then tc=0d
  
  ; /* Step for finite difference, 10 arcsec chosen for optimal accuracy */
  eps = 10.0d / 3600.0d /180d*!dpi; // [rad]
  ez = [0.0d, 0.0d, 1.0d]; // Zenith direction in ENU frame
  baseline=dblarr(6,3)
  ;  /* Prepare centered finite differences
  ;  * eU corresponds to +RA
  ;  * eV corresponds to +DEC */
  h=dtp2s(+eps, 0.0d, rc, dc, ra=rcUp, dec=dcUp); eq. 93
  h=dtp2s(-eps, 0.0d, rc, dc, ra=rcUm, dec=dcUm); eq. 94
  h=dtp2s(0.0d, +eps, rc, dc, ra=rcVp, dec=dcVp); eq. 95
  h=dtp2s(0.0d, -eps, rc, dc, ra=rcVm, dec=dcVm); eq. 96
  signvec=[1d,1d,-1d]
  baseline[0,*]=tel1-tel2
  baseline[1,*]=tel1-tel3
  baseline[2,*]=tel1-tel4
  baseline[3,*]=tel2-tel3
  baseline[4,*]=tel2-tel4
  baseline[5,*]=tel3-tel4
  for i=0,5 do begin
    baseline[i,*]=baseline[i,*]*signvec
  endfor
  ;eraASTROM astrom;
  ucoord=dblarr(6,n_elements(mjd))
  vcoord=dblarr(6,n_elements(mjd))
  wcoord=dblarr(6,n_elements(mjd))
  eu_out=dblarr(3,n_elements(mjd))
  ev_out=dblarr(3,n_elements(mjd))
  ew_out=dblarr(3,n_elements(mjd))
  eaz_out=dblarr(3,n_elements(mjd))
  ezd_out=dblarr(3,n_elements(mjd))
  
  hob=dblarr(n_elements(mjd))
  astrom={astro, pmt:0d,eb:dblarr(3),eh:dblarr(3),em:0d,v:dblarr(3),bm1:0d,bpn:dblarr(3,3),along:0d,phi:0d,xpl:0d,ypl:0d,sphi:0d,cphi:0d,diurab:0d,eral:0d,refa:0d,refb:0d}
  
  for row=0,n_elements(mjd)-1 do begin

    dummy=eraApco13(2400000.5d, mjd[row], dut1, lon, lat, elev, xp, yp, phpa, tc, rh, wl, astrom, eo)
    
    ;added by OP to get hour angle
    astrom_copy=astrom
    hob[row]= astrom.eral - rc;hob_;

    ;  /* Transform from celestial to intermediate, compute eU */
    dummy=eraAtcoq(rcUp, dcUp, pmra, pmdc, parallax, sysvel, astrom, enuob=enuobUp);
    dummy=eraAtcoq(rcUm, dcUm, pmra, pmdc, parallax, sysvel, astrom, enuob=enuobUm);
    
    eu=enuobUp-enuobUm;  difference (enuobUp, enuobUm, eu);
    norm=sqrt(total(eu^2d));  normalize (eu);
    norm=abs((rcup-rcum)*cos(dc));normlise to input vector to account for abberration and light deflection
    eu=eu/norm; normalize (eU);

    ;  /* Transform from celestial to intermediate, compute eV */
    dummy= eraAtcoq(rcVp, dcVp, pmra, pmdc, parallax, sysvel, astrom, enuob=enuobVp);
    dummy= eraAtcoq(rcVm, dcVm, pmra, pmdc, parallax, sysvel, astrom, enuob=enuobVm);

    ev=enuobVp-enuobVm;  difference (enuobVp, enuobVm, ev);
    norm=sqrt(total(ev^2d));  normalize (ev);
    norm=abs((dcvp-dcvm));normlise to input vector to account for abberration and light deflection
    ev=ev/norm;  normalize (ev);
    
    ;/* Transform from celestial to intermediate, compute eW */
    dummy=eraAtcoq(rc, dc, pmra, pmdc, parallax, sysvel, astrom, enuob=ew);
    ew=ew * (-1.0d)
    
    ;/* Using pointing and zenith directions, compute eAz */
    eaz=cross(ew,ez)
    norm=sqrt(total(eaz^2d));  normalize (eaz);
    eaz=eaz/norm
    
    ;/* Using pointing and azimuth directions, compute eZd */
    ezd=cross(ew, eaz);
    norm=sqrt(total(ezd^2d));  normalize (eaz);
    ezd=ezd/norm;
  
    for base =0,5 do begin
      uCoord[base,row] = eu[0] * baseline[base,0] + eu[1] * baseline[base,1] + eu[2] * baseline[base,2];
      vCoord[base,row] = ev[0] * baseline[base,0] + ev[1] * baseline[base,1] + ev[2] * baseline[base,2];
      wCoord[base,row] = ew[0] * baseline[base,0] + ew[1] * baseline[base,1] + ew[2] * baseline[base,2];
    endfor
    
    eu_out[*,row]=eu
    ev_out[*,row]=ev
    ew_out[*,row]=ew
    eaz_out[*,row]=eaz
    ezd_out[*,row]=ezd
  endfor
;
return,1
;
end
;-------------------------------------------------------------------------------
function q_getUVW,mjd,rc,dc
  pmra=0.
  pmdc=0.
  parallax=0.
  sysvel=0.
  dut1=0.
  lat=-24.62743941/180.*!pi
  lon=-70.40498688/180.*!pi
  elev=2600.
  xp=0.
  yp=0.
  tel1=[0.,0.,0.]
  tel2=[0.,0.,0.]
  tel3=[0.,0.,0.]
  tel4=[0.,0.,0.]
  
  res= gv_erfaPLUV(mjd,rc,dc,pmra,pmdc,parallax,sysvel,dut1,lat,lon,elev,xp,yp,tel1,tel2,tel3,tel4,$
    phpa=phpa,wl=wl,rh=rh,tc=tc,ucoord=ucoord,vcoord=vcoord,wcoord=wcoord,eu=eu,ev=ev,ew=ew,eaz=eaz,ezd=ezd,hob=hob)
    
  pra=atan(total( (eU[*]) * (-1d * eZd[*]) ), total( (eV[*]) * $
    (-1d* eZd[*]) ))
    
  pra_deg=pra/!pi*180.
  
  eq2hor, rc/!pi*180., dc/!pi*180., mjd+2400000.5d, alt, az,ha,lon=lon/!pi*180.,lat=lat/!pi*180.,precess_=0,nutate_=0,abberration_=0,refract_=0.
  CT2LST, Lst, lon/!pi*180., dummy, mjd+2400000.5d
  ha=lst*15d - rc/!pi*180.
  print,'---------------------------------'
  print,'MJD:',mjd
  print,'Parallactic Angle [deg]',pra_deg
  print,'Altitude [deg]',alt
  print,'Azimuth [deg]',az
  print,'Hour angle [deg]',ha
  print,'Local sideral time [h]',lst
  
  return,0
  
end
;-------------------------------------------------------------------------------
function gvCalcUVq,tel1,tel2,tel3,tel4,eu_,ev_,pup1,pup2,pup3,pup4,eaz_,ezd_, $
	sign=sign
;
; Oliver Pfuhl 2016Dez01   Program calculate new UV points with given pupil offset
; INPUTS:
; tel i: 3D vector of telescope position
; eu_ : EU pointing vector
; ev_ : EV pointing vector
; pup i : 2D vector of telescope i lateral pupil offset in [m]
; eaz_: EAZ pointing vector
; ezd_: EZD pointing vector
; 
; Optional Input
; sign: if set then it defines the swap state (1/-1)
;
;
; Output:
; Structure containing UV coordinates
; strct.ucoord strct.vcoord
; and pupil offsets in UV space
; strct.upup strct.vpup
;
  nel=n_elements(eu_[0,0,*])
  if n_elements(sign) lt 1 then sign=dblarr(nel) +1d
  
  baseline=dblarr(6,3)
  wa_baseline=dblarr(6,3)
  na_baseline=dblarr(2,6,nel)
  
  signvec=[1d,1d,-1d]
  wa_baseline[0,*]=tel1-tel2
  wa_baseline[1,*]=tel1-tel3
  wa_baseline[2,*]=tel1-tel4
  wa_baseline[3,*]=tel2-tel3
  wa_baseline[4,*]=tel2-tel4
  wa_baseline[5,*]=tel3-tel4
  
  if n_elements(pup1) eq 2 then begin
    for ii=0,nel-1 do begin
      na_baseline[*,0,ii]=pup1-pup2
      na_baseline[*,1,ii]=pup1-pup3
      na_baseline[*,2,ii]=pup1-pup4
      na_baseline[*,3,ii]=pup2-pup3
      na_baseline[*,4,ii]=pup2-pup4
      na_baseline[*,5,ii]=pup3-pup4
    endfor
  endif else begin
    for ii=0,nel-1 do begin
      na_baseline[*,0,ii]=pup1[ii,*]-pup2[ii,*]
      na_baseline[*,1,ii]=pup1[ii,*]-pup3[ii,*]
      na_baseline[*,2,ii]=pup1[ii,*]-pup4[ii,*]
      na_baseline[*,3,ii]=pup2[ii,*]-pup3[ii,*]
      na_baseline[*,4,ii]=pup2[ii,*]-pup4[ii,*]
      na_baseline[*,5,ii]=pup3[ii,*]-pup4[ii,*]
    endfor
  endelse
  
  helpvec=dblarr(6,nel,3)
  helpvecU=dblarr(6,nel)
  helpvecV=dblarr(6,nel)
  out=replicate({ucoord:dblarr(6),vcoord:dblarr(6),upup:dblarr(6),vpup:dblarr(6)},nel) 
  
  for row=0,nel-1 do begin
 
    for base =0,5 do begin
      eu=eu_[*,base,row]
      ev=ev_[*,base,row]
      eaz=eaz_[*,base,row]
      ezd=ezd_[*,base,row]
      
      baseline[base,*]=(  wa_baseline[base,*] + reform(na_baseline[*,base,row])*sign[row] ## [[eaz],[ezd]]  ) *signvec
      helpvec[base,row,*]=(   reform(na_baseline[*,base,row]) ## [[eaz],[ezd]]  )
      out[row].uCoord[base] = eu[0] * baseline[base,0] + eu[1] * baseline[base,1] + eu[2] * baseline[base,2];
      out[row].vCoord[base] = ev[0] * baseline[base,0] + ev[1] * baseline[base,1] + ev[2] * baseline[base,2];
      out[row].upup[base] = eu[0] * helpvec[base,row,0] + eu[1] * helpvec[base,row,1] + eu[2] * helpvec[base,row,2];
      out[row].vpup[base] = ev[0] * helpvec[base,row,0] + ev[1] * helpvec[base,row,1] + ev[2] * helpvec[base,row,2];
    endfor
    
  endfor
  
  return,out
  
end
;-------------------------------------------------------------------------------
function gvrefract,wave,diff=diff
;
disp=mrdfits('/Users/pfuhl/mpe/idl/GRAVITY_astrometry/Files/GRAVI.2017-05-03T08:46:48.435_dispmodel.fits',1,/silent)
  
if keyword_set(diff) then begin
    N_MEAN=disp.n_diff
endif else begin
    N_MEAN=disp.n_mean
endelse
wave0=disp.wave0
nwave=n_elements(wave)
n=dblarr(4,nwave)
for iwave=0,nwave-1 do begin
 for itel=0,3 do begin 
     n[itel,iwave]=n_mean[0,itel]+n_mean[1,itel]*(wave0[itel]/wave[iwave] -1)^1+ n_mean[2,itel]*(wave0[itel]/wave[iwave] -1)^2 
 endfor 
endfor
;
return,n
;
end
;-------------------------------------------------------------------------------
function gvrefract_gd
;
  lam1=2.195e-6
  lam2=2.205e-6
  n_gd=(1./lam1*gvrefract(lam1)-1./lam2*gvrefract(lam2))/(1./lam1 - 1./lam2)
  return,n_Gd
;
end
;-------------------------------------------------------------------------------
function gvdispcorr,wave,GD_met0
;
nwave=n_elements(wave)
OPD_tel_met0=dblarr(4,nwave);telescope wise zero point
OPD_met0=dblarr(6,nwave);baseline wise zero point
n_gd=gvrefract_gd()
n_opd=gvrefract(wave)
;
for iwave=0,nwave-1 do begin
  for i=0,3 do begin
    opd_tel_met0[i,iwave]=n_opd[i,iwave]/n_gd[i]*GD_met0[i]
  endfor
  
  opd_met0[*,iwave]=gvbasemet(opd_tel_met0[*,iwave])
endfor
;
out={opd_tel_met0:opd_tel_met0,opd_met0:opd_met0}
return,out
;
end
;-------------------------------------------------------------------------------
function gvTelMet2BaseMet,tel_met,fddl,wave
;
nframes=n_elements(tel_met[0,*])
nwave=n_elements(wave)
base_met=dblarr(nwave,6,nframes)
index=intarr(2,6)
n_mean=gvrefract(wave)
n_diff=gvrefract(wave,/diff)
index1=[0,0,0,1,1,2]
index2=[1,2,3,2,3,3]
for iframe=0,nframes-1 do begin
  for iwave =0,nwave-1 do begin
   for ibase =0,5 do base_met[iwave,ibase,iframe]= $
	   n_mean[index1[ibase],iwave]*tel_met[index1[ibase],iframe]- $
           n_mean[index2[ibase],iwave]*tel_met[index2[ibase],iframe]+ $
	   n_diff[index1[ibase]]*n_diff[index1[ibase]]*fddl[index1[ibase],iframe]-$
           n_diff[index2[ibase]]*fddl[index2[ibase],iframe]
  endfor 
endfor
return,base_met
;
end
;-------------------------------------------------------------------------------
function gvbasemet,met
;
; Oliver Pfuhl 2016Apr04   Program to fit dual-field astrometric data
;
basemet=dblarr(6)
;
basemet[0]=met[0]-met[1]
basemet[1]=met[0]-met[2]
basemet[2]=met[0]-met[3]
basemet[3]=met[1]-met[2]
basemet[4]=met[1]-met[3]
basemet[5]=met[2]-met[3]
;  
return,basemet
;
end
;-------------------------------------------------------------------------------
function gvSetupFitParm,astrct,fixed=fixed,parm=parm
;
ntargets=max(astrct.targnum)+1
parm0 =[0d,0d,0d,0d,0,0,0,0,0,0,0,0]
fixed0=[0, 0, 0, 1, 1,1,1,1,1,1,1,1]
;  
explstr=['M!l1','M!l2','M!l3','M!l4','NB!l1x','NB!l1y','NB!l2x','NB!l2y','NB!l3x','NB!l3y','NB!l4x','NB!l4y']
descr=['MET0','MET0','MET0','MET0','NB','NB','NB','NB','NB','NB','NB','NB']
;  
for itarg=0,ntargets -1 do begin
    ffind=where(astrct.targnum eq itarg )
    parm0=[parm0,[astrct[ffind[0]].dra,astrct[ffind[0]].ddec]]
    fixed0=[fixed0,0d,0d]
    name=astrct[ffind[0]].target[0]+'-'+astrct[ffind[0]].target[1]
    explstr=[explstr,'!9Da!X!l'+strtrim(string(itarg+1),2)+'!n','!9Dd!X!l'+strtrim(string(itarg+1),2)+'!n']
    descr=[descr,'Target'+strtrim(string(itarg+1),2),'Target'+strtrim(string(itarg+1),2)]
endfor
;  
if keyword_Set(fixed) then fixed0[0:n_elements(fixed)-1]=fixed
if keyword_Set(parm) then parm0[0:n_elements(parm)-1]=parm
parinfo = replicate({value:0.D, fixed:0, limited:[0,0],limits:[0.D,0],mpside:0,explstr:'',descr:''}, n_elements(parm0))
parinfo[*].fixed = fixed0
parinfo[*].value = parm0
parinfo[*].explstr = explstr
parinfo[*].descr = descr
;
return,parinfo
;
end
;-------------------------------------------------------------------------------
function gvGetIndex,type,parm
;
;  Oliver Pfuhl 2017Sep04   Program to fit dual-field astrometric data
;
CASE type OF
    "TARGET": out=[12,n_elements(parm)-1]
    "MET0":  out=[0,3]
    "BASE" : out=[4,5,6,7,8,9,10,11]
ENDCASE
; 
return,out
;
end
;-------------------------------------------------------------------------------
function gvOPDModel,parm,astrct=astrct,obs=obs
;
ntargets=max(astrct.targnum)+1
metindx=gvGetIndex('MET0',parm);[0,3] 
targindx=gvGetIndex('TARGET',parm);[12,ntargets-1]
pupindx=gvGetIndex('BASE',parm);[4,11]
; 
ucoord=astrct.ucoord
vcoord=astrct.vcoord
;
nframes=n_elements(astrct)
dra=dblarr(nframes)
ddec=dblarr(nframes)
for itarg=0,ntargets-1 do begin
  ffind=where(astrct.targnum eq itarg)
  dra[ffind]= parm[targindx[0]  + itarg*2]
  ddec[ffind]=parm[targindx[0]+1+ itarg*2]
endfor
;
met=dblarr(6)
met=gvbasemet(parm[metindx[0]:metindx[1]])
;
pup1=[parm[pupindx[0]],parm[pupindx[1]]] 
pup2=[parm[pupindx[2]],parm[pupindx[3]]] 
pup3=[parm[pupindx[4]],parm[pupindx[5]]] 
pup4=[parm[pupindx[6]],parm[pupindx[7]]]
; 
out=replicate({dopd:dblarr(6),dopd_model:dblarr(6),mjd:dblarr(6)},nframes)
; 
if total(parm[pupindx[0]:pupindx[7]]) ne 0. then begin 
 newuv=gvCalcUVq(obs.staxyz[*,3],obs.staxyz[*,2],obs.staxyz[*,1],obs.staxyz[*,0], $
	 astrct.eu,astrct.ev,pup4,pup3,pup2,pup1,astrct.eaz,astrct.ezd,sign=astrct.swapstate)  
 ucoord=newuv.ucoord
 vcoord=newuv.vcoord
endif
; 
for iframe=0,nframes-1 do begin
    for ibase=0,5 do begin
      out[iframe].dopd[ibase]=1d*astrct[iframe].swapstate*(1d/3600d/180d*!dpi) $
	   *(dra[iframe]*ucoord[ibase,iframe]+ddec[iframe]*vcoord[ibase,iframe]) $
	   -met[ibase]
      out[iframe].dopd_model[ibase]=1d*astrct[iframe].swapstate*(1d/3600d/180d*!dpi) $
	   *(dra[iframe]*ucoord[ibase,iframe]+ddec[iframe]*vcoord[ibase,iframe])
    endfor
   out[iframe].mjd=astrct[iframe].mjd
endfor  
;
return,out
;
end
;-------------------------------------------------------------------------------
function gvfitOPD_mpfunc,parm,dp,dopd0=dopd,dopd_err0=dopd_err,astrct=astrct,obs=obs
;
; Oliver Pfuhl 2016Apr04   Program to fit dual-field astrometric data
;
opdmodel= gvOPDModel(parm,astrct=astrct,obs=obs)
residual=(opdmodel.dopd - dopd)/dopd_err
 
residual=reform(residual,n_elements(residual),/overwrite)
i_num = where(finite(residual), /null)
residual=residual[i_num]
;
return,residual
;
end
;-------------------------------------------------------------------------------
function gvfitOPD,parinfo,dopd0=dopd0,dopd_err0=dopd_err0,astrct=astrct,obs=obs
;
; Oliver Pfuhl 2016Apr04   Program to fit dual-field astrometric data
;
nel=n_elements(parinfo.value)
pcerror0=dblarr(nel)
result=dblarr(nel)
covar=dblarr(nel,nel)
corr=dblarr(nel,nel)
basemet=dblarr(6)
dof0=0
redchi2=0d
status=lonarr(1)
functargs={astrct:astrct,obs:obs,dopd0:dopd0,dopd_err0:dopd_err0}
result_ = mpfit('gvfitOPD_mpfunc',parinfo.value,functargs=functargs,parinfo=parinfo, $
	perror=perror0,covar=covar,dof=dof0,bestnorm=bestnorm0,$
        autoderivative=1,status=status,errmsg=errmsg,/quiet)
if status ge 1 then begin                      
	result=result_                      
	redchi2=BESTNORM0 / DOF0
	PCERROR0 = PERROR0 * SQRT(BESTNORM0 / DOF0)
	corr=covar*0d
	metindx=gvGetIndex('MET0',parinfo.value)
	basemet=gvbasemet(result[metindx[0]:metindx[1]])
	for ii=0,n_elements(corr[*,0])-1 do begin
  	for jj=0,n_elements(corr[0,*])-1 do begin
		if covar[ii,ii]*covar[jj,jj] ne 0 then $
	    	corr[ii,jj]=covar[ii,jj]/sqrt(covar[ii,ii]*covar[jj,jj])
  	endfor
	endfor
endif
status=1L*status
targetindx=gvGetIndex('TARGET',parinfo.value)
out={result:result,expl:parinfo.explstr,error:pcerror0,corr:corr, $
	basemet:basemet,basemet_err:[pcerror0[metindx[0]:metindx[1]],0.,0.], $
	redchi2:redchi2,bestnorm:bestnorm0,$
        dof:dof0,status:status,parm:parinfo.value,fixed:parinfo.fixed, $
	MJD:mean(astrct.mjd),T_INT:max(astrct.mjd)-min(astrct.mjd),$
	X:result[targetindx[0]],Y:result[targetindx[0]+1], $
	X_ERR:pcerror0[targetindx[0]],Y_ERR:pcerror0[targetindx[0]+1], $
	array_name:obs.array_name}
;
return,out
;
end
;-------------------------------------------------------------------------------
function chi2_dist,opd,opd_err,ucoord,vcoord,swapstate,x,y,basemet
;
nn=201
step=7d-6;["]
step=step*10 ; CHU
sigma_thresh=3.
chi_dist=dblarr(nn,nn,6)
as2rad=!dpi/180d/3600d
xpos=((dindgen(nn)-floor(nn/2))*step+x)*as2rad
ypos=((dindgen(nn)-floor(nn/2))*step+y)*as2rad
chi_tot=dblarr(nn,nn)
opd_tot=[]
opd_tot_err=[]
opd_err=opd_err*1.
nel=n_elements(opd[0,*])
for ibase=0,5 do begin
  for ii=0,nn-1 do begin
    for jj=0,nn-1 do begin
      opd_mod=(ucoord[ibase,*]*xpos[ii]+vcoord[ibase,*]*ypos[jj])*swapstate-opd[ibase,*]-basemet[ibase]
      chi_dist[ii,jj,ibase]=total((opd_mod/opd_err[ibase,*])^2.,/nan) / nel
      ;opd_tot=[opd_tot,opd_mod]
      ;opd_tot_err=[opd_tot_err,opd_err]
    endfor
  endfor
  chi_dist[*,*,ibase]=chi_dist[*,*,ibase]/min(chi_dist[*,*,ibase])
  sig=sqrt(2./nel)
  chi_tot=chi_tot+chi_dist[*,*,ibase]
  chi_dist[*,*,ibase]=(chi_dist[*,*,ibase]-min(chi_dist[*,*,ibase]))/sig
endfor
chi_tot=chi_tot;/6.
sig_tot=sqrt(2./(6.*nel))
chi_tot[*,*]=(chi_tot[*,*]-min(chi_tot))/sig_tot
;chi_tot=mean(chi_dist[*,*,*],dimension=3)
;chi_tot=chi_tot/min(chi_tot)
findf=where(chi_tot le sigma_thresh)
ind = ARRAY_INDICES(chi_tot, findf)
x_mean=mean(xpos[ind[0,*]])/as2rad
y_mean=mean(ypos[ind[1,*]])/as2rad
x_err=abs(max(xpos[ind[0,*]])-min(xpos[ind[0,*]]))/2. /as2rad 
y_err=abs(max(ypos[ind[1,*]])-min(ypos[ind[1,*]]))/2. /as2rad 
out={chi_base:chi_dist,chi_all:chi_tot,x:x_mean,y:y_mean,x_err:x_err,y_err:y_err,step:step,xpos:xpos,ypos:ypos,narr:nn,sigma_thresh:sigma_thresh}
;
return,out
;
end
;*******************************************************************************
pro run_gravi_astrofit,soffile,help=help,outname=outname, $
	remove_outlier=remove_outlier, $
	calc_opd_disp=calc_opd_disp,calc_uv=calc_uv, $
	fits=fits,fixed=fixed,data_type=data_type
  ; Oliver Pfuhl 2017Sep04   Program to fit dual-field astrometric data
  ; V0.9
  ;
  ; INPUTS:
  ; soffile: Ascii file containing the fits files to be considered in fitting (optional)
  ; Params:
  ;   outname = name of output file
  ;   remove_outlier: n-sigma outlier rejection (default 0,i.e. no rejection)
  ;   calc_opd_disp: if keyword set then OPD_DISP is re-calculated with new MET_ZERO point (default 0)
  ;   calc_uv: if keyword set then UV coordinates are re-calculated from fits header information (default 0) 
  ;   fit_single: if keyword set, then individual baselines are fit (default 0)
  ;   fit_closure: if keyword set, then individual telescope triangles are fit (default 0)
  ;   fixed: vector defining free fit parameters (default [0,0,0,1,1,1,1,1,1,1,1,1,0...])
  ;          vector free fit parameters are ( [Met1,Met2,Met3,Met4,NBx1,NBy,...NBy4,dRA1,dDEC1,...,dRAi,dDECi])
  ; outputs:
  ;   fits file containing fit positions for each object-pair
  ;   pdf plot containing fit results
  pol=1
  gvAstrofit,soffile,pol=pol,help=help,outname=outname, $
	  remove_outlier=remove_outlier, $
	  calc_opd_disp=calc_opd_disp,calc_uv=calc_uv, $
	  fits=fits,fixed=fixed,data_type=data_type
end
;-------------------------------------------------------------------------------
pro gvAstrofit,soffile,pol=pol,help=help,outname=outname, $
	remove_outlier=remove_outlier, $
	calc_opd_disp=calc_opd_disp,calc_uv=calc_uv, $
	fits=fits,fixed=fixed,data_type=data_type
; Oliver Pfuhl 2016Apr04   Program to fit dual-field astrometric data
;
if n_elements(fits) lt 1 then fits=1
if ~keyword_set(help) then help=0
if n_elements(soffile) lt 1 then begin
  list =file_search('GRAVI*astroreduced.fits')
  list =file_search('reflex_end_products/2020-01-17T11:24:28','*ASTROREDUCED.fits')		; CHU
  list =file_search('reflex_end_products/2020-01-17T11:24:28','*ASTROREDUCED.fits')		; CHU
  outname0 ='Astrofit'
endif else begin
  readcol,soffile,list,format='A',comment='#',/silent;,/PRESERVE_NULL,/silent
  outname0=strmid(soffile,0,strlen(soffile)-4)+'-FIT'
endelse
if ~keyword_set(outname) then  outname=outname0
if n_elements(pol) lt 1 then pol =1
;
if help then begin
 print,'###################################################################################################################'
 print,'# Syntax:run_gravi_astrofit,soffile,outname=outname,remove_outlier=remove_outlier,calc_opd_disp=calc_opd_disp,help=help'  
 print,'# '
 print,'# If soffile provided then 1st column should contain filenames, else all *astroreduced.fits files in directory used'
 print,'# Input:'
 print,'#   soffile: Ascii file containing the fits files to be considered in fitting (optional)'
 print,'# Params:'
 print,'#   outname = name of output file'
 print,'#   remove_outlier: n-sigma outlier rejection (default 0,i.e. no rejection)'
 print,'#   calc_opd_disp: if keyword set then OPD_DISP is re-calculated with new MET_ZERO point (default 0)'
 print,'#   calc_uv: if keyword set then UV coordinates are re-calculated from fits header information (default 0) '
 print,'#   fit_single: if keyword set, then individual baselines are fit (default 0)'
 print,'#   fit_closure: if keyword set, then individual telescope triangles are fit (default 0)'
 print,'#   fixed: vector defining free fit parameters (default [0,0,0,1,1,1,1,1,1,1,1,1,0...])'
 print,'#          vector free fit parameters are ( [Met1,Met2,Met3,Met4,NBx1,NBy,...NBy4,dRA1,dDEC1,...,dRAi,dDECi])'
 print,'# outputs:'
 print,'#   fits file containing fit positions for each object-pair'
 print,'#   pdf plot containing fit results'
 print,'####################################################################################################################'
 return
endif
;
if keyword_Set(remove_outlier) then abs_thresh=remove_outlier
if ~keyword_Set(calc_opd_disp) then calc_opd_disp=0
if ~keyword_Set(calc_uv) then calc_uv=0
;
filelist=list
mainhd=headfits(list[0])
date_obs=esokeyword(mainhd,'DATE-OBS')
gvastrodata,filelist,pol,oitarget,oiarray,oiwave,astrct,obs,env,aux,swap=swap
;
; calculate UV coordinates
if calc_uv then begin
  print,'---------re-calculating UV coordinates-----------'
;
  uvnew=replicate({ucoord:dblarr(6),vcoord:dblarr(6),wcoord:dblarr(6), $
	  gd_ft:dblarr(6),eu:dblarr(3,6),ev:dblarr(3,6),ew:dblarr(3,6), $
	  eaz:dblarr(3,6),ezd:dblarr(3,6)},n_elements(astrct))
;
  for iter=0,n_elements(astrct)-1 do begin
    hh=gv_erfaPLUV(astrct[iter].mjd, $
	    astrct[iter].rc,astrct[iter].dc,astrct[iter].pr,astrct[iter].pd, $
	    obs.px,obs.rv,obs.dut1,obs.phi,obs.elong,obs.hm,obs.xp,obs.yp,$
            obs.staxyz[*,3],obs.staxyz[*,2],obs.staxyz[*,1],obs.staxyz[*,0], $
	    phpa=0.,wl=2.2e-6,rh=0.,tc=16.,$
            ucoord=ucoord,vcoord=vcoord,wcoord=wcoord, $
	    eu=eu_out,ev=ev_out,ew=ew_out,eaz=eaz_out,ezd=ezd_out,hob=hob)
     for ibase=0,5 do begin            
      uvnew[iter].ucoord[ibase] =ucoord[ibase,ibase]
      uvnew[iter].vcoord[ibase] =vcoord[ibase,ibase]
      uvnew[iter].wcoord[ibase] =wcoord[ibase,ibase]
      uvnew[iter].eu[*,ibase]=eu_out[*,ibase]
      uvnew[iter].ev[*,ibase]=ev_out[*,ibase]
      uvnew[iter].ew[*,ibase]=ew_out[*,ibase]
      uvnew[iter].eaz[*,ibase]=eaz_out[*,ibase]
      uvnew[iter].ezd[*,ibase]=ezd_out[*,ibase]
      uvnew[iter].gd_ft[ibase]=astrct[iter].gd_ft[ibase]
     endfor           
  endfor  
  mwrfits,uvnew,'uvnew.fits',/create
  astrct.ucoord=uvnew.ucoord
  astrct.vcoord=uvnew.vcoord 
  uvnew=0
endif     
;
print,'---Calculating Abberration:---'
;
ff=gv_abberration(median(astrct.mjd),obs.elong,obs.phi,obs.hm,obs.xp,obs.yp,obs.rc,obs.dc,rc,dc,dra0=obs.dra+0.00001,ddec0=obs.ddec,dRA_abb=dRA_abb,dDEC_abb=dDEC_abb)
zob=reform(acos(-astrct[*].ew[2,0]))
aob=reform(acos(-astrct[*].ew[1,0]/sin(zob)))
out1={AOB:circular_average(aob/!dpi*180d,/deg),ZOB:circular_average(zob/!dpi*180d,/deg),dRA_abb:dRA_abb,$
  dDEC_abb:dDEC_abb,target:obs.target }
; removing flagged data------------
for ibase =0,5 do begin
  findf=where(astrct.rejection_flag[ibase] ne 0)
  if findf ne [-1] then begin
   astrct[findf].DOPD_GD_ERR[ibase]=!VALUES.F_NAN
   astrct[findf].DOPD_GD[ibase]=!VALUES.F_NAN
   astrct[findf].DOPD_GD_tel[ibase]=!VALUES.F_NAN
   astrct[findf].GD_sc[ibase]=!VALUES.F_NAN
   astrct[findf].GD_ft[ibase]=!VALUES.F_NAN
   astrct[findf].dopd_gd_pol2[ibase]=!VALUES.F_NAN
   astrct[findf].dopd_gd_tel_pol2[ibase]=!VALUES.F_NAN
  endif 
endfor
;
print,'---Setup fit parameters:---'
;
parinfo=gvSetupFitParm(astrct,fixed=fixed,parm=parm)
;
baseindx=gvGetIndex("BASE",parinfo.value)
metindx=gvGetIndex("MET0",parinfo.value)
;
; print parameters------------------------------
print,'---------Fit parameters---------'
print,'Startparams: ',parinfo.value
print,'Fixed: ',parinfo.fixed
;
; -----0 order fit------------------------------
print,'----------0 order Fit-----------'
fitresult0=gvfitOPD(parinfo,dopd0=astrct.dopd_gd,dopd_err0=astrct.dopd_gd_err,astrct=astrct,obs=obs)
print,'Result: ',fitresult0.result
model=gvOPDModel(fitresult0.result,astrct=astrct,obs=obs)
res=astrct.dopd_gd -model.dopd
;
; remove outliers-------------------------------
if keyword_set(remove_outlier) then begin
  print,'-------removing outliers-------'
  histogauss,res[where(abs(res) lt 10e-6)],b,/nofit,/noplot
  print,'Residual scatter: sigma = ',strtrim(string(b[2]*1e9,format='(I12.0)'),2)+' nm'
  print,'Threshold: ',strtrim(string(abs_thresh,format='(I12.0)'),2),' sigma' 
  for ibase=0,5 do begin
   findf=[where(abs(res[ibase,*]) gt b[2]*abs_thresh)]
   if findf ne [-1] then begin
     astrct[findf].dopd_gd_Err[ibase]=!VALUES.F_NAN
     astrct[findf].dopd_gd[ibase]=!VALUES.F_NAN
     astrct[findf].dopd_gd_tel[ibase]=!VALUES.F_NAN
     astrct[findf].dopd_gd_pol2[ibase]=!VALUES.F_NAN
     astrct[findf].dopd_gd_tel_pol2[ibase]=!VALUES.F_NAN
   endif
  endfor
endif
;
; Pol1
if data_type eq 'GD' then begin
	data2fit=astrct.dopd_gd
	err2fit=astrct.dopd_gd_err
endif 
;
if data_type eq 'GD+TEL' then begin
	data2fit=astrct.dopd_gd_tel
	err2fit=astrct.dopd_gd_err
endif
;
; Fit (save results here and in next step in YYYY-MM-DD.fits)
print,'---------Fit---------'
fitresult1=gvfitOPD(parinfo,dopd0=data2fit,dopd_err0=err2fit,astrct=astrct,obs=obs)
model=gvOPDModel(fitresult1.result,astrct=astrct,obs=obs)
print,'Result: ',fitresult1.result
savestrct=create_struct(fitresult1,out1)
header=[]
if fits then FXADDPAR, HEADER, 'EXTNAME','FIT', 'Extension name'
if fits then mwrfits,savestrct,outname+'.fits',header,/create,/silent

; Calculate new OPD_DISP using 0-point------------------
if calc_opd_disp then begin
  indx=where(parinfo.descr eq 'MET0')
  gd_met0=fitresult1.result[indx]-mean(fitresult1.result[indx])
  opd_FC_met0=1d/gvrefract_gd() *gd_met0
  for itel=0,3 do  aux.opd_met_fc[itel]=aux.opd_met_fc[itel]+opd_FC_met0[itel]
  opd_disp_new=gvTelMet2BaseMet(aux.opd_met_fc,aux.fddl,obs.wave)
  astrct.opd_disp=opd_disp_new
endif
header=[]
if fits then FXADDPAR, HEADER, 'EXTNAME','ASTRODATA', 'Extension name'
if fits then mwrfits,astrct,outname+'.fits',header,/silent
;
; Calculate for each target the abberration
; Write for each target an individual file
ntargets=max(astrct.targnum)+1
for itarg=0,ntargets -1 do begin
  targout=[]
  ffind=where(astrct.targnum eq itarg)
  hfind=where(parinfo.descr eq 'Target'+strtrim(string(itarg+1),2) )
  name=astrct[ffind[0]].target[0]+'-'+astrct[ffind[0]].target[1]
  fit_=fitresult1
  xx=fit_.result[hfind[0]]
  yy=fit_.result[hfind[1]]
  xx_err=fit_.error[hfind[0]]
  yy_err=fit_.error[hfind[1]]
  mjd_mean=mean(astrct[ffind].mjd)
  chi2_dist=chi2_dist(data2fit[*,ffind],err2fit[*,ffind], $
	  astrct[ffind].ucoord,astrct[ffind].vcoord, $
	  astrct[ffind].swapstate,xx,yy,fit_.basemet)
  plot_target,chi2_dist,[xx,yy],[xx_err,yy_err],title=name,mjd=mjd_mean,outname=outname0+'_'+strtrim(name,2)
  targout={MJD:mean(astrct[ffind].mjd), $
	  X:fit_.result[hfind[0]],Y:fit_.result[hfind[1]], $
	  X_err:fit_.error[hfind[0]],Y_err:fit_.error[hfind[1]],$
	dRA_abb:dRA_abb,dDEC_abb:dDEC_abb, $
	AOB:circular_average(aob/!dpi*180d,/deg), $
	ZOB:circular_average(zob/!dpi*180d,/deg), $
	DOF:fit_.dof,redchi2:fit_.redchi2,$
    	Target:[astrct[ffind[0]].target[0],astrct[ffind[0]].target[1]], $
	NB:fit_.result[baseindx[0]:baseindx[-1]], $
	MET0:fit_.result[metindx[0]:metindx[1]],$
        NB_err:fit_.error[baseindx[0]:baseindx[-1]], $
	MET0_err:fit_.error[metindx[0]:metindx[1]]}
    posname=strtrim(string(astrct[ffind[0]].dra*1000,format='(I12)'),2) $
	    +'_'+strtrim(string(astrct[ffind[0]].ddec*1000,format='(I12)'),2)
  ;filename=outname+'_'+name+'_'+posname+'_'+strtrim(string(mean(astrct[ffind].mjd),format='(I12.0)'),2)
  ;filename=name+'_'+posname+'_'+strtrim(string(mean(astrct[ffind].mjd),format='(I12.0)'),2)+'_ASTROFIT'
  filename=outname0+'_'+strtrim(name,2);+'_'+strtrim(posname,2)+'_'+strtrim(date_obs,2)
  header=[]
  if fits then  FXADDPAR, HEADER, 'EXTNAME','FIT', 'Extension name'
  if fits then  FXADDPAR, HEADER, 'TARGET',name, 'Target name'
  if fits then  FXADDPAR, HEADER, 'FT ROBJ NAME',astrct[ffind[0]].target[0], 'FT target name'
  if fits then  FXADDPAR, HEADER, 'INS SOBJ NAME',astrct[ffind[0]].target[1], 'SC target name'
  print,'Write file:'+name+'.fits'
  if fits then  mwrfits,targout,filename+'.fits',header,/create,/silent
  
 ;write target results to ascii
 forprint,targout.mjd,float(chi2_dist.x),float(chi2_dist.y),float(chi2_dist.x_err),float(chi2_dist.y_err),float(atan(targout.x,targout.y)/!dpi*180d),float(sqrt(targout.x^2d +targout.y^2d ))$
          ,format='d,f,f,f,f,f,f,f,f,f,f',comment='#mjd,x,y,x_err,y_err,theta(deg),rho',textout=filename+'.txt'
endfor
; 
outname_=outname
gravi_astrofit_plot,astrct=astrct,fitresult=fitresult1,triangle=trianglestr,single=singlestr,obs=obs,env=env,outname=outname_,aux=aux
;forprint,aux.targnum,aux.fiber_dx[0],aux.fiber_dy[0],aux.flux_ft[0],aux.flux_sc[0]  , textout='Field-flux.txt',format='I,F,F,F,F'
end
;-------------------------------------------------------------------------------
pro plot_target,chi_dist,fitxy,fitxyerr,title=title,mjd=mjd,outname=outname
;
as2rad=!dpi/180d/3600d
!P.Multi =0
cgPS_open, Filename=outname,landscape=0,/nomatch
c_col=['red7','red6','red5']
cgcontour,chi_dist.chi_base[*,*,0],chi_dist.xpos/as2rad,chi_dist.ypos/as2rad, $
				   /isotropic,levels=[1,2,3],/nodata,title=title,charsize=1.1
cgcontour,chi_dist.chi_base[*,*,0],chi_dist.xpos/as2rad,chi_dist.ypos/as2rad,/isotropic,levels=[1,2,3],/overplot,c_colors=['pur4','pur3','pur2'],label=0
cgcontour,chi_dist.chi_base[*,*,1],chi_dist.xpos/as2rad,chi_dist.ypos/as2rad,/isotropic,levels=[1,2,3],/overplot,c_colors=['grn4','grn3','grn2'],label=0
cgcontour,chi_dist.chi_base[*,*,2],chi_dist.xpos/as2rad,chi_dist.ypos/as2rad,/isotropic,levels=[1,2,3],/overplot,c_colors=['blu4','blu3','blu2'],label=0
cgcontour,chi_dist.chi_base[*,*,3],chi_dist.xpos/as2rad,chi_dist.ypos/as2rad,/isotropic,levels=[1,2,3],/overplot,c_colors=['blk4','blk3','blk2'],label=0
cgcontour,chi_dist.chi_base[*,*,4],chi_dist.xpos/as2rad,chi_dist.ypos/as2rad,/isotropic,levels=[1,2,3],/overplot,c_colors=['org4','org3','org2'],label=0
cgcontour,chi_dist.chi_base[*,*,5],chi_dist.xpos/as2rad,chi_dist.ypos/as2rad,/isotropic,levels=[1,2,3],/overplot,c_colors=['ygb4','ygb3','ygb2'],label=0
cgcontour,chi_dist.chi_all,chi_dist.xpos/as2rad,chi_dist.ypos/as2rad,/isotropic,levels=[1,2,3],/overplot,c_colors=c_col,label=0
cgplot,[chi_dist.x-chi_dist.x_err,chi_dist.x+chi_dist.x_err],[chi_dist.y,chi_dist.y],/overplot,/noerase,color='red',thick=2
cgplot,[chi_dist.x,chi_dist.x],[chi_dist.y-chi_dist.y_err,chi_dist.y+chi_dist.y_err],/overplot,/noerase,color='red',thick=2
cgplot,[fitxy[0]],[fitxy[1]],/overplot,/noerase,color='blue',psym=cgSymCat('OPENCIRCLE')
cgplot,[chi_dist.x],[chi_dist.y],/overplot,/noerase,color='red',psym=cgSymCat('OPENCIRCLE')
charsize=1
str='MJD: '+strtrim(string(mjd,format='(F20.5)'),2)
xyouts,0.75,0.51,str,/normal,charsize=charsize
str='----Fit position-----'
xyouts,0.75,0.47,str,/normal,charsize=charsize
str=' '+strtrim(string(fitxy[0],format='(F10.6)'),2)+', '+strtrim(string(fitxy[1],format='(F10.6)'),2)+' '
xyouts,0.75,0.44,str,/normal,charsize=charsize
str='('+strtrim(string(fitxyerr[0],format='(F10.6)'),2)+', '+strtrim(string(fitxyerr[1],format='(F10.6)'),2)+')'
xyouts,0.75,0.41,str,/normal,charsize=charsize
str='----Chi2 position----'
xyouts,0.75,0.37,str,/normal,charsize=charsize
str=' '+strtrim(string(chi_dist.x,format='(F10.6)'),2)+', '+strtrim(string(chi_dist.y,format='(F10.6)'),2)+' '
xyouts,0.75,0.34,str,/normal,charsize=charsize
str='('+strtrim(string(chi_dist.x_err,format='(F10.6)'),2)+', '+strtrim(string(chi_dist.y_err,format='(F10.6)'),2)+')'
xyouts,0.75,0.31,str,/normal,charsize=charsize
cgPS_close;, /PDF,/Delete_PS, UNIX_CONVERT_CMD='pstopdf'
;d=cgcolor()
end
;-------------------------------------------------------------------------------
pro oiextnum_astro,file,wavext_p1,visext_p1,fluxext_p1, $
	wavext_p2,visext_p2,fluxext_p2,arrayext,targetext
;
; Oliver Pfuhl 2016Apr04   Program to get fits extension numbers
; 
spec='SC'
prim=mrdfits(file,0,head,/dscale,/silent)
polmode=strtrim(ESOkeyword(head,'INS POLA MODE'),2)
if polmode eq 'SPLIT' then begin
    polstr1 ='_P1'
    polstr2 ='_P2'
endif else begin
    polstr1 =''
    polstr2 =''
endelse
;  
FITS_INFO, file,  /SILENT ,  N_ext =n_ext, EXTNAME= extname
extname=strarr(n_ext+1)
insname=strarr(n_ext+1)
;  
for i=0,n_ext do begin
    head=headfits(file,exten=i,/silent)
    hh=strtrim(sxpar(head,'EXTNAME'),2)
    extname[i]=hh
    hh=strtrim(sxpar(head,'INSNAME'),2)
    insname[i]=hh
endfor
;
targetext=(where(extname eq 'OI_TARGET' ))[0]
arrayext=(where(extname eq 'OI_ARRAY' ))[0]
wavext_p1=(where(extname eq 'OI_WAVELENGTH' and (insname eq 'SPECTRO_'+spec+polstr1 OR insname eq 'GRAVITY_'+spec+polstr1)))[0]
visext_p1=(where(extname eq 'OI_VIS' and (insname eq 'SPECTRO_'+spec+polstr1 OR insname eq 'GRAVITY_'+spec+polstr1)))[0]
fluxext_p1=(where(extname eq 'OI_FLUX' and (insname eq 'SPECTRO_'+spec+polstr1 OR insname eq 'GRAVITY_'+spec+polstr1)))[0]
  
if polmode eq 'SPLIT' then begin
    wavext_p2=(where(extname eq 'OI_WAVELENGTH' and (insname eq 'SPECTRO_'+spec+polstr2 OR insname eq 'GRAVITY_'+spec+polstr2)))[0]
    visext_p2=(where(extname eq 'OI_VIS' and (insname eq 'SPECTRO_'+spec+polstr2 OR insname eq 'GRAVITY_'+spec+polstr2)))[0]
    fluxext_p2=(where(extname eq 'OI_FLUX' and (insname eq 'SPECTRO_'+spec+polstr2 OR insname eq 'GRAVITY_'+spec+polstr2)))[0]
endif else begin
    wavext_p2=-1
    visext_p2=-1
    fluxext_p2=-1
endelse
;  
end
;-------------------------------------------------------------------------------
pro gv_phjumpcorr,strct
;
; See also: "Derivation of the astrometric OPD" by Guy Perrin
;
nfiles=max(strct.filenum+1)
newstrct=strct
for ifile=0,nfiles-1 do begin
   for ibase=0,5 do begin
     findf=where(strct.filenum eq ifile)
     med=median(strct[findf].met_delta[ibase])
     if abs(strct[findf[0]].met_delta[ibase] - med) gt !pi then $
	     newstrct[findf[0]].met_delta[ibase]=med
     newstrct[findf].met_delta[ibase]=strct[findf].met_delta[ibase] $
	     -round((strct[findf].met_delta[ibase]-med)/(2.*!pi))*2.*!pi
     med_new=median(newstrct[findf].met_delta[ibase])
     dmed=round((med_new-med)/!pi)*!pi  
     newstrct[findf].met_delta[ibase]=newstrct[findf].met_delta[ibase] -dmed
   endfor
endfor
strct.met_delta=newstrct.met_delta
;
end
;-------------------------------------------------------------------------------
pro gvastrodata,filelist,pol,oitarget,oiarray,oiwave,astrct,obs,env,aux, $
	swap=swap,option=option
;
; Oliver Pfuhl 2016Apr04   Program to fit dual-field astrometric data
; Christian Hummel: changed OPD_MET_TELFC_MCORR to lower case
;
oiextnum_astro,filelist[0],wavext_p1,visext_p1,fluxext_p1,wavext_p2,visext_p2,fluxext_p2,arrayext,targetext
if pol lt 2 then begin
    wavext=wavext_p1
    visext=visext_p1
    fluxext=fluxext_p1
endif else begin
    wavext=wavext_p2
    visext=visext_p2
    fluxext=fluxext_p2
endelse
; 
; Read Header data
prim=mrdfits(filelist[0],0,head,/dscale,/silent)
oitarget=mrdfits(filelist[0],targetext,head,/dscale,/silent)
oiarray=mrdfits(filelist[0],arrayext,head,/dscale,/silent)
oiwave=mrdfits(filelist[0],wavext,head,/dscale,/silent)
;  
hdprim=headfits(filelist[0],exten=0)
hdtarget=headfits(filelist[0],exten=targetext)
hdarray=headfits(filelist[0],exten=arrayext)
deg2rad=180d/!dpi
;  
teltype=strmid(strtrim(ESOkeyword(hdprim,'T1NAME'),2),0,2); Telescope type
case teltype of 
    'AT': pupscale=0.0136358
    'UT': pupscale=0.059557
    else: pupscale=0.
endcase
;  
;receiver=getMetReceiver(hdprim,teltype)
; 
;set laser wavelength----------------
; CHU modified next line
if strpos(string(ESOkeyword(hdprim,'INS MLAS LWAV')),'missing keyword') ge 0 then begin
    lambda_laser =ESOkeyword(hdprim,'INS MLC WAVELENG') /10.^9 ;
endif else begin
    lambda_laser=ESOkeyword(hdprim,'INS MLAS LWAV') /10.^9;
endelse
polmode=strtrim(ESOkeyword(hdprim,'INS POLA MODE'),2)
specmode=strtrim(ESOkeyword(hdprim,'INS SPEC RES'),2)
dra0=ESOkeyword(hdprim,'INS SOBJ X')/1000.
ddec0=ESOkeyword(hdprim,'INS SOBJ Y')/1000.
; 
phi=!dpi/180d*ESOkeyword(hdprim,'ISS GEOLAT'); latitude [rad]
elong=!dpi/180d*ESOkeyword(hdprim,'ISS GEOLON'); longitude [rad]
hm=1d*ESOkeyword(hdprim,'ISS GEOELEV'); altitude [m]
tc=ESOkeyword(hdprim,'ISS AMBI TEMP')  ;Temp in [C]
phpa=ESOkeyword(hdprim,'ISS AMBI PRES'); pressure in mbar
rh=1d/100d *ESOkeyword(hdprim,'ISS AMBI RHUM'); relative humidity
wl=2.2d; wavelength in [micron]
xp=0.
yp=0.
dut1=0.
;
; Read from OIFITS data
ra1=oitarget[0].raep0
dec1=oitarget[0].decep0
if n_elements(oitarget.target) eq 2 then begin
    ra2=oitarget[1].raep0
    dec2=oitarget[1].decep0
endif else begin
    ra2=ra1
    dec2=dec1
endelse
ra=mean([ra1,ra2])
dec=mean([dec1,dec2])
;
rc=ra/180d*!dpi
dc=dec/180d*!dpi
;    
;separation in [mas]
dra=dra0;-1d*(ra1-ra2)*cos(dec1) *3600d;*1000d
ddec=ddec0;-1d*(dec1-dec2)*3600d;*1000d
sep=sqrt(dra^2. + ddec^2.)
;proper motion [rad/yr]
pr=oitarget[0].pmra/deg2rad /cos(dc) ;compliant with convention of erfa
pd=oitarget[0].pmdec/deg2rad
px=0d
rv=0d
UVscaling=0.999797d; inverse of the air refractive index at Paranal pressure (1.000203)
;  
nwave=n_elements(oiwave)
wave=oiwave.eff_wave
;    
if n_elements(oitarget) eq 2 then target=[strtrim(oitarget[0].target,2),strtrim(oitarget[1].target,2)]
if n_elements(oitarget) eq 1 then target=[strtrim(oitarget[0].target,2),strtrim(oitarget[0].target,2)]
;  
strct={UCOORD:dblarr(6),VCOORD:dblarr(6), $
	gd_sc:dblarr(6),gd_ft:dblarr(6),gd_disp:dblarr(6), $
	mjd:dblarr(6),met_delta:dblarr(6),dopd_gd:dblarr(6),$
        gd_sc_pol2:dblarr(6),gd_ft_pol2:dblarr(6),dopd_gd_pol2:dblarr(6),$
        IM_phasor:complexarr(nwave,6),swapstate:0,filenum:0,lambda_laser:0d, $
	rejection_flag:intarr(6),eu:dblarr(3,6),ev:dblarr(3,6),ew:dblarr(3,6), $
	eaz:dblarr(3,6),ezd:dblarr(3,6),dopd_gd_err:dblarr(6), $
	sta_name:strarr(2,6),int_time:0.,$
        opd_met_fc_corr:dblarr(6),opd_met_telfc_mcorr:dblarr(6), $
	dopd_gd_tel:dblarr(6),dopd_gd_tel_pol2:dblarr(6),sta_index:intarr(2,6),$
        dopd_phasor_res:dblarr(6), $
	PUPIL_U:fltarr(6),PUPIL_V:fltarr(6),PUPIL_OPD:fltarr(6), $
	visdata:complexarr(nwave,6),phase_ref:dblarr(nwave,6), $
	opd_disp:dblarr(nwave,6),phasor_res:complexarr(nwave,6), $
	target:strarr(2),pra:0d,dra:0d,ddec:0d,rc:0d,dc:0d,pr:0d,pd:0d,targnum:0}
;
auxstrct={FT_POS:fltarr(4),SC_POS:fltarr(4),FDDL:fltarr(4),  $
	OPD_MET_FC:dblarr(4),OPD_MET_TELFC_CORR:dblarr(4,4), $
	PHASOR_MET_TELFC:complexarr(4,4), $
	fiber_dx:fltarr(4),fiber_dy:fltarr(4),sta_index:intarr(4), $
	PUPIL_U:fltarr(4),PUPIL_V:fltarr(4),PUPIL_OPD:dblarr(4), $
	swapstate:0,pra:0d,dra:0d,dra_fib:dblarr(4),ddec_fib:dblarr(4),$
        eaz:dblarr(3),ezd:dblarr(3),eu:dblarr(3),ev:dblarr(3), $
	ddec:0d,targnum:0,flux_ft:fltarr(4),flux_sc:fltarr(4), $
	northang:fltarr(4)}
;  
envstrct={mjd:0d,Temp:0.,press:0.,Seeing:0.,tau0:0.,hum:0.,anisopl:fltarr(6), $
	sta_name:strarr(2,6)}
;
arr=strtrim(oiarray[0].sta_name,2)+' '+strtrim(oiarray[1].sta_name,2) $
	+' '+strtrim(oiarray[2].sta_name,2)+' '+strtrim(oiarray[3].sta_name,2)
;
obs={sta_name:oiarray.sta_name,staxyz:oiarray.staxyz,tel_name:oiarray.tel_name, $
       raep0:oitarget.raep0,decep0:oitarget.decep0,rc:rc,dc:dc,dra:dra,ddec:ddec,$
       pr:pr,pd:pd,px:px,rv:rv,uvscale:uvscaling,wl:wl,hm:hm,phi:phi,elong:elong, $
       target:target,polmode:polmode,specmode:specmode,baseline:fltarr(6),$
       base_name:strarr(2,6),xp:xp,yp:yp,dut1:dut1,array_name:arr,wave:wave }
;  
oivis_=mrdfits(filelist[0],visext,head,/dscale,/silent)
;
nbase=6
for ibase=0,nbase-1 do begin 
    obs.base_name[0,ibase]=strtrim( $
	    oiarray[where(oiarray.sta_index eq oivis_[ibase].sta_index[0])].sta_name,2)
    obs.base_name[1,ibase]=strtrim( $
	    oiarray[where(oiarray.sta_index eq oivis_[ibase].sta_index[1])].sta_name,2)     
    tmp=oiarray[where(oiarray.sta_index eq oivis_[ibase].sta_index[0])].staxyz $
      - oiarray[where(oiarray.sta_index eq oivis_[ibase].sta_index[1])].staxyz
    obs.baseline[ibase]=sqrt(tmp[0]^2. + tmp[1]^2. + tmp[2]^2.)
endfor
;  
astrct=[]
aux=[]
env=[]
targnum=0
;
for ifile=0,n_elements(filelist)-1 do begin
;
    hd=headfits(filelist[ifile],exten=0)
    if keyword_Set(swap) then begin
      swapstate=swap[ifile]
    endif else begin
      swapstate=strtrim(ESOkeyword(hd,'INS SOBJ SWAP'),2)
    endelse  
;
    tc=ESOkeyword(hd,'ISS AMBI TEMP')  ;Temp in [C]
    phpa=ESOkeyword(hd,'ISS AMBI PRES'); pressure in mbar
    rh=1d/100d *ESOkeyword(hd,'ISS AMBI RHUM'); relative humidity
    seeing=( ESOkeyword(hd,'ISS AMBI FWHM START') + ESOkeyword(hd,'ISS AMBI FWHM END')  ) /2.
    tau0=( ESOkeyword(hd,'ISS AMBI TAU0 START') + ESOkeyword(hd,'ISS AMBI TAU0 END')  ) /2.
    alpha_ft=ESOkeyword(hd,'FT ROBJ ALPHA')
    delta_ft=ESOkeyword(hd,'FT ROBJ DELTA') 
    dra0=ESOkeyword(hd,'INS SOBJ X')/1000.
    ddec0=ESOkeyword(hd,'INS SOBJ Y')/1000.
    if swapstate eq 'NO' then sign=1
    if swapstate eq 'YES' then sign=-1
    northang=fltarr(4)
    for itel =0,3 do northang[itel]=esokeyword(hd,'ACQ FIELD'+strtrim(string(4-itel),2) +' NORTH_ANGLE')
    drotoff1=esokeyword(hd,'DROTOFF1');preliminary 
    theta=atan(dra0/ddec0) * 180./!pi
    rho_rad=sqrt(dra0^2. + ddec0^2.)/3600./180.*!pi
;
    print,'Reading file: ',   filelist[ifile] 
    oitarget=mrdfits(filelist[ifile],targetext,head,/dscale,/silent)
    if n_elements(oitarget) eq 2 then target=[strtrim(oitarget[0].target,2),strtrim(oitarget[1].target,2)]
    if n_elements(oitarget) eq 1 then target=[strtrim(oitarget[0].target,2),strtrim(oitarget[0].target,2)]
;    
    ra1=oitarget[0].raep0
    dec1=oitarget[0].decep0
    if n_elements(oitarget.target) eq 2 then begin
      ra2=oitarget[1].raep0
      dec2=oitarget[1].decep0
    endif else begin
      ra2=ra1
      dec2=dec1
    endelse
    ra=mean([ra1,ra2])
    dec=mean([dec1,dec2])
    rc=ra/180d*!dpi
    dc=dec/180d*!dpi
    pr=oitarget[0].pmra/deg2rad /cos(dc) ;compliant with convention of erfa
    pd=oitarget[0].pmdec/deg2rad
    dra=dra0;
    ddec=ddec0;
;       
    oivis_=mrdfits(filelist[ifile],visext,head,/dscale,/silent)
    oiflux_=mrdfits(filelist[ifile],fluxext,head_flux,/dscale,/silent)
    if polmode eq 'SPLIT' then oivis_pol2=mrdfits(filelist[ifile],visext_p2,head,/dscale,/silent)
    nframes=n_elements(oivis_)/nbase
;    
    astrct_=replicate(strct,nframes)
    aux_=replicate(auxstrct,nframes)
    env_=replicate(envstrct,nframes)
    for iframe=0,nframes -1 do begin
      hvec=lindgen(6)+nbase*iframe
      hvec_flux=lindgen(4)+4*iframe
      env_[iframe].temp=tc+273.15
      env_[iframe].press=phpa
      env_[iframe].hum=rh
      env_[iframe].seeing=seeing
      env_[iframe].tau0=tau0
      env_[iframe].anisopl=1420. * obs.baseline^(-2./3) * sep *(seeing/0.4)^(5./6) ;[muas / s];PhD Pfuhl 
      env_[iframe].mjd=oivis_[hvec[0]].mjd
      astrct_[iframe].target=target
      astrct_[iframe].rc=rc			; mean RA
      astrct_[iframe].dc=dc			; mean Dec
      astrct_[iframe].pr=pr			; proper motion RA
      astrct_[iframe].pd=pd			; proper motion Dec
      astrct_[iframe].dra=dra
      astrct_[iframe].ddec=ddec   
      astrct_[iframe].ucoord=oivis_[hvec].ucoord
      astrct_[iframe].vcoord=oivis_[hvec].vcoord
      astrct_[iframe].sta_index=oivis_[hvec].sta_index
      astrct_[iframe].mjd=oivis_[hvec].mjd
      astrct_[iframe].gd_ft=oivis_[hvec].gdelay_ft	; GDELAY_FT of SC 
      astrct_[iframe].gd_sc=oivis_[hvec].gdelay;_boot	; GDELAY_BOOT of SC
      ;--------------new data-------------------
      if tag_exist(oivis_,'opd_met_fc_corr') then begin ;if new pipeline reduction
        astrct_[iframe].opd_met_fc_corr=oivis_[hvec].opd_met_fc_corr;_boot
        astrct_[iframe].opd_met_telfc_mcorr=oivis_[hvec].opd_met_telfc_mcorr;
      endif
      if tag_exist(oivis_,'pupil_x') then begin ;if new pipeline reduction
      ang=(-theta-drotoff1+270.)/180.*!pi
;     X,Y,Z = pupil shifts in detector coordinates
      astrct_[iframe].PUPIL_U=(oivis_[hvec].PUPIL_X *cos(ang) - oivis_[hvec].PUPIL_Y*sin(ang))*pupscale
      astrct_[iframe].PUPIL_V=(oivis_[hvec].PUPIL_Y *cos(ang) + oivis_[hvec].PUPIL_X*sin(ang))*pupscale
      astrct_[iframe].PUPIL_OPD=(oivis_[hvec].PUPIL_x *cos(drotoff1/180.*!pi) + oivis_[hvec].PUPIL_y*sin(drotoff1/180.*!pi))*pupscale*rho_rad
      endif
      ;--------------new data-------------------
      astrct_[iframe].rejection_flag=oivis_[hvec].rejection_flag
      astrct_[iframe].gd_disp=oivis_[hvec].gdelay_disp
      astrct_[iframe].swapstate=sign
      astrct_[iframe].int_time=oivis_[hvec[0]].int_time
      astrct_[iframe].filenum=ifile
      astrct_[iframe].lambda_laser=lambda_laser
      astrct_[iframe].eu=oivis_[hvec].e_u
      astrct_[iframe].ev=oivis_[hvec].e_v
      astrct_[iframe].ew=oivis_[hvec].e_w
      astrct_[iframe].eaz=oivis_[hvec].e_az
      astrct_[iframe].ezd=oivis_[hvec].e_zd
      ;GD rms error see Lawson 99, p. 138 (152)  #1d-7 Res(FT)=20
      astrct_[iframe].dopd_gd_err=1./oivis_[hvec].snr *sqrt(12.)*20. *2.2e-6/(2.*!pi)
      ;delta metrology Tel-FC
      tmp=total(oivis_[hvec].phasor_met_telfc/abs(oivis_[hvec].phasor_met_telfc),1)      
      astrct_[iframe].met_delta=-1d*atan(imaginary(tmp),real_part(tmp))*lambda_laser/(2d*!dpi)
  
      astrct_[iframe].dopd_gd=astrct_[iframe].gd_ft-astrct_[iframe].gd_sc + astrct_[iframe].gd_disp 
      astrct_[iframe].dopd_gd_tel=astrct_[iframe].gd_ft-astrct_[iframe].gd_sc $
	      + astrct_[iframe].gd_disp $
	      + astrct_[iframe].opd_met_fc_corr $
              + astrct_[iframe].opd_met_telfc_mcorr
      
      astrct_[iframe].visdata=oivis_[hvec].VISDATA
      astrct_[iframe].phase_ref=oivis_[hvec].phase_ref
      astrct_[iframe].OPD_DISP=oivis_[hvec].OPD_DISP
      aux_[iframe].dra=dra
      aux_[iframe].ddec=ddec
      aux_[iframe].swapstate=sign
      for itel=0,3 do aux_[iframe].dra_fib[itel]=dra*sign;sign must not change with swap
      for itel=0,3 do aux_[iframe].ddec_fib[itel]=ddec*sign;sign must not change with swap      
      aux_[iframe].SC_POS=oiflux_[hvec_flux].SC_POS
      aux_[iframe].FT_POS=oiflux_[hvec_flux].FT_POS
      aux_[iframe].FDDL=oiflux_[hvec_flux].FDDL
      aux_[iframe].OPD_MET_FC=oiflux_[hvec_flux].OPD_MET_FC
      aux_[iframe].eaz=astrct_[iframe].eaz[*,0]
      aux_[iframe].ezd=astrct_[iframe].ezd[*,0]
      aux_[iframe].eu=astrct_[iframe].eu[*,0]
      aux_[iframe].ev=astrct_[iframe].ev[*,0]
;      
      ;#BUGFIX: PHASOR_MET_TELFC changes sign with swap.....reason unclear. This should not be...
      for i=0,3 do  aux_[iframe].PHASOR_MET_TELFC[*,i]=oiflux_[hvec_flux].PHASOR_MET_TELFC[i];/abs(oiflux_[hvec_flux].PHASOR_MET_TELFC[i])
     ;for i=0,3 do  aux_[iframe].PHASOR_MET_TELFC[*,i]=complex(real_part(aux_[iframe].PHASOR_MET_TELFC[*,i]),sign*imaginary(aux_[iframe].PHASOR_MET_TELFC[*,i]))
      if tag_exist(oiflux_,'OPD_MET_TELFC_CORR') then begin
        for i=0,3 do  aux_[iframe].OPD_MET_TELFC_CORR[*,i]=oiflux_[hvec_flux].OPD_MET_TELFC_CORR[i]
      endif
      aux_[iframe].STA_INDEX=oiflux_[hvec_flux].STA_INDEX
      if tag_exist(oiflux_,'field_fiber_dx') then begin
        aux_[iframe].fiber_dx=oiflux_[hvec_flux].field_fiber_dx
        aux_[iframe].fiber_dy=oiflux_[hvec_flux].field_fiber_dy
        aux_[iframe].flux_ft=oiflux_[hvec_flux].totalflux_ft
        aux_[iframe].flux_sc=oiflux_[hvec_flux].totalflux_sc
        aux_[iframe].northang[*]=northang[*]/180.*!pi
      endif
;      
      if tag_exist(oiflux_,'PUPIL_X') then begin
        ang=(-theta-drotoff1+270.)/180.*!pi
        aux_[iframe].PUPIL_U=(oiflux_[hvec_flux].PUPIL_X *cos(ang) $
			    - oiflux_[hvec_flux].PUPIL_Y*sin(ang))*pupscale
        aux_[iframe].PUPIL_V=(oiflux_[hvec_flux].PUPIL_Y *cos(ang) $
			    + oiflux_[hvec_flux].PUPIL_X*sin(ang))*pupscale
        aux_[iframe].PUPIL_OPD=(oiflux_[hvec_flux].PUPIL_x *cos(drotoff1/180.*!pi) $
			      + oiflux_[hvec_flux].PUPIL_y*sin(drotoff1/180.*!pi))*pupscale*rho_rad
      endif
;     
      if polmode eq 'SPLIT' then begin        
        astrct_[iframe].gd_ft_pol2=oivis_pol2[hvec].gdelay_ft
        astrct_[iframe].gd_sc_pol2=oivis_pol2[hvec].gdelay    
        astrct_[iframe].dopd_gd_pol2=(astrct_[iframe].gd_ft_pol2 $
				     -astrct_[iframe].gd_sc_pol2) $
				     +astrct_[iframe].gd_disp;
        astrct_[iframe].dopd_gd_tel_pol2=(astrct_[iframe].gd_ft_pol2 $
					 -astrct_[iframe].gd_sc_pol2) $
					 +astrct_[iframe].gd_disp $
					 +astrct_[iframe].opd_met_fc_corr $
          				 +astrct_[iframe].opd_met_telfc_mcorr
      endif
;      
      for ibase=0,nbase-1 do begin
        astrct_[iframe].sta_name[0,ibase]= $
		strtrim(oiarray[where(oiarray.sta_index eq oivis_[hvec[ibase]].sta_index[0])].sta_name,2)
        astrct_[iframe].sta_name[1,ibase]= $
		strtrim(oiarray[where(oiarray.sta_index eq oivis_[hvec[ibase]].sta_index[1])].sta_name,2)
        astrct_[iframe].IM_phasor[*,ibase]=  $
		conj(astrct_[iframe].VISDATA[*,ibase]) * exp(complex(0,2d*!PI * astrct_[iframe].OPD_DISP[*,ibase]/wave,/double)) *$
               exp(complex(0,-1d * astrct_[iframe].phase_Ref[*,ibase],/double))
      endfor
      astrct_[iframe].pra=atan(total((astrct_[iframe].eU[*,0]) * (-1d*astrct_[iframe].eZd[*,0])),total((astrct_[iframe].eV[*,0]) * $
             (-1d*astrct_[iframe].eZd[*,0])))
      aux_[iframe].pra=astrct_[iframe].pra
    endfor
;
    astrct=[astrct,astrct_]
    aux=[aux,aux_]
    env=[env,env_]
  endfor
;
; minimum distance to distinguish two objects
  lim=10d*4.8481368d-09;distance =40mas
  astrct[0].targnum=0
  aux[0].targnum = 0
  targ_counter=0
  for iframe=1,n_elements(astrct) -1 do begin
    dist=sqrt((astrct[0:iframe-1].rc-astrct[iframe].rc)^2d + (astrct[0:iframe-1].dc-astrct[iframe].dc)^2d )
    tmp_obj_list=astrct[0:iframe-1].target
    fff=where(abs(astrct[0:iframe-1].rc-astrct[iframe].rc) le lim and abs(astrct[0:iframe-1].dc-astrct[iframe].dc) le lim )
    if fff ne [-1] then begin;object already in list
        astrct[iframe].targnum = astrct[fff[0]].targnum
        astrct[iframe].swapstate= astrct[iframe].ddec/astrct[fff[0]].ddec
        aux[iframe].swapstate= astrct[iframe].ddec/astrct[fff[0]].ddec
        aux[iframe].targnum = astrct[iframe].targnum
    endif else begin ;new object
      targ_counter=targ_counter+1
      astrct[iframe].targnum = targ_counter;astrct[iframe-1].targnum +1
      astrct[iframe].swapstate=1
      aux[iframe].swapstate=1
      aux[iframe].targnum = astrct[iframe].targnum
      print,'Add object: ',astrct[iframe].target,min(dist),iframe
    endelse    
  endfor 
;  
  ;hh=getMetFiberOffset(receiver,teltype,aux0=aux)
  hh=getTelPhasefromFibOff(aux,hdprim)
; 
end
;-------------------------------------------------------------------------------
