;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;---------------	MAIN PROG	--------------------------------
;-----------------------------------------------------------------------

pro ExtSpec, fname, PSFname, save=save, readfile=readfile, savegauss=savegauss, printresu=printresu


  fname = fname[0]
  hdrname= (oirFileList(fname))[0]
  PSFname = PSFname[0]
  hdrnamePSF= (oirFileList(PSFname))[0]

loadct,3
;ima=oirgetdata(fname)
;PSF=oirgetdata(PSFname)
name = make_shortname(fname)
namePSF = make_shortname(PSFname)

im=obj_new('fitsfile',hdrname)
he = im->prihead()
OBJECT        = STRCOMPRESS(he->getpar('OBS TARG NAME'),/remove_all)
SHUT        = STRCOMPRESS(he->getpar('INS SHUT'),/remove_all)
INS_OPT1_NAME = STRCOMPRESS(he->getpar('INS OPT1 NAME'),/remove_all)
INS_GRIS_NAME = STRCOMPRESS(he->getpar('INS GRIS NAME'),/remove_all)
obj_destroy,im
beam 	= INS_OPT1_NAME
disp	= INS_GRIS_NAME

im=obj_new('fitsfile',hdrnamePSF)
he = im->prihead()
OBJECT_PSF        = STRCOMPRESS(he->getpar('OBS TARG NAME'),/remove_all)
obj_destroy,im

shortname=OBJECT+name+'_'+namePSF+SHUT
print, shortname


 IF NOT keyword_set(readfile) then begin
if (beam EQ 'HIGH_SENS') or (beam EQ 'OPEN') then begin
      chop_image1=MIDIChopImageC(fname)
          on_source_win1 = chop_image1[1].data1
          on_source_win2 = chop_image1[1].data2
          off_source_win1= chop_image1[0].data1
          off_source_win2= chop_image1[0].data2
          win1 = off_source_win1-on_source_win1
          win2 = off_source_win2-on_source_win2
       chop_image2=MIDIChopImageC(PSFname)
          on_source_win1_PSF = chop_image2[1].data1
          on_source_win2_PSF = chop_image2[1].data2
          off_source_win1_PSF= chop_image2[0].data1
          off_source_win2_PSF= chop_image2[0].data2
          win1_PSF = off_source_win1_PSF-on_source_win1_PSF
          win2_PSF = off_source_win2_PSF-on_source_win2_PSF
endif else if (beam EQ 'SCI_PHOT') then begin
      chop_image1=MIDIChopImageC(fname)
          on_source_win1 = chop_image1[1].data2
          on_source_win2 = chop_image1[1].data3
          off_source_win1= chop_image1[0].data2
          off_source_win2= chop_image1[0].data3
          win1 = off_source_win1-on_source_win1
          win2 = off_source_win2-on_source_win2
       chop_image2=MIDIChopImageC(PSFname)
          on_source_win1_PSF = chop_image2[1].data2
          on_source_win2_PSF = chop_image2[1].data3
          off_source_win1_PSF= chop_image2[0].data2
          off_source_win2_PSF= chop_image2[0].data3
          win1_PSF = off_source_win1_PSF-on_source_win1_PSF
          win2_PSF = off_source_win2_PSF-on_source_win2_PSF
endif

          n=SIZE(win1)
	  x_size=n[1]
	  y_size=n[2]
	  print, 'IMAGE', x_size,y_size
	  n=SIZE(win1_PSF)
	  x_size=n[1]
	  y_size=n[2]

	if (disp EQ 'GRISM') then wave=wavecalgrism(x_size)
	if (disp EQ 'PRISM') then wave=wavecalprism(x_size)
	  range=x_size

IF keyword_set(save) then begin
writefits,name+'win1.fits',win1 
writefits,name+'win2.fits',win2 
writefits,namePSF+'win1.fits',win1_PSF
writefits,namePSF+'win2.fits',win2_PSF
ENDIF
  ENDIF ;ENDIF readfile

IF keyword_set(readfile) then begin
win1=readfits(name+'win1.fits')
win2=readfits(name+'win2.fits')
win1_PSF=readfits(namePSF+'win1.fits')
win2_PSF=readfits(namePSF+'win2.fits')
ENDIF


print, 'PSF  ', x_size,y_size
win1test=win1+3
win2test=win2+3
win1test_PSF=win1_PSF+3
win2test_PSF=win2_PSF+3
;win1test(where(win1test lt 0.1))=0.1
;win2test(where(win2test lt 0.1))=0.1
;win1test_PSF(where(win1test_PSF lt 0.1))=0.1
;win2test_PSF(where(win2test_PSF lt 0.1))=0.1

;tvscl, alog10(congrid(win1test, 600, 100))
;read, tmp
;tvscl, alog10(congrid(win2test, 600, 100))
;read, tmp
;tvscl, alog10(congrid(win1test_PSF, 600, 100))
;read, tmp
;tvscl, alog10(congrid(win2test_PSF, 600, 100))
;read, tmp


print,'-------------  FIRST FIND THE STAR ---------------'
  FOV_x1 = 0
  FOV_x2 = x_size-1
  FOV_y1 = 0
  FOV_y2 = y_size-1

fit2D_B= gauss2dfit(win1(FOV_x1:FOV_x2,FOV_y1:FOV_y2),b)
print,'----------------------------------------'
print, 'Star gauss. B:', b[4]+FOV_x1, b[5]+FOV_y1
print, 'FWHM x, y',  b[2], b[3]
print, 'Max image', max(win1, status), ' Pos X = ', status mod x_size, ' Pos y = ', trunc(status/x_size)

fit2D_A= gauss2dfit(win2(FOV_x1:FOV_x2,FOV_y1:FOV_y2),a)
print,'----------------------------------------'
print, 'Star gauss. A:', a[4]+FOV_x1, a[5]+FOV_y1
print, 'FWHM x, y',  a[2], a[3]
print, 'Max image', max(win2, status), ' Pos X = ', status mod x_size, ' Pos y = ', trunc(status/x_size)
print,'----------------------------------------'

;center_x=trunc(b[4])+FOV_x1
center_y=trunc(b[5])+FOV_y1
scaley = (dindgen(FOV_y2-FOV_y1)-trunc(b[5]))*0.083	;Based on gaussian fit
;center_x_max=status mod x_size-FOV_x1
center_y_max=trunc(status/x_size-FOV_y1)
;scaley = (dindgen(FOV_y2-FOV_y1)-center_y_max)*0.083	;Based on maximum
;scalex = (dindgen(FOV_y2-FOV_y1)-center_x_max)*0.083

    !p.multi=[0, 0, 4, 0, 0]
    window, 1, xsize=600, ysize=600
    plot, win2(trunc(a[4])+FOV_x1,FOV_y1:FOV_y2), title="Beam A, x-position"
    oplot, fit2D_A(trunc(a[4]),*), linestyle=1
    plot, win2(FOV_x1:FOV_x2,trunc(a[5])+FOV_y1), title="Beam A, y-position"
    oplot, fit2D_A(*,trunc(a[5])), linestyle=1
    plot, win1(trunc(b[4])+FOV_x1,FOV_y1:FOV_y2), title="Beam B, x-position"
    oplot, fit2D_B(trunc(b[4]),*), linestyle=1
    plot, win1(FOV_x1:FOV_x2,trunc(b[5])+FOV_y1), title="Beam B, y-position"
    oplot, fit2D_B(*,trunc(b[5])), linestyle=1
    !p.multi=[0, 0, 1, 0, 0]

    testOk= "string"
    ;read, '> Is the dataset satisfactory from display inspection? (y/n) ? ', testOK
    testOK='y'
    if (strupcase(testOK) eq "N") then begin
        print, '<!> OK try another file'
        goto, ende
    endif

factor=3

  trace1   = fltarr(x_size)
  sigma1   = fltarr(x_size)
  FWHM1    = fltarr(x_size)
  Flux_max1= fltarr(x_size)
  trace1_PSF   = fltarr(x_size)
  sigma1_PSF   = fltarr(x_size)
  FWHM1_PSF   = fltarr(x_size)
  Flux_max1_PSF= fltarr(x_size)
  trace2   = fltarr(x_size)
  sigma2   = fltarr(x_size)
  FWHM2    = fltarr(x_size)
  Flux_max2= fltarr(x_size)
  trace2_PSF   = fltarr(x_size)
  sigma2_PSF   = fltarr(x_size)
  FWHM2_PSF   = fltarr(x_size)
  Flux_max2_PSF= fltarr(x_size)

  column = dindgen(y_size)
  ntermgauss=3
  gausswin1=fltarr(range,ntermgauss)
  gausswin2=fltarr(range,ntermgauss)
  gausswin1_PSF=fltarr(range,ntermgauss)
  gausswin2_PSF=fltarr(range,ntermgauss)

  ;
  ; first find pos and width for each column with sufficient signal
  ;
  FOR i= 0, range-1 DO BEGIN
      IF (total(win1(i,*)) gt y_size) THEN BEGIN
          ; do a little median smoothing on the column to remove badpix
          tmp=median(reform(win1[i,5:35]),3)
          ;tmp(where(tmp lt 0.0))=0.0
          fit1D= gaussfit(column[5:35], tmp , b, NTERMS=ntermgauss)
	  gausswin1[i,*]=b
	;if i eq 0 then plot,sqrt(tmp)/max(sqrt(tmp)), yrange=[0,1], xtitle='Pixel', ytitle='ADUs/fr'
	;oplot,sqrt(fit1D)/max(sqrt(fit1D))
;	print,wave[i]
;	read, toto
         if (b[1] gt 0 and b[1] lt y_size) then begin
              trace1[i]   = b[1]
              sigma1[i]   = b[2]
              FWHM1[i]    = 2.*b[2]*(sqrt(2*alog(2)))
              Flux_max1[i]= b[0]
          end
 ;       tmpPSF=median(reform(win1_PSF[i,*]),3)
   	fit1D= gaussfit(column, median(reform(win1_PSF[i,*]),3), b, NTERMS=ntermgauss)
   	gausswin2[i,*]=b
 ;	if i eq 0 then plot,tmpPSF, yrange=[0,250], xtitle='Pixel', ytitle='ADUs/fr'
;	oplot,tmpPSF	
;	print,wave[i]
;	read, toto
          if (b[1] gt 0 and b[1] lt y_size) then begin
              trace1_PSF[i]   = b[1]
              sigma1_PSF[i]   = b[2]
              FWHM1_PSF[i]    = 2.*b[2]*(sqrt(2*alog(2)))
              Flux_max1_PSF[i]= b[0]
          end
           fit1D= gaussfit(column, median(reform(win2[i,*]),3), b, NTERMS=ntermgauss)
           gausswin1_PSF[i,*]=b
          if (b[1] gt 0 and b[1] lt y_size) then begin
              trace2[i]   = b[1]
              sigma2[i]   = b[2]
              FWHM2[i]    = 2.*b[2]*(sqrt(2*alog(2)))
              Flux_max2[i]= b[0]
          end
           fit1D= gaussfit(column, median(reform(win2_PSF[i,*]),3), b, NTERMS=ntermgauss)
           gausswin2_PSF[i,*]=b
          if (b[1] gt 0 and b[1] lt y_size) then begin
              trace2_PSF[i]   = b[1]
              sigma2_PSF[i]   = b[2]
              FWHM2_PSF[i]    = 2.*b[2]*(sqrt(2*alog(2)))
              Flux_max2_PSF[i]= b[0]
          end
        endif
  endfor
read, toto

;      plot, trace, yrange = [0,y_size]
;      oplot, trace+sigma, linestyle=2
;      oplot, trace-sigma, linestyle=2
 
 Pix_size = 98  ;in mas
 wave=wave(0:range-1)
 plot,wave, FWHM1*Pix_size, yrange=[200, 900], xrange=[8,13.5],$
 ytitle='FWHM in mas', xtitle='Wavelength in micron'
 oplot, wave,FWHM1_PSF*Pix_size, linestyle=1
 oplot,wave, FWHM2*Pix_size
 oplot, wave,FWHM2_PSF*Pix_size, linestyle=1
 
 if keyword_set(printresu) then begin
 imp,shortname
  plot,wave, FWHM1*Pix_size, yrange=[200, 600], xrange=[8,13.5],$
 ytitle='FWHM in mas', xtitle='Wavelength in micron'
 oplot, wave,FWHM1_PSF*Pix_size, linestyle=1
 oplot,wave, FWHM2*Pix_size
 oplot, wave,FWHM2_PSF*Pix_size, linestyle=1
 device,/close
 set_plot,'X'
 spawn,'gv '+shortname+'.ps'
 endif

print, 'PSF : ',  OBJECT_PSF
print, 'Target : ',OBJECT



;-----------------------------------------------------------------------
 if keyword_set(savegauss) then begin
;save, gausswin1, filename=OBJECT+'Bwin1.dat'
;save, gausswin2, filename=OBJECT+'Bwin2.dat'
save, gausswin1_PSF, filename=OBJECT_PSF+'Awin1.dat'
save, gausswin2_PSF, filename=OBJECT_PSF+'Awin2.dat'

ENDIF

  ende:
end