
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;---------------	MAIN PROG	--------------------------------
;-----------------------------------------------------------------------

pro chop_dir, fname, MOVIE=movie, PRINT=print

loadct,3
set_plot, 'X'

ima=oirgetdata(fname)
name = make_shortname(fname)
	image_win1=FLOAT(ima.data1)+32768.
	image_win2=FLOAT(ima.data2)+32768.
cleanname= (oirFileList(fname))[0]

im=obj_new('fitsfile',cleanname)
he = im->prihead()
  OBJECT = STRCOMPRESS(he->getpar('OBS TARG NAME'),/remove_all)
obj_destroy,im

shortname=OBJECT+name
print, shortname      

factor=4
n=SIZE(ima.data1)
x_size=n[1]
y_size=n[2]
NDIT_ima  =n[3]
print, 'IMAGE', x_size,y_size
print,'NDIT IMAGE',ndit_ima
chopping = ima.TARTYP1

      chop_image1=MIDIChopImage(fname)
          on_source_win1 = chop_image1[1].data1
          on_source_win2 = chop_image1[1].data2
          off_source_win1= chop_image1[0].data1
          off_source_win2= chop_image1[0].data2
          win1 = off_source_win1-on_source_win1
          win2 = off_source_win2-on_source_win2


print,'------------- Check of the images -------------------------'
win_big1=rebin(win1,x_size*factor,y_size*factor)+20.
win_big2=rebin(win2,x_size*factor,y_size*factor)+20.
sky1=rebin(on_source_win1,x_size*factor,y_size*factor)
sky2=rebin(on_source_win2,x_size*factor,y_size*factor)
window, 0, xsize=500, ysize=550
index=where(win_big1 le 0., count)
if count ne 0.0 then win_big1(where(win_big1 le 0.)) = 0.01
index=where(win_big2 le 0., count)
if count ne 0.0 then win_big2(where(win_big2 le 0.)) = 0.01
tvscl,sqrt(sqrt(win_big1)),0
tvscl,sqrt(sqrt(win_big2)),1
tvscl,sky1,2
tvscl,sky2,3

if keyword_set(print) then begin
set_plot,'ps'
file='PS/'+shortname+'_OBJ.ps'
device, filename=file,/color, bits_per_pixel=8, xsize=10.0, ysize=10.0
win1(where(win1 le 0.0)) = 0.0
win2(where(win2 le 0.0)) = 0.0
test=fltarr(2.*x_size,2*y_size)
test[0:x_size-1,0:y_size-1]=on_source_win1
test[0:x_size-1,y_size:2*y_size-1]=sqrt(sqrt(win1))*max(on_source_win1)/max(sqrt(sqrt(win1)))
test[x_size:2*x_size-1,0:y_size-1]=on_source_win2
test[x_size:2*x_size-1,y_size:2*y_size-1]=sqrt(sqrt(win2))*max(on_source_win1)/max(sqrt(sqrt(win1)))
tvscl,test
device,/close
set_plot,'X'
spawn, 'gv '+file
endif 

    testOk= "string"
    read, '> Is the dataset satisfactory from display inspection? (y/n) ? ', testOK
    ;testOK='y'
    if (strupcase(testOK) eq "N") then begin
        print, '<!> OK try another file'
        goto, ende
    endif

if keyword_set(movie) then begin
  print,'------------- Chopping movie -------------------------'
endif 
         unknown1 = win1 - win1
         unknown2 = win2 - win2
         rms1 =fltarr(x_size, y_size, trunc(NDIT_ima))
         rms2 =fltarr(x_size, y_size, trunc(NDIT_ima))
         status = 0
	FOR frame_index=4,NDIT_ima-1 DO BEGIN
		 IF (chopping[frame_index] EQ 'U ') THEN BEGIN
		 ;IF (chopping[frame_index] EQ 'T ') THEN BEGIN
		 tmp_im1 = FLOAT(image_win1[*,*,frame_index])
		 tmp_im2 = FLOAT(image_win2[*,*,frame_index])
		 unknown1 = unknown1 + tmp_im1
		 unknown2 = unknown2 + tmp_im2
		 rms1[*,*,status] = tmp_im1- on_source_win1
		 rms2[*,*,status] = tmp_im2- on_source_win2
		 if keyword_set(movie) then begin
		 tvscl, rebin(tmp_im1- on_source_win1,x_size*factor,y_size*factor),0
		 tvscl, rebin(tmp_im2- on_source_win2,x_size*factor,y_size*factor),1
		 endif
		 status= status+1
		ENDIF
	ENDFOR
	unknown1 = unknown1/status - on_source_win1
	unknown1_big=rebin(unknown1,x_size*factor,y_size*factor)
	unknown2 = unknown2/status - on_source_win2
	unknown2_big=rebin(unknown2,x_size*factor,y_size*factor)
	rms1 = rms1[*,*,0:status]
	devstandard, rms1, stdtest1
	stdtest1_big=rebin(stdtest1-mean(stdtest1),x_size*factor,y_size*factor)
	rms2 = rms2[*,*,0:status]
	devstandard, rms2, stdtest2
	stdtest2_big=rebin(stdtest2-mean(stdtest2),x_size*factor,y_size*factor)
print,'------------- Chopping direction -------------------------'

window, 0, xsize=500, ysize=550
tvscl,unknown1_big,0
tvscl,unknown2_big,1
tvscl,stdtest1_big,2
tvscl,stdtest2_big,3
print,'Number of U states : ',status

if keyword_set(print) then begin
set_plot,'ps'
file='PS/'+shortname+'_DIR.ps'
device, filename=file,/color, bits_per_pixel=8, xsize=10.0, ysize=10.0
test=fltarr(2.*x_size,2*y_size)
test[0:x_size-1,0:y_size-1]=unknown1/max(unknown1)
test[0:x_size-1,y_size:2*y_size-1]=stdtest1/max(stdtest1)
test[x_size:2*x_size-1,0:y_size-1]=unknown2/max(unknown2)
test[x_size:2*x_size-1,y_size:2*y_size-1]=stdtest2/max(stdtest2)
tvscl,test
device,/close
set_plot,'X'
spawn, 'gv '+file
endif 

	ende:
end