pro chop_disp_spatial, win, x_size, y_size, bands, t_order, w_order, gain, $
                              trace,FWHM,Flux_max, Flux,Flux_c, weighting_win, range,$
                              XMIN=xmin, XMAX=xmax, NOISE=noise, TRACE_C=trace_coeff,$
                              SIGMA_C=sigma_coeff, DEBUG=debug, SILENT=silent

  if not keyword_set(noise) then noise= 1.0

  print,"window is ",x_size," x ",y_size

pix_size=98	;in mas
;bands=10
intervals=(y_size-1)/bands
;extent=intervals/1.25
extent=3.2  ;IN PIXELS!!!!!!!

print, 'INTERVALS : ',intervals*pix_size,' in mas'
print, 'BEAM SIZE : ', extent*pix_size,' in mas'
  trace   = fltarr(x_size)
  sigma   = fltarr(x_size)
  FWHM    = fltarr(x_size)
  Flux_max= fltarr(x_size)
  Flux    = fltarr(x_size,bands)
  Flux_c  = fltarr(x_size,bands)
  backgr  = fltarr(x_size)

  win_c = win
  weighting_win = fltarr(x_size,y_size)

  column = dindgen(y_size)

  if not keyword_set(xmin) then xmin= 0
  if not keyword_set(xmax) then xmax= x_size-1
  ;
  ; first find pos and width for each column with sufficient signal
  ;
  FOR i= xmin, xmax DO BEGIN
      IF (total(win(i,*)) gt noise * y_size) THEN BEGIN
          ; do a little median smoothing on the column to remove badpix
          fit1D= gaussfit(column, median(reform(win[i,*]),3), b, NTERMS=3)
          if (b[1] gt 0 and b[1] lt y_size) then begin
              trace[i]   = b[1]
              sigma[i]   = b[2]
              FWHM[i]    = 2*(sqrt(b[2]*alog(2)))
              Flux_max[i]= b[0]
          end
          if keyword_set(debug) then $
            print, "  x=",i, ", y=",trace[i],", fwhm=",sigma[i]
      endif
  endfor
  if keyword_set(debug) then begin
      window,3
      !P.multi= 0
      plot, trace, yrange = [0,y_size]
      oplot, trace+sigma, linestyle=2
      oplot, trace-sigma, linestyle=2
      junk="" & read,"Hit return",junk
  end
  ;
  ; now fit a polynomial to it
  ;
  range = where(Flux_max gt 0)
  trace_coeff= poly_fit(range,trace[range],t_order,MEASURE_ERRORS=1./Flux_max[range])
  trace_fit  = poly(findgen(x_size),trace_coeff)
  sigma_coeff= poly_fit(range,sigma[range],w_order,MEASURE_ERRORS=1./Flux_max[range])
  sigma_fit  = poly(findgen(x_size),sigma_coeff)
  FWHM_fit   = 2.*(sqrt(sigma_fit*alog(2)))
  FWHM_fit   = extent*FWHM_fit/mean(FWHM_fit)
  print,"FWHM_fit: ",mean(FWHM_fit)
  print,"trace coeff: ",transpose(trace_coeff)
  print,"sigma coeff: ",transpose(sigma_coeff)

  ; measure bg, flux, and create mask for ALL columns, not just xmin..xmax
  window,0
;  imp,'EtaCar_CutSlit'
  FOR i= 0, x_size-1 DO BEGIN
	;background correction (polynomial fit per column)
          spec_0 = fix( trace_fit[i] - FWHM_fit[i])
          spec_1 = fix( trace_fit[i] + FWHM_fit[i])
          if (spec_0 le 0)      then spec_0 = 1
          if (spec_0 ge y_size) then spec_0 = y_size-1
          if (spec_1 ge y_size) then spec_1 = y_size-2
          if (spec_1 lt spec_0) then spec_1 = spec_0
          back=[1,2,3,4,5,37,38, 39,40]
          background = [reform(win[i,1:5]),reform(win[i,37:y_size-1]) ]
          back=[1,2,39,40]
          background = [reform(win[i,1:2]),reform(win[i,39:y_size-1]) ]
          
;          background_coef= POLY_FIT(back, background, 1)
;          win_c[i,*]= win[i,*] - POLY(column, background_coef)
win_c[i,*]= win[i,*]
;;;;          FLUX[i]  = total(win_c[i,spec_0:spec_1])

j = findgen(y_size)

FOR ydir=0, bands-1 DO BEGIN
shift=(ydir-bands/2)*intervals
sizebeam=extent
if (abs(shift) gt 11.) then sizebeam=extent*(abs(shift)^1.2)/abs(shift)
if i eq (x_size-1)/2 then print,ydir,trace_fit[i]-shift,shift, shift*pix_size, sizebeam
	FLUX[i,ydir]  = total(win_c[i,spec_0:spec_1])
        weighting_win[i,*] = exp(-(j-trace_fit[i]-shift)^2./(sizebeam)^2.)
;        print,total(weighting_win[i,*])

        FLUX_c[i,ydir]= total(win_c[i,*]* weighting_win[i,*] )
ENDFOR
if not keyword_set(silent) then begin
	if i eq 0 then plot,win_c[i,*], yrange=[0,100], xtitle='Pixel', ytitle='ADUs/fr'
	oplot,win_c[i,*]
endif
;oplot,POLY(column, background_coef)
;print, total(win_c[i,*])


ENDFOR  ;X loop
range = where(Flux_max gt 0)	;plot only points where we did the 1D-gaussfit
;device,/close
;set_plot,'X'
;spawn,'gv PS-EtaCar/'+ 'EtaCar_CutSlit'

;  if not keyword_set(silent) then begin
;      !p.multi=[0, 0,2 , 0, 0]
;      !p.charsize = 1.
;      read, tmp
;      window, 1, xsize=600, ysize=600
;      plot, trace_fit, $
;        yrange=[floor(min(trace_fit-FWHM_fit)), ceil(max(trace_fit+FWHM_fit))],$
;        xtitle='Wavelength (in pixels)', ytitle='Y Photocenter in pix'
;      oplot,range, trace[range], psym=1
;      oplot,trace_fit+FWHM_fit, linestyle=1
;      oplot,trace_fit-FWHM_fit, linestyle=1

;;      plot, Flux_c[*,bands/2]*gain, linestyle=1, xrange=[0,x_size], $
 ;;       xtitle='Wavelength (in pixels)', ytitle='Flux in photons'
;;FOR ydir=0, bands-1 DO BEGIN
 ;;     oplot,Flux_c[*,ydir]*gain
;;ENDFOR
;;endif

end
