;-----------------------------------------------------------------------
pro print_slit,file, array,x_size,y_size

	set_plot,'ps'
	loadct,3
	fichier='PS/'+file+'.ps'
	device, filename=fichier,/color, bits_per_pixel=16, xsize=10.0, ysize=10.0
!p.charsize = 1.0
!p.multi=[0,1,0,0]
pix=0.098
abscX = dindgen(x_size)*pix-(x_size*pix)/2.
abscY = dindgen(y_size)*pix-(x_size*pix)/2.
        position = [0.1,0.1,0.8,0.8]
        s = Size(array, /Dimensions)
        imgXsize = s[0]
        imgYsize = s[1]
        xsize = (position(2) - position(0)) * !D.X_Vsize
        ysize = (position(3) - position(1)) * !D.Y_Vsize
        xstart = position(0) * !D.X_Vsize
        ystart = position(1) * !D.Y_Vsize

position = [0.1,0.1,0.8,0.8]
;threshold = 0.15
threshold = 0.25	;0.4%
;threshold = 0.3165	;1%
;threshold = 0.3975	;2.5%
;-------------------   Color Contours -----------------------------
;number of contours
numb=30
;print,imbox(scale_i_map, yrange=[min_i_map,max_i_map^4], $
;ytitle='I/I!B0!N!3', $
;xsize=.02,ysize=.7,position=[.8,.1],xlabel=-1,ylabel=2)
;lev=(threshold+(1-threshold)*dindgen(numb)/numb)*max_i_map
;lev=[0,lev]
;contour, old_array, abscX, abscY, levels=lev, $
;	        /FILL, ytitle='Arcsec', xtitle='Arcsec' , /noerase, position=position
;------------------- SLIT -----------------------------
tvscl, array

;IN NORMALIZED COORDINATES
size=2.5
;FOV_x1 = 0.1+0.7*((0.5*x_size-size)/x_size)
;FOV_x2 =  0.1+0.7*((0.5*x_size+size)/x_size)
FOV_x1 = ((0.5*x_size-size)/x_size)
FOV_x2 =  ((0.5*x_size+size)/x_size)

size=12
;FOV_y1 =  0.1+0.7*((0.5*y_size-size)/y_size)
;FOV_y2 =  0.1+0.7*((0.5*y_size+size)/y_size)
FOV_y1 =  -0.1+((0.5*y_size-size)/y_size)
FOV_y2 =  -0.1+((0.5*y_size+size)/y_size)

plots,FOV_x1,[FOV_y1,FOV_y2],color=250,/normal, thick=3
plots,FOV_x2,[FOV_y1,FOV_y2],color=250,/normal, thick=3
plots,[FOV_x1,FOV_x2],FOV_y1,color=250,/normal, thick=3
plots,[FOV_x1,FOV_x2],FOV_y2,color=250,/normal, thick=3

angle=-124
arsize=0.1
x1=0.2+arsize*cos(angle/!radeg)
x0=0.2
y0=0.9+arsize*sin(angle/!radeg)
y1=0.9

print, x0,x1,y0,y1
plots,[x0,x1],[y0, y1],color=250,/normal, thick=5

x1=x0+arsize*cos((angle-90)/!radeg)
y1=y0-arsize*sin((angle-90)/!radeg)
print, x0,x1,y0,y1

plots,[x0,x1],[y0, y1],color=250,/normal, thick=5

;-------------------   IMAGE, not filled Contours -----------------------------
;tvscl,tmp, xstart,ystart,$
;       xsize=xsize, ysize=ysize 


;-------------------   Grey, not filled Contours -----------------------------
;numb=10
;lev=(threshold+(1-threshold)*dindgen(numb)/numb)*max_i_map
;lev=[0,lev]
;contour, old_array, abscX, abscY, levels=lev, $
;	         ytitle='Arcsec', xtitle='Arcsec' , /noerase, position=position

device, /close
toto = 'gv '+ fichier
set_plot, 'X'
spawn,toto

end

;-----------------------------------------------------------------------

pro devstandard,cieli,varst
dims=size(cieli)
if (dims(0) ne 3) then begin
 print,'Input must be a data cube!'
endif else begin
xdim=dims(1)
ydim=dims(2)
varst=fltarr(xdim,ydim)
for i=0,xdim-1 do begin
for j=0,ydim-1 do begin
varst(i,j)=stddev(cieli(i,j,*))
endfor
endfor
endelse
end
;-----------------------------------------------------------------------

;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;---------------	MAIN PROG	--------------------------------
;-----------------------------------------------------------------------

pro chop_slit, fname,  PRINT=print, REVERSE=reverse

loadct,3
set_plot, 'X'

ima=oirgetdata(fname)
name = make_shortname(fname)
	image_win1=FLOAT(ima.data1)+32768.
	image_win2=FLOAT(ima.data2)+32768.
cleanname= (oirFileList(fname))[0]

im=obj_new('fitsfile',cleanname)
he = im->prihead()
  OBJECT = STRCOMPRESS(he->getpar('OBS TARG NAME'),/remove_all)
obj_destroy,im

shortname=OBJECT+name
print, 'OBJECT NAME ', shortname      

factor=4
n=SIZE(ima.data1)
x_size=n[1]
y_size=n[2]
NDIT_ima  =n[3]
print, 'IMAGE', x_size,y_size
print,'NDIT IMAGE',ndit_ima
chopping = ima.TARTYP1

;      chop_image1=MIDIChopImage(fname)
;          on_source_win1 = chop_image1[1].data1
;          on_source_win2 = chop_image1[1].data2
;          off_source_win1= chop_image1[0].data1
;          off_source_win2= chop_image1[0].data2
;          win1 = off_source_win1-on_source_win1
;          win2 = off_source_win2-on_source_win2

      chop_image1=MIDIChopImageC(fname)
 ;    chop_image1=MIDIChopImage(fname)
      if keyword_set(reverse) then begin
          on_source_win1 = chop_image1[0].data1
          on_source_win2 = chop_image1[0].data2
          off_source_win1= chop_image1[1].data1
          off_source_win2= chop_image1[1].data2
          win1 = on_source_win1-off_source_win1
          win2 = on_source_win2-off_source_win2
        endif else begin
          on_source_win1 = chop_image1[0].data1
          on_source_win2 = chop_image1[0].data2
          off_source_win1= chop_image1[1].data1
          off_source_win2= chop_image1[1].data2
          win1 = on_source_win1-off_source_win1
          win2 = on_source_win2-off_source_win2
       endelse

print,'------------- Check of the images -------------------------'
win_big1=rebin(win1,x_size*factor,y_size*factor)
win_big2=rebin(win2,x_size*factor,y_size*factor)
sky1=rebin(on_source_win1,x_size*factor,y_size*factor)
sky2=rebin(on_source_win2,x_size*factor,y_size*factor)
window, 0, xsize=500, ysize=550
win_big1(where(win_big1 le 0.)) = 0.01
win_big2(where(win_big2 le 0.)) = 0.01
tvscl,sqrt(sqrt(win_big1)),0
tvscl,sqrt(sqrt(win_big2)),1
tvscl,sky1,2
tvscl,sky2,3

if keyword_set(print) then begin
set_plot,'ps'
file=shortname+'_OBJ.ps'
device, filename=file,/color, bits_per_pixel=8, xsize=10.0, ysize=10.0
win1(where(win1 le 0.0)) = 0.0
win2(where(win2 le 0.0)) = 0.0
test=fltarr(2.*x_size,2*y_size)
test[0:x_size-1,0:y_size-1]=on_source_win1
test[0:x_size-1,y_size:2*y_size-1]=sqrt(sqrt(win1))*max(on_source_win1)/max(sqrt(sqrt(win1)))
test[x_size:2*x_size-1,0:y_size-1]=on_source_win2
test[x_size:2*x_size-1,y_size:2*y_size-1]=sqrt(sqrt(win2))*max(on_source_win1)/max(sqrt(sqrt(win1)))
tvscl,test
device,/close
set_plot,'X'
spawn, 'gv '+file
endif 

    testOk= "string"
    read, '> Is the dataset satisfactory from display inspection? (y/n) ? ', testOK
    ;testOK='y'
    if (strupcase(testOK) eq "N") then begin
        print, '<!> OK try another file'
        goto, ende
    endif

window, 0, xsize=500, ysize=550
lev=20000
;win_big2(where(win_big2 gt lev)) = lev
;win_big2(where(win_big2 le 2000.)) = 2000.0
;win2(where(win2 gt lev)) = lev
;win2(where(win2 le 1500.)) = 1500.0

;fit2D= gauss2dfit(win_big2,b,/tilt)
fit2D= gauss2dfit(win2,b,/tilt)

print, 'Star gauss. B:', b[4], b[5]
print, 'FWHM x, y',  b[2]*sqrt(2*alog(2))*0.098, b[3]*sqrt(2*alog(2))*0.098,b[3]/b[2],b[6]*180/!pi
;print, 'Max image', max(deconv, status), ' Pos X = ', status mod x_size, ' Pos y = ', trunc(status/x_size)

center_win=[30, 30]
FOV_x1 = center_win[0]-3
FOV_x2 = center_win[0]+3
FOV_y1 = center_win[1]-15
FOV_y2 = center_win[1]+15
x_size=FOV_x2-FOV_x1+1
y_size=FOV_y2-FOV_y1+1
toto1=win1(FOV_x1:FOV_x2,FOV_y1:FOV_y2)
toto2=win2(FOV_x1:FOV_x2,FOV_y1:FOV_y2)

window, 0, xsize=500, ysize=640

toto1=toto1-mean(toto1)
toto2=toto2-mean(toto2)
tvscl,congrid(toto1, 140, 620), 0
tvscl,congrid(toto2, 140, 620), 2

print, total(toto1), total(toto2)

	ende:
end