
;-----------------------------------------------------------------------

pro devstandard,cieli,varst
dims=size(cieli)
if (dims(0) ne 3) then begin
 print,'Input must be a data cube!'
endif else begin
xdim=dims(1)
ydim=dims(2)
varst=fltarr(xdim,ydim)
for i=0,xdim-1 do begin
for j=0,ydim-1 do begin
varst(i,j)=stddev(cieli(i,j,*))
endfor
endfor
endelse
end
;-----------------------------------------------------------------------
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro intensity_scale,minval,maxval,array_out
nxscale = 10
nyscale = 100
array_out = fltarr(nxscale,nyscale)
for iy=0,nyscale-1 do begin
  intensity=minval+(maxval-minval)*iy/(nxscale-1)
for ix=0,nxscale-1 do begin
    array_out(ix,iy) = intensity^0.25 
endfor
endfor
return
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;---------------	MAIN PROG	--------------------------------
;-----------------------------------------------------------------------

pro deconv, fname, PSFname
; FOR INSTANCE deconv,'PSFsub3d74.fits','hd101104REDUCED/F3d74mosaicCLEAN.fits'
; or deconv,'etacarREDUCED/F3d74mosaicCLEAN.fits','hd101104REDUCED/F3d74mosaicCLEAN.fits'
; or deconv,'etacarREDUCED/F4d05mosaicCLEAN.fits','hd101104REDUCED/F4d05mosaicCLEAN.fits'
; or deconv,'etacarREDUCED/FKsmosaic.fits','etacarREDUCED/FKsmosaic.fits'


loadct,3
set_plot, 'X'

pixsize=0.0271 ;arcsec
ima=readfits(fname)
;ima=ima+30.
PSF=readfits(PSFname)
;PSF=PSF+30.
name =fname
namePSF = PSFname

n=SIZE(ima)
x_size1=n[1]
y_size1=n[2]
print, 'IMAGE', x_size1,y_size1
n=SIZE(PSF)
x_size2=n[1]
y_size2=n[2]
print, 'PSF  ', x_size2,y_size2

factor=0.25

win1=ima
win1_PSF=PSF
;seuil=50000
;win1(where(win1 ge seuil)) = seuil
;seuil=15000
;PSF(where(PSF ge 30000.)) = 30000.

;win_big1=rebin(win1,x_size1*factor,y_size1*factor)
;PSF_big1=rebin(win1_PSF,x_size2*factor,y_size2*factor)
win_big1=congrid(win1,x_size1*factor,y_size1*factor)
PSF_big1=congrid(win1_PSF,x_size2*factor,y_size2*factor)
window, 0, xsize=700, ysize=400
;win_big1(where(win_big1 le 0.)) = 0.0
;PSF_big1(where(PSF_big1 le 0.)) = 0.0
;win_big1(where(win_big1 ge 20000.)) = 20000.
;PSF_big1(where(PSF_big1 ge 20000.)) = 20000.
tvscl,sqrt(sqrt(win_big1)),0
tvscl,sqrt(sqrt(PSF_big1)),1
;tvscl,win_big1,0
;tvscl,PSF_big1,1

FOV_x1 = 250
FOV_x2 = x_size1-1
FOV_y1 = 0
FOV_y2 = y_size1-1

print,'-------------  FIRST FIND THE STAR ---------------'

fit2D_B= gauss2dfit(win1(FOV_x1:FOV_x2,FOV_y1:FOV_y2),b)
print,'----------------------------------------'
print, 'Star gauss. B:', b[4]+FOV_x1, b[5]+FOV_y1
print, 'FWHM x, y', 2*(sqrt(b[2]*2*alog(2))), 2*(sqrt(b[3]*2*alog(2)))
print, 'Max image', max(win1, status), ' Pos X = ', status mod x_size1, ' Pos y = ', trunc(status/x_size1)

;center_x=trunc(b[4])+FOV_x1
;center_y=trunc(b[5])+FOV_y1
scaley = (dindgen(FOV_y2-FOV_y1)-trunc(b[5]))*0.083	;Based on gaussian fit
;scalex = (dindgen(FOV_y2-FOV_y1)-trunc(b[4]))*0.083
;center_x_max=status mod x_size-FOV_x1
;center_y_max=trunc(status/x_size-FOV_y1)
;scaley = (dindgen(FOV_y2-FOV_y1)-center_y_max)*0.083	;Based on maximum
;scalex = (dindgen(FOV_y2-FOV_y1)-center_x_max)*0.083


    !p.multi=[0, 0, 2, 0, 0]
    window, 1, xsize=600, ysize=600
    plot, win1(trunc(b[4])+FOV_x1,FOV_y1:FOV_y2), title="x-position"
    oplot, fit2D_B(trunc(b[4]),*), linestyle=1
    plot, win1(FOV_x1:FOV_x2,trunc(b[5])+FOV_y1), title="y-position"
    oplot, fit2D_B(*,trunc(b[5])), linestyle=1
    !p.multi=[0, 0, 1, 0, 0]

    testOk= "string"
    ;read, '> Is the dataset satisfactory from display inspection? (y/n) ? ', testOK
    testOK='y'
    if (strupcase(testOK) eq "N") then begin
        print, '<!> OK try another file'
        goto, ende
    endif

size=140
FOV_x2 = trunc(b[4]+size+FOV_x1)
FOV_x1 = trunc(b[4]-size+FOV_x1)
FOV_y2 = trunc(b[5]+size+FOV_y1)
FOV_y1 = trunc(b[5]-size+FOV_y1)
print, FOV_x1,FOV_x2,FOV_y1,FOV_y2 
win1=win1(FOV_x1:FOV_x2,FOV_y1:FOV_y2)

print,'-------------  SECOND FIND THE PSF ---------------'
FOV_x1 = 300
FOV_x2 = x_size2-1
FOV_y1 = 300
FOV_y2 = y_size2-1

fit2D= gauss2dfit(win1_PSF(FOV_x1:FOV_x2,FOV_y1:FOV_y2),b)
print,'----------------------------------------'
print, 'Star gauss. B:', b[4]+FOV_x1, b[5]+FOV_y1
print, 'FWHM x, y',  2*(sqrt(b[2]*2*alog(2))), 2*(sqrt(b[3]*2*alog(2)))
print, 'Max image', max(win1_PSF)
    !p.multi=[0, 0, 2, 0, 0]
    window, 1, xsize=600, ysize=600
    plot, win1_PSF(trunc(b[4])+FOV_x1,FOV_y1:FOV_y2), title="x-position"
    oplot, fit2D(trunc(b[4]),*), linestyle=1
    plot, win1_PSF(FOV_x1:FOV_x2,trunc(b[5])+FOV_y1), title="y-position"
    oplot, fit2D(*,trunc(b[5])), linestyle=1
    !p.multi=[0, 0, 1, 0, 0]

    testOk= "string"
    ;read, '> Is the dataset satisfactory from display inspection? (y/n) ? ', testOK
    testOK='y'
    if (strupcase(testOK) eq "N") then begin
        print, '<!> OK try another file'
        goto, ende
    endif

center_PSF_x=trunc(b[4])+FOV_x1
center_PSF_y=trunc(b[5])+FOV_y1

r=size
print, center_PSF_x-r,center_PSF_x+r,center_PSF_y-r,center_PSF_y+r
work_PSF=win1_PSF(center_PSF_x-r:center_PSF_x+r,center_PSF_y-r:center_PSF_y+r)
work_PSF=work_PSF/total(work_PSF)

print, 'TOTAL BEFORE : ', total(win1)
print, 'MAX BEFORE : ',max(win1)

;------------------  TEST OF DECONVOLUTION
!p.multi=[0, 0, 1, 0, 0]
deb_test = 25
FOR TEST=deb_test, deb_test  DO BEGIN
deconv=win1
Niter=TEST
FOR i=0, Niter DO Max_Likelihood, win1, work_PSF, deconv, reconv1, UNDERFLOW_ZERO=3
;deconv(where(deconv le 0.)) = 0.0
print, total(deconv), max(deconv),i
ENDFOR
deconvtv=deconv
deconvtv(where(deconvtv lt 0.0))=0.0
tvscl, rebin(sqrt(sqrt(deconvtv)), 2*(2*size+1), 2*(2*size+1))
;window,0
;tvscl, rebin(sqrt(sqrt(deconv[120:200,120:200])), 162,162)

;writefits,'EtaCarFKsdeconv.fits',rebin(sqrt(sqrt(deconv)), 642, 642)
;writefits,'EtaCar3.74deconv2.fits',rebin(sqrt(sqrt(deconv)), 642, 642)

print,'-------------  Third FIND THE STAR IN DECONVOLVED IMAGE ---------'

fit2D= gauss2dfit(deconv,a,/tilt)
print, 'Star gauss. A:', a[4], a[5]
print, 'FWHM x, y',  a[2]*sqrt(2*alog(2))*pixsize, a[3]*sqrt(2*alog(2))*0.083,a[3]/a[2],a[6]*180/!pi
;print, 'Max image', max(deconv, status), ' Pos X = ', status mod x_size, ' Pos y = ', trunc(status/x_size)
print,'NO TILT'
fit2D= gauss2dfit(deconv,a)
print, 'Star gauss. A:', a[4], a[5]
print, 'FWHM x, y',  a[2]*sqrt(2*alog(2))*pixsize, a[3]*sqrt(2*alog(2))*0.083,a[3]/a[2],a[6]*180/!pi
print,'-------------'


testOk= "string"
    read, '> Is the dataset satisfactory from display inspection? (y/n) ? ', testOK
  ;  testOK='y'
    if (strupcase(testOK) eq "N") then begin
        print, '<!> OK try another file'
        goto, ende
    endif

;-------------------------------------------------
;---- PRINT OF THE IMAGE ---------------------------

size=60
FOV_x1 = trunc(a[4]-size)
FOV_x2 = trunc(a[4]+size)
FOV_y1 = trunc(a[5]-size)
FOV_y2 = trunc(a[5]+size)

x_size=FOV_x2-FOV_x1+1
y_size=FOV_y2-FOV_y1+1


new_deconv=deconv[FOV_x1:FOV_x2,FOV_y1:FOV_y2]
new_win1=win1[FOV_x1:FOV_x2,FOV_y1:FOV_y2]

;stop

new_deconv=sqrt(sqrt(new_deconv))
;new_deconv(where(new_deconv gt 18))=18.

;new_win1(where(new_win1 lt 1.2))=0.
new_win1=sqrt(sqrt(new_win1))
;new_win1(where(new_win1 lt 18))=18.

;new_deconv=alog10(new_deconv)
;new_deconv(where(new_deconv lt 1))=1.

impression, 'test_40', new_deconv,x_size,y_size, pixsize
impression, 'test_00', new_win1,x_size,y_size, pixsize

;stop
ende:
end