
pro devstandard,cieli,varst
dims=size(cieli)
if (dims(0) ne 3) then begin
 print,'Input must be a data cube!'
endif else begin
xdim=dims(1)
ydim=dims(2)
varst=fltarr(xdim,ydim)
for i=0,xdim-1 do begin
for j=0,ydim-1 do begin
varst(i,j)=stddev(cieli(i,j,*))
endfor
endfor
endelse
end
;-----------------------------------------------------------------------


;-----------------------------------------------------------------------
;-----------------------------------------------------------------------

;---------------	MAIN PROG
;--------------------------------

;/data1/chummel/MIA+EWS-1.3/spectrophot/imbox
;/data1/chummel/MIA+EWS-1.3/spectrophot/impression.pro


pro deconvMIDI, fname, PSFname, niter, align=align, edit=edit

if n_elements(align) eq 0 then align=0
if n_elements(edit) eq 0 then edit=0

loadct,3
set_plot, 'X'

pixelscale=0.098

; files=midiguis(dir=mididata0616)
ima=oirgetdata(fname)
PSF=oirgetdata(PSFname)
name = make_shortname(fname)
namePSF = make_shortname(PSFname)

	image_win1=FLOAT(ima.data1)+32768.

	image_win2=FLOAT(ima.data2)+32768.


cleanname= (oirFileList(fname))[0]

im=obj_new('fitsfile',cleanname)

he = im->prihead()

;OBJECT        = STRCOMPRESS(he->getpar('OBJECT'),/remove_all)

OBJECT        = STRCOMPRESS(he->getpar('OBS TARG NAME'),/remove_all)
obj_destroy,im

shortname=OBJECT+name+'_'+namePSF
print, shortname

factor=4

n=SIZE(ima.data1)

x_size=n[1]

y_size=n[2]

NDIT_ima  =n[3]

print, 'IMAGE', x_size,y_size
n=SIZE(PSF.data1)

x_size=n[1]
y_size=n[2]
NDIT  =n[3]

print, 'PSF  ', x_size,y_size
print,'NDIT IMAGE',ndit_ima
print, 'NDIT PSF  ',ndit
chopping = ima.TARTYP1
		  
  n1 = 0 ;frames removed at the beginning
  n2 = 0 ;frames removed at the end
if keyword_set(align) or keyword_set(edit) then begin
	win1=midiacqimage(fname,1,align=align,edit=edit)
	win2=midiacqimage(fname,2,align=align,edit=edit)
	win1_PSF=midiacqimage(PSFname,1,align=align,edit=edit)
	win2_PSF=midiacqimage(PSFname,2,align=align,edit=edit)
endif else begin  
		        chop_image= MIDIChopImageC(fname, before=n1, after=n2)
		        if keyword_set(reverse) then begin
		            on_source_win1 = chop_image[1].data1
		            on_source_win2 = chop_image[1].data2
		            off_source_win1= chop_image[0].data1
		            off_source_win2= chop_image[0].data2
		        endif else begin
		            on_source_win1 = chop_image[0].data1
		            on_source_win2 = chop_image[0].data2
		            off_source_win1= chop_image[1].data1
		            off_source_win2= chop_image[1].data2
		        endelse
		        
				win1 = on_source_win1-off_source_win1
		        win2 = on_source_win2-off_source_win2

		        chop_image= MIDIChopImageC(PSFname, before=n1, after=n2)
		        if keyword_set(reverse) then begin
		            on_source_win1_PSF = chop_image[1].data1
		            on_source_win2_PSF = chop_image[1].data2
		            off_source_win1_PSF= chop_image[0].data1
		            off_source_win2_PSF = chop_image[0].data2
		        endif else begin
		            on_source_win1_PSF = chop_image[0].data1
		            on_source_win2_PSF = chop_image[0].data2
		            off_source_win1_PSF= chop_image[1].data1
		            off_source_win2_PSF= chop_image[1].data2
		        endelse
		        win1_PSF = on_source_win1_PSF-off_source_win1_PSF
		        win2_PSF = on_source_win2_PSF-off_source_win2_PSF
endelse	    

;win1=win1+10.
;win2=win2+10.
;win1_PSF =win1_PSF+40
;win2_PSF=win2_PSF+40
win_big1=rebin(win1,x_size*factor,y_size*factor)
win_big2=rebin(win2,x_size*factor,y_size*factor)
PSF_big1=rebin(win1_PSF,x_size*factor,y_size*factor)
PSF_big2=rebin(win2_PSF,x_size*factor,y_size*factor)
window, 0, xsize=500, ysize=550
if min(win_big1) le 0.0 then win_big1(where(win_big1 le 0.)) = 0.01
if min(win_big2) le 0.0 then win_big2(where(win_big2 le 0.)) = 0.01
if min(PSF_big1) le 0.0 then PSF_big1(where(PSF_big1 le 0.)) = 0.01
if min(PSF_big2) le 0.0 then PSF_big2(where(PSF_big2 le 0.)) = 0.01
tvscl,sqrt(sqrt(win_big1)),0
tvscl,sqrt(sqrt(win_big2)),1
tvscl,sqrt(sqrt(PSF_big1)),2
tvscl,sqrt(sqrt(PSF_big2)),3
    testOk= "string"
    read, '> Is the dataset satisfactory from display inspection? (y/n) ? ', testOK
    ;testOK='y'
    if (strupcase(testOK) eq "N") then begin
        print, '<!> OK try another file'
        goto, ende
    endif

;win1(where(win1 le 0.01)) = 0.01
;win2(where(win2 le 0.01)) = 0.01
;win1_PSF(where(win1_PSF le 0.0)) = 0.0
;win2_PSF(where(win2_PSF le 0.0)) = 0.0
;test=fltarr(2.*x_size,2*y_size)
;test[0:x_size-1,0:y_size-1]=sqrt(sqrt(win1))/max(sqrt(sqrt(win1)))
;test[0:x_size-1,y_size:2*y_size-1]=sqrt(sqrt(win1_PSF))/max(sqrt(sqrt(win1_PSF)))
;test[x_size:2*x_size-1,0:y_size-1]=sqrt(sqrt(win2))/max(sqrt(sqrt(win2)))
;test[x_size:2*x_size-1,y_size:2*y_size-1]=sqrt(sqrt(win2_PSF))/max(sqrt(sqrt(win2_PSF)))


  FOV_x1 = 0
  FOV_x2 = x_size-1
  FOV_y1 = 0
  FOV_y2 = y_size-1

print,'-------------  FIRST FIND THE STAR ---------------'

fit2D_B= gauss2dfit(win1(FOV_x1:FOV_x2,FOV_y1:FOV_y2),b)
print,'----------------------------------------'
print, 'Star gauss. B:', b[4]+FOV_x1, b[5]+FOV_y1
print, 'FWHM x, y',  b[2], b[3]
print, 'Max image', max(win1, status), ' Pos X = ', status mod x_size, ' Pos y = ', trunc(status/x_size)

;center_x=trunc(b[4])+FOV_x1
;center_y=trunc(b[5])+FOV_y1
scaley = (dindgen(FOV_y2-FOV_y1)-trunc(b[5]))*0.098	;Based on gaussian fit
;scalex = (dindgen(FOV_y2-FOV_y1)-trunc(b[4]))*0.083
;center_x_max=status mod x_size-FOV_x1
;center_y_max=trunc(status/x_size-FOV_y1)
;scaley = (dindgen(FOV_y2-FOV_y1)-center_y_max)*0.083	;Based on maximum
;scalex = (dindgen(FOV_y2-FOV_y1)-center_x_max)*0.083

fit2D_A= gauss2dfit(win2(FOV_x1:FOV_x2,FOV_y1:FOV_y2),a)
print,'----------------------------------------'
print, 'Star gauss. A:', a[4]+FOV_x1, a[5]+FOV_y1
print, 'FWHM x, y',  a[2], a[3]
print, 'Max image', max(win2, status), ' Pos X = ', status mod x_size, ' Pos y = ', trunc(status/x_size)
print,'----------------------------------------'

;center_x2=trunc(b[4])+FOV_x1
;center_y2=trunc(b[5])+FOV_y1

    !p.multi=[0, 0, 4, 0, 0]
    window, 1, xsize=600, ysize=600
    plot, win2(trunc(a[4])+FOV_x1,FOV_y1:FOV_y2), title="Beam A, x-position"
    oplot, fit2D_A(trunc(a[4]),*), linestyle=1
    plot, win2(FOV_x1:FOV_x2,trunc(a[5])+FOV_y1), title="Beam A, y-position"
    oplot, fit2D_A(*,trunc(a[5])), linestyle=1
    plot, win1(trunc(b[4])+FOV_x1,FOV_y1:FOV_y2), title="Beam B, x-position"
    oplot, fit2D_B(trunc(b[4]),*), linestyle=1
    plot, win1(FOV_x1:FOV_x2,trunc(b[5])+FOV_y1), title="Beam B, y-position"
    oplot, fit2D_B(*,trunc(b[5])), linestyle=1
    !p.multi=[0, 0, 1, 0, 0]

    testOk= "string"
    ;read, '> Is the dataset satisfactory from display inspection? (y/n) ? ', testOK
    testOK='y'
    if (strupcase(testOK) eq "N") then begin
        print, '<!> OK try another file'
        goto, ende
    endif


print,'-------------  SECOND FIND THE PSF ---------------'

fit2D= gauss2dfit(win1_PSF(FOV_x1:FOV_x2,FOV_y1:FOV_y2),b)

print,'----------------------------------------'
print, 'Star gauss. B:', b[4]+FOV_x1, b[5]+FOV_y1
print, 'FWHM x, y',  b[2], b[3]
print, 'Max image', max(win1_PSF)

center_PSF_x=trunc(b[4])+FOV_x1
center_PSF_y=trunc(b[5])+FOV_y1

fit2D= gauss2dfit(win2_PSF(FOV_x1:FOV_x2,FOV_y1:FOV_y2),b)

print,'----------------------------------------'
print, 'Star gauss. B:', b[4]+FOV_x1, b[5]+FOV_y1
print, 'FWHM x, y',  b[2], b[3]
print, 'Max image', max(win2_PSF)

center_PSF2_x=trunc(b[4])+FOV_x1
center_PSF2_y=trunc(b[5])+FOV_y1

r=12
work_PSF=win1_PSF(center_PSF_x-r:center_PSF_x+r,center_PSF_y-r:center_PSF_y+r)
work_PSF=work_PSF/total(work_PSF)
work_PSF2=win2_PSF(center_PSF2_x-r:center_PSF2_x+r,center_PSF2_y-r:center_PSF2_y+r)
work_PSF2=work_PSF2/total(work_PSF2)

wait,10
;------------------  TEST OF DECONVOLUTION
!p.multi=[0, 0, 1, 0, 0]
deb_test = niter
FOR TEST=deb_test,deb_test DO BEGIN
deconv=win1
deconv2=win2
Niter=TEST
FOR i=0, Niter DO Max_Likelihood, win1, work_PSF, deconv, reconv1, UNDERFLOW_ZERO=6
FOR i=0, Niter DO Max_Likelihood, win2, work_PSF2, deconv2, reconv2, UNDERFLOW_ZERO=6

fit2D= gauss2dfit(deconv(FOV_x1:FOV_x2,FOV_y1:FOV_y2),p)

print,'ITERATIONS :',Niter
print, 'Star gauss. B:', p[4]+FOV_x1, p[5]+FOV_y1
;print, 'FWHM x, y',  p[2], p[3]
;print, 'Max image', max(deconv)

center_x=trunc(p[4])+FOV_x1
center_y=trunc(p[5])+FOV_y1

residual1= win1-reconv1
residual2= win2-reconv2

IF (TEST EQ deb_test) then BEGIN 
plot, scaley, deconv(trunc(p[4])+FOV_x1,FOV_y1:FOV_y2), xtitle='Y in mas',$
yrange=[0, 2.*max(deconv(trunc(p[4])+FOV_x1,FOV_y1:FOV_y2))], ytitle='ADUs'
oplot, scaley, win1(center_x,FOV_y1:FOV_y2)
ENDIF
IF (TEST GT deb_test) then BEGIN
oplot, scaley, deconv(trunc(p[4])+FOV_x1,FOV_y1:FOV_y2)
ENDIF
ENDFOR

print,'-------------  Third FIND THE STAR IN DECONVOLVED IMAGE ---------'
print, shortname      

fit2D= gauss2dfit(deconv(FOV_x1:FOV_x2,FOV_y1:FOV_y2),a,/tilt)
print, 'Star gauss. A:', a[4]+FOV_x1, a[5]+FOV_y1
print, 'FWHM x, y',  a[2]*sqrt(2*alog(2))*pixelscale, a[3]*sqrt(2*alog(2))*pixelscale,a[3]/a[2],a[6]*180/!pi
;print, 'Max image', max(deconv, status), ' Pos X = ', status mod x_size, ' Pos y = ', trunc(status/x_size)
;print,'NO TILT'
;fit2D= gauss2dfit(deconv(FOV_x1:FOV_x2,FOV_y1:FOV_y2),a)
;print, 'Star gauss. A:', a[4]+FOV_x1, a[5]+FOV_y1
;print, 'FWHM x, y',  a[2]*sqrt(2*alog(2))*pixelscale, a[3]*sqrt(2*alog(2))*pixelscale,a[3]/a[2],a[6]*180/!pi
print,'-------------'
fit2D= gauss2dfit(deconv2(FOV_x1:FOV_x2,FOV_y1:FOV_y2),b,/tilt)
print, 'Star gauss. B:', b[4]+FOV_x1, b[5]+FOV_y1
print, 'FWHM x, y',  b[2]*sqrt(2*alog(2))*pixelscale, b[3]*sqrt(2*alog(2))*pixelscale,b[3]/b[2],b[6]*180/!pi
;print, 'Max image', max(deconv, status), ' Pos X = ', status mod x_size, ' Pos y = ', trunc(status/x_size)
;print,'NO TILT'
;fit2D= gauss2dfit(deconv2(FOV_x1:FOV_x2,FOV_y1:FOV_y2),b)
;print, 'Star gauss. B:', b[4]+FOV_x1, b[5]+FOV_y1
;print, 'FWHM x, y',  b[2]*sqrt(2*alog(2))*pixelscale, b[3]*sqrt(2*alog(2))*pixelscale,b[3]/b[2],b[6]*180/!pi
deconv_big=rebin(deconv,x_size*factor,y_size*factor)-min(deconv)

deconv_big2=rebin(deconv2,x_size*factor,y_size*factor)-min(deconv2)

window, 0, xsize=500, ysize=500
tvscl,sqrt(sqrt(deconv_big)),0
tvscl,deconv_big,1
tvscl,sqrt(sqrt(deconv_big2)),2
tvscl,deconv_big2,3

;goto, ende    


deconv=37*deconv/19600.	;37 Jy for a zer0 flux of 19600 counts
deconv2=37*deconv2/19600
print,total(deconv),'Jy'
print,total(deconv2),'Jy'

testOk= "string"
   read, '> Is the dataset satisfactory from display inspection? (y/n) ? ', testOK
;     testOK='y'
    if (strupcase(testOK) eq "N") then begin
        print, '<!> OK try another file'
        goto, ende
    endif


;-------- Comparison with undeconvolved image --------------
;win1(where(win1 lt 0.0)) =0.
;-------------------------------------------------
;---- DEFINITION OF MIDI FOV ---------------------------
midifieldangle,fname,para,phin,phie,rotSky
print,''
print,'-------------  ORIENTATION OF THE FIELD ---------------'
print,''
print,''
print,'North counted clockwise with respect to >>down<< (-V), East = North - 90 deg:'
print,''
print,'Phi North: ',phin
print,'Phi East: ',phie
phin = 180-phin
phie = 180-phie
print,''

if min(deconv) lt 0.0 then deconv(where(deconv lt 0.)) = 0
if min(deconv2) lt 0.0 then deconv2(where(deconv2 lt 0.)) = 0

; FIELD ROTATION
deconv=rot(deconv,phin,/interp)
deconv2=rot(deconv2,phin,/interp)

s=8
sbin=2.*s+1
FOV_x1 = trunc(a[4]-s)
FOV_x2 = trunc(a[4]+s)
FOV_y1 = trunc(a[5]-s)
FOV_y2 = trunc(a[5]+s)

x_size=FOV_x2-FOV_x1+1
y_size=FOV_y2-FOV_y1+1

new_diff_win1 = sqrt(deconv(FOV_x1:FOV_x2,FOV_y1:FOV_y2))
;new_diff_win1 =new_diff_win1(FOV_x1:FOV_x2,FOV_y1:FOV_y2)

binfactor=2
new_diff_win1 = rebin(new_diff_win1,binfactor*sbin,binfactor*sbin)
new_diff_win1(where(new_diff_win1^2 le 0.01*max(deconv))) = 0.0

s_imp=binfactor*sbin

impression,shortname+'_A',new_diff_win1,s_imp,s_imp,pixelscale/binfactor

FOV_x1 = trunc(b[4]-s)
FOV_x2 = trunc(b[4]+s)
FOV_y1 = trunc(b[5]-s)
FOV_y2 = trunc(b[5]+s)
x_size=FOV_x2-FOV_x1+1
y_size=FOV_y2-FOV_y1+1

new_diff_win2 = sqrt(deconv2(FOV_x1:FOV_x2,FOV_y1:FOV_y2))
new_diff_win2 = rebin(new_diff_win2,binfactor*sbin,binfactor*sbin)

new_diff_win2(where(new_diff_win2^2 le 0.01*max(deconv2))) = 0.0
impression,shortname+'_B',new_diff_win2,s_imp,s_imp, pixelscale/binfactor

print, shortname
;stop
ende:
end
