function imbox,image, $
		xrange=xrange,yrange=yrange, $ ; axis range for box $
		title=title,                 $ ; title over box $
		xtitle=xtitle,ytitle=ytitle, $ ; axis titles $
		charsize=charsize,           $ ; character magnification $
		xsize=xsize,ysize=ysize,     $ ; plot size $
		position=position,           $ ; lower left corner position $
		ticks=ticks,tickn=tickn,     $ ; tick labels $
		xlabel=xlabel,ylabel=ylabel, $ ; =-1 no labels, $
					     $ ; =1 labels left/down $
					     $ ; =2 labels right/up  $
                interp=interp,               $ ; to use with poly_2d $
		log=log,                     $ ; use logarithmic axis scaling $
		xlbclip=xlbc,ylbclip=ylbc,   $ ; clipping labels $
		dpi=dpi,                     $ ; set DPI for PS device $
		noborder=noborder,           $ ; to match box exactly on image $
                noscale=noscale                ; use tv instead of tvscl


;on_error,2                      ;Return to caller if an error occurs
if not keyword_set(dpi) then dpi=72
if not keyword_set(interp) then interp=0
if not keyword_set(charsize) then charsize=0.6
if not keyword_set(noborder) then noborder=1
if not keyword_set(xlabel) then xlabel=1
if not keyword_set(ylabel) then ylabel=1
if (keyword_set(xsize)) then begin
  xs1=xsize*0.95
  xs2=xsize
endif else begin
  xs1=0.8*0.95
  xs2=0.8
endelse
if (keyword_set(ysize)) then begin
  ys1=ysize*0.95
  ys2=ysize
endif else begin
  ys1=0.8*0.95
  ys2=0.8
endelse
if (keyword_set(position)) then begin
  x1=position(0)+0.025*xs1
  x2=position(0)
  y1=position(1)+0.025*ys1
  y2=position(1)
endif else begin
  x1=0.1+0.025*xs1
  x2=0.1
  y1=0.1+0.025*ys1
  y2=0.1
endelse
if keyword_set(noborder) then begin
  xs1=xs2
  ys1=ys2
  x1=x2
  y1=y2
endif
s=size(image)
if (keyword_set(xrange) ne 1) then begin
  xrange=[0,s(1)-1]
endif
if (keyword_set(yrange) ne 1) then begin
  yrange=[0,s(2)-1]
endif

if (!d.flags and 1) eq 0 then begin	;Scalable pixels?
  xsn=xs1*!d.x_size
  ysn=ys1*!d.y_size
  im=poly_2d(image,[[0,0],[s(1)/xsn,0]], [[0,s(2)/ysn],[0,0]],interp,xsn,ysn)
endif else begin
  dsx=!d.x_size/2540.
  dsy=!d.y_size/2540.
  xdpi=(size(image))(1)/xsize/dsx
  ydpi=(size(image))(2)/ysize/dsy
  if xdpi gt dpi or ydpi gt dpi then begin
    if xdpi gt dpi then rxsi=xsize*dsx*dpi else rxsi=(size(image))(1)
    if ydpi gt dpi then rysi=ysize*dsy*dpi else rysi=(size(image))(2)
    print, 'ATTENTION: resolution in image too high!'
    print, '           resizing from '+strtrim(xdpi,2)+'x'+strtrim(ydpi,2)+ $
	   ' to '+strtrim(dpi,2)+'x'+strtrim(dpi,2)+' (' + $
	   strtrim((size(image))(1),2)+'x'+strtrim((size(image))(2),2)+' to '+ $
	   strtrim(fix(rxsi),2)+'x'+strtrim(fix(rysi),2)+' pixels)'
    im=congrid(image,rxsi,rysi)
  endif else im=image
endelse

if not keyword_set(noscale) then tvscl,im,x1,y1,xsize=xs1,ysize=ys1,/normal $
			    else tv,im,$
				    x1,y1,xsize=xs1,ysize=ys1,/normal

xty=0 & yty=0
if keyword_set(log) then begin
  xty=1
  yty=1
endif
if keyword_set(title) then xyouts,x2+xs2/2,y2+(1.+0.05*charsize)*ys2,title,charsize=1.5*charsize,/normal,alignment=0.5
plots,[x2,x2],[y2,y2+ys2],/normal,thick=!y.thick
plots,[x2,x2+xs2],[y2+ys2,y2+ys2],/normal,thick=!x.thick
plots,[x2+xs2,x2+xs2],[y2+ys2,y2],/normal,thick=!y.thick
plots,[x2+xs2,x2],[y2,y2],/normal,thick=!x.thick
plot,xrange,yrange,xsty=5,ysty=5,xtick_get=xtks,ytick_get=ytks,/nodata,/noerase,xty=xty,yty=yty,position=[x1,y1,x1+xs1,y1+ys1],/normal


xtn1=replicate(' ',30)
xtn2=replicate(' ',30)
ytn1=replicate(' ',30)
ytn2=replicate(' ',30)
xt1=0 & xt2=0 & yt1=0 & yt2=0
xtit1='' & xtit2='' & ytit1='' & ytit2=''
xtv1=fltarr(30)
xtv2=fltarr(30)
ytv1=fltarr(30)
ytv2=fltarr(30)

if keyword_set(ticks) then begin
  xt1=n_elements(ticks.x1)-1
  xtv1(0:xt1)=(ticks.x1)(0:xt1)
  tmp=n_elements(ticks.xn1)-1
  xtn1(0:tmp)=ticks.xn1
  xtit1=ticks.xt1
  xt2=n_elements(ticks.x2)-1
  xtv2(0:xt2)=(ticks.x2)(0:xt2)
  tmp=n_elements(ticks.xn2)-1
  xtn2(0:tmp)=ticks.xn2
  xtit2=ticks.xt2

  yt1=n_elements(ticks.y1)-1
  ytv1(0:yt1)=(ticks.y1)(0:yt1)
  tmp=n_elements(ticks.yn1)-1
  ytn1(0:tmp)=ticks.yn1
  ytit1=ticks.yt1
  yt2=n_elements(ticks.y2)-1
  ytv2(0:yt2)=(ticks.y2)(0:yt2)
  tmp=n_elements(ticks.yn2)-1
  ytn2(0:tmp)=ticks.yn2
  ytit2=ticks.yt2
endif else begin
  if (1 and xlabel) and xlabel ne -1 then begin
    xt1=n_elements(xtks)-1
    xtv1(0:xt1)=xtks
    xtn1(0:xt1)=''
    if keyword_set(xtitle) then xtit1=xtitle
  endif
  if (2 and xlabel) eq 2 and xlabel ne -1 then begin
    xt2=n_elements(xtks)-1
    xtv2(0:xt2)=xtks
    xtn2(0:xt2)=''
    if keyword_set(xtitle) then xtit2=xtitle
  endif
  if (1 and ylabel) and ylabel ne -1 then begin
    yt1=n_elements(ytks)-1
    ytv1(0:yt1)=ytks
    ytn1(0:yt1)=''
    if keyword_set(ytitle) then ytit1=ytitle
  endif
  if (2 and ylabel)  eq 2 and ylabel ne -1 then begin
    yt2=n_elements(ytks)-1
    ytv2(0:yt2)=ytks
    ytn2(0:yt2)=''
    if keyword_set(ytitle) then ytit2=ytitle
  endif
  xt1=0 & xt2=0 & yt1=0 & yt2=0
endelse

if keyword_set(xlbc) then begin
  tmp=convert_coord(xtv1,ytv1,/data,/to_normal)
  ind=where(tmp(0,*) lt xlbc(0) or tmp(0,*) gt xlbc(1))
  if ind(0) ne -1 then xtn1(ind)=' '
  tmp=convert_coord(xtv2,ytv2,/data,/to_normal)
  ind=where(tmp(0,*) lt xlbc(0) or tmp(0,*) gt xlbc(1))
  if ind(0) ne -1 then xtn2(ind)=' '
endif
if keyword_set(ylbc) then begin
  tmp=reform((convert_coord(xtv1,ytv1,/data,/to_normal))(1,*))
  ind=where(tmp lt ylbc(0) or tmp gt ylbc(1))
  if ind(0) ne -1 then ytn1(ind)=' '
  tmp=reform((convert_coord(xtv2,ytv2,/data,/to_normal))(1,*))
  ind=where(tmp lt ylbc(0) or tmp gt ylbc(1))
  if ind(0) ne -1 then ytn2(ind)=' '
endif

!x.window=[x1,x1+xs1]
!y.window=[y1,y1+ys1]

axis,x2,y2,xaxis=0,/normal,xra=xrange,xsty=1,xticklen=0.04*xs2, $
     xtickname=replicate(' ',30),xty=xty
axis,x2,y2+ys2,xaxis=1,/normal,xra=xrange,xsty=1,xticklen=0.04*xs2  $
     ,xtickname=replicate(' ',30),xty=xty
axis,x2,yaxis=0,/normal,yra=yrange,ysty=1,ytickle=0.04*ys2,   $
     ytickname=replicate(' ',30),yty=yty
axis,x2+xs2,yaxis=1,/normal,yra=yrange,ysty=1,ytickle=0.04*ys2, $
     ytickname=replicate(' ',30),yty=yty
axis,x2,y2,xaxis=0,/normal,charsize=charsize,xra=xrange,xsty=1, $
     xticklen=0.04*xs2,xtickv=xtv1,xtickname=xtn1,xticks=xt1,       $
     xtitle=xtit1,xty=xty
axis,x2,y2+ys2,xaxis=1,/normal,charsize=charsize,xra=xrange,xsty=1, $
     xticklen=0.04*xs2,xtickv=xtv2,xtickname=xtn2,xticks=xt2,       $
     xtitle=xtit2,xty=xty
axis,x2,yaxis=0,/normal,charsize=charsize,yra=yrange,ysty=1,        $
     ytickle=0.04*ys2,ytickv=ytv1,ytickname=ytn1,yticks=yt1,        $
     ytitle=ytit1,yty=yty
axis,x2+xs2,yaxis=1,/normal,charsize=charsize,yra=yrange,ysty=1,    $
     ytickle=0.04*ys2,ytickv=ytv2,ytickname=ytn2,yticks=yt2,        $
     ytitle=ytit2,yty=yty

return,[x1,y1,x1+xs1,y1+ys1]
end
