;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro intensity_scale,minval,maxval,array_out
nxscale = 10
nyscale = 100
array_out = fltarr(nxscale,nyscale)
for iy=0,nyscale-1 do begin
  intensity=minval+(maxval-minval)*iy/(nxscale-1)
for ix=0,nxscale-1 do begin
    array_out(ix,iy) = intensity^0.25 
endfor
endfor
return
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;-----------------------------------------------------------------------

pro Impression,file, array,x_size,y_size, pix, PHOT=phot

if not file_test("PS") then spawn,'mkdir "PS"'

	set_plot,'ps'

	loadct,3
	fichier='PS/'+file+'.ps'

	device, filename=fichier,/color, bits_per_pixel=16, xsize=15.0, ysize=15.0
!p.charsize = 1.0

!p.multi=[0,1,0,0]

abscX = dindgen(x_size)*pix-(x_size*pix)/2.
abscY = dindgen(y_size)*pix-(x_size*pix)/2.
if keyword_set(phot) then begin
        position = [0.1,0.1,0.8,0.8]
endif else begin
		position = [0.1,0.1,0.9,0.9]
endelse 
        s = Size(array, /Dimensions)
        imgXsize = s[0]
        imgYsize = s[1]
        xsize = (position(2) - position(0)) * !D.X_Vsize
        ysize = (position(3) - position(1)) * !D.Y_Vsize
        xstart = position(0) * !D.X_Vsize
        ystart = position(1) * !D.Y_Vsize

max_i_map = max(array)
;max_i_map =7.6
min_i_map = min(array)

print, min_i_map, max_i_map
max_i_mapscale = max_i_map
;^4/pix^2

intensity_scale,0,max_i_map,scale_i_map ;inversion of scale!!!

old_array = array

;old_array(where(old_array lt 0.00)) = 0.00
noise = 0.3
;array(where(array lt noise)) = noise

array = 1 -array / max(array)
;print,imbox(array,yrange=[0,max(abscY)],xrange=[0,max(abscX)], $
;xtitle='Arcsec',ytitle='Arcsec',xsize=.7, $
;ysize=.7,position=[.1,.1])

if keyword_set(phot) then begin

;print,imbox(max(scale_i_map^4/pix^2)-scale_i_map^4/pix^2), yrange=[min_i_map,max_i_map^4/pix^2], $
;print,imbox(scale_i_map^4/pix^2, yrange=[min_i_map,max_i_map^4/pix^2], $
;ytitle='In Jy/arcsec!A2!N!3', $
;xsize=.02,ysize=.7,position=[.8,.1],xlabel=-1,ylabel=2)
;position = [0.1,0.1,0.8,0.8]

endif  
;else begin
;position = [0.1,0.1,0.9,0.9]

;endelse ; KEYWORD PHOT

;threshold = 0.1   
;threshold = 0.1         ;less than 1e-4
threshold = 0.25
;threshold = 0.3165	;1%
;threshold = 0.3975	;2.5%
;-------------------   Color Contours -----------------------------
;number of contours
numb=12
;print,imbox(scale_i_map, yrange=[min_i_map,max_i_map^4], $
;ytitle='I/I!B0!N!3', $
;xsize=.02,ysize=.7,position=[.8,.1],xlabel=-1,ylabel=2)
lev=(threshold+(1-threshold)*dindgen(numb)/numb)*max_i_map
lev=[0,lev]
;
;contour, old_array, abscX, abscY, levels=lev, $
;	     /FILL,   ytitle='Arcsec', xtitle='Arcsec' , /noerase, position=position

;-------------------   IMAGE, not filled Contours -----------------------------
;tvscl,rebin(old_array,2.*x_size,2.*y_size), xstart,ystart,$
;       xsize=xsize, ysize=ysize 
contour, 0.0*old_array, abscX, abscY, levels=lev, $
	        ytitle='Arcsec', xtitle='Arcsec' , /noerase, position=position


;-------------------   Grey, not filled Contours -----------------------------
;numb=10
;lev=(threshold+(1-threshold)*dindgen(numb)/numb)*max_i_map
;lev=[0,lev]
contour, old_array, abscX, abscY, levels=lev, $
	         ytitle='Arcsec', xtitle='Arcsec' , /noerase, position=position

device, /close

toto = 'ggv '+ fichier
;set_plot, 'X'
;spawn,toto
;stop
end
