;--------------------------------------------------------------------------
; derive radial intensity profile
;                                  ........................................
;                                  [Sebastian Wolf, wolf@tls-tautenburg.de]
; -------------------------------------------------------------------------
pro radprof, ima, prof

sz_ima = size(ima)
if ( (sz_ima(0) ne 2) or (sz_ima(1) ne sz_ima(2)) ) then begin
    print, '<error: pro radprof> input file has to be a square, 2D image'
    stop
endif

radius  = float(sz_ima(1)) / 2.0
center  = radius
dphi    = atan(1.0/radius)        ; step width in phi direction
nphi    = 2.0*!PI/dphi
nrad    = real2int(float(sz_ima(1))/2.0)
prof    = dblarr(nrad)
nprof   = dblarr(nrad)
stepr   = 10.0

nprof(*) = 0.0
prof( *) = 0.0
for ip=0, real2int(nphi) do begin
    for ir=0, real2int(radius*stepr) do begin
        x = real2int( ((float(ir)/stepr) * cos(ip*dphi)) + center )
        y = real2int( ((float(ir)/stepr) * sin(ip*dphi)) + center )
        r = real2int(  float(ir)/float(stepr) )
        if ((x ge 0) and (y ge 0) and (x lt sz_ima(1)) and (y lt sz_ima(1))) then begin
            if (r lt nrad) then begin
                prof( r) =  prof(r) + ima(x,y)
                nprof(r) = nprof(r) + 1.0
            endif
        endif
    endfor
endfor

for ir=0, nrad-1 do begin
    if (nprof(ir) gt 0.0) then begin
        prof(ir) = prof(ir) / nprof(ir)
    endif else begin
        prof(ir) = 0.0
    endelse
endfor

end
