;+   Header to be read with doc_library 
;
;; 2002/03/06, Peter Schuller 
;
; FUNCTION Readarr: reads an ASCII table into float array;
;                   checks for EOF and changes of # of columns
; 
; INPUT required: filename - string; file to be processed
;       keywords: * start_col - integer
;                 * numb_col - integer
;                 * start_row - integer
;                 * numb_row - integer
;                 * info - set to get short message on syntax
;
; OUTPUT created: float array
;
; SYNTAX: result = Readarr(string, /info [,var_keywords])
;
;-

FUNCTION Readarr, filename, $
		start_col_kn=start_col,numb_col_kn=numb_col,$
		start_row_kn=start_row,numb_row_kn=numb_row, $
                info_kn=info

; ---------- Initializations ----------
;
helpstrg=''
nan=!values.f_nan

s_col=0UL  &  n_col=1UL
;
s_row=0UL  &  n_row=1UL
;
outarr=fltarr(n_col,n_row)  &  outarr[*]=nan


; ========== Routine ========== 
;

IF keyword_set(info) THEN BEGIN
   print, 'SYNTAX: result = Readtbl(string, /info [,var_keywords])'
   GOTO, ending
  ENDIF

get_lun, tbl_lun   ; assign LUN automatically 
openr, tbl_lun, filename, error=err 
IF (err ne 0) THEN BEGIN 
   print, 'Error while opening file "',filename,'"!'
   GOTO, releasefile  
  ENDIF 

counter=0UL
WHILE (NOT eof(tbl_lun)) DO BEGIN
   readf,tbl_lun,helpstrg
   counter=counter+1
  ENDWHILE
rows=counter
IF (n_elements(start_row) ne 0) THEN $
   s_row=(0 > fix(start_row)) < (rows-1)
IF (n_elements(numb_row) ne 0) THEN $
   n_row=(1 > fix(numb_row)) < (rows-s_row) $
  ELSE n_row=(rows-s_row)

; ** take first helpstrg of area to read as pattern for columns
point_lun, tbl_lun, 0   ; go back to start of file
counter=0UL
WHILE (counter lt s_row) AND (NOT eof(tbl_lun)) DO BEGIN
   readf,tbl_lun,helpstrg
   counter=counter+1
  ENDWHILE
;
point_lun, -tbl_lun, s_row_byte   ; get start byte position of reading
readf,tbl_lun,helpstrg
hlparr=strsplit(helpstrg,/extract)
   ; defaults to splitting on _spans_ of whitespace! 
;hlparr=str_sep(strcompress(strtrim(helpstrg,2)),' ')
   ; for older IDL versions (<5.4) 
cols=n_elements(hlparr)   ; this defines the pattern!

; ** read only piecewise uniform array
point_lun, tbl_lun, s_row_byte   ; go back to start of reading
counter=0UL
n_col = cols
WHILE ((counter lt n_row) AND (n_col eq cols)) DO BEGIN
   readf,tbl_lun,helpstrg
   counter=counter+1
   n_col = n_elements(strsplit(helpstrg,/extract))
;   n_col = n_elements(str_sep(strcompress(strtrim(helpstrg,2)),' ',/trim))
      ; for older IDL versions (<5.4) 
  ENDWHILE
IF (n_col eq cols) THEN $
   n_row = (counter < n_row) $
  ELSE $   ; if # of row elements changed
   n_row = ((counter-1) < n_row)

outarr=fltarr(cols,n_row)
;
point_lun, tbl_lun, s_row_byte
readf,tbl_lun,outarr

releasefile:
free_lun, tbl_lun   ; also closes file automatically 

IF (n_elements(start_col) ne 0) THEN $
   s_col=(0 > fix(start_col)) < (cols-1)
IF (n_elements(numb_col) ne 0) THEN $
   n_col=(1 > fix(numb_col)) < (cols-s_col) $
  ELSE n_col=cols-s_col
e_col=s_col+n_col-1
;
outarr=temporary(outarr[s_col:e_col,*])

IF ((n_row eq 1) OR (n_col eq 1)) THEN $
   outarr=reform(temporary(outarr))

ending:

RETURN, outarr

END   ; of Readarr
