function convert_Jy, wave

conv= 3.e-16  ;convert from W/cm2/micron to Jy
correction=wave^2/conv
return, correction
end

;-----------------------------------------------------------------------
function make_shortname, fname
  first_char    = STRPOS(fname,'T')
  last_char     = STRPOS(fname,'.fits')-7
  short_file_name=STRMID(fname,first_char,last_char-first_char)
  return, short_file_name
end
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
function make_shortname_DATA, fname
  first_char    = STRPOS(fname,'MIDI.')
  last_char     = STRPOS(fname,'.fits')
  short_file_name=STRMID(fname,first_char,last_char+5-first_char)
  return, short_file_name
end
;-----------------------------------------------------------------------
function  get_airmass, file

  im = obj_new('imagedata', file)
  he = im->prihead()
  objectname= STRCOMPRESS(he->getpar('OBS TARG NAME'),/remove_all)
  esolen = StrCompress(he->getpar('HIERARCH ESO ISS PBL12 START'),/remove_all)
  date   = StrCompress(he->getpar('DATE-OBS'),/remove_all)
  lst    = StrCompress(he->getpar('LST'),/remove_all)
  RA     = StrCompress(he->getpar('RA') ,/remove_all)
  Dec    = StrCompress(he->getpar('DEC'),/remove_all)
  jd	 = StrCompress(he->getpar('MJD-OBS'),/remove_all)
   shut	 = StrCompress(he->getpar('INS SHUT'),/remove_all)
 obj_destroy,im

  print, "object:              ",objectname
  print, "ESO's baseline len.: ", esolen
  print, "Date of observation: ", date
  print, "Julan day:      ", jd
  print, "Right Ascension:     ", RA
  print, "Declination:         ", Dec
am =airmass(double(jd),RA *!PI/180, Dec*!PI/180)
  print,"Shutter:         ",shut
  print,"Airmass:         ",am
return, am
end

;____________________________________________________________________________

pro ISO_SWS_comp, file, wave, template_MIDI,watt=watt

template=readarr(file)	
absc = template[1, *]
flux = template[2, *]
template_wave = absc(where((absc gt 6.) and (absc lt 14.)))
template_flux = flux(where((absc gt 6.) and (absc lt 14.)))
if keyword_set(watt) then template_flux = 3.E-16*template_flux/template_wave^2 ;conversion from Jy to W/cm^2
template_MIDI = INTERPOL(template_flux, template_wave, wave)



end
;____________________________________________________________________________

pro MCohen,file, wave, template_MIDI

pathCohen = '/home/chummel/oyster/catalogs/cohen/MIDI/'
template=readarr(pathCohen+file+'.tem')
absc = template[0, *]
flux = template[1, *]
template_wave = absc(where((absc gt 6.) and (absc lt 14.)))
template_flux = flux(where((absc gt 6.) and (absc lt 14.)))
template_MIDI = INTERPOL(template_flux, template_wave, wave)
end

;____________________________________________________________________________

pro Cal_comp, file, wave, template_MIDI
template=readarr(file)
absc = template[0, *]
flux = template[1, *]
template_wave = absc(where((absc gt 6.) and (absc lt 14.)))
template_flux = flux(where((absc gt 6.) and (absc lt 14.)))
template_MIDI = INTERPOL(template_flux, template_wave, wave)
end

;____________________________________________________________________________

;---------------------------------------------------------
pro lambda4, lambda, A,  F

F=A[0]/lambda^4+A[1]

end

;---------------------------------------------------------
pro autocalMIDI, file, range, wave, flux


;in W/cm2/micron

if not file_test("CAL") then spawn,'mkdir "CAL"'

openw, 1, 'CAL/'+file+'_cal.dat'
;FOR i=range-1,0, -1  DO BEGIN
FOR i=0,range-1  DO BEGIN
	printf, 1,wave[i], flux[i]
endfor
close, 1

end
;---------------------------------------------------------
pro autocalMIDIerr, file, range, wave, flux, fluxerr


;in W/cm2/micron

if not file_test("CAL") then spawn,'mkdir "CAL"'
name='CAL/'+file+'_cal.dat'
openw, 1, name
;FOR i=range-1,0, -1  DO BEGIN
FOR i=0,range-1  DO BEGIN
	printf, 1,wave[i], flux[i], fluxerr[i]
endfor
close, 1

end

;---------------------------------------------------------
pro calMIDIread, file, range, wave, flux

;in W/cm2/micron

wave = fltarr(range)
flux = fltarr(range)
openr, 1, 'CAL/'+file+'_cal.dat'

FOR i=0,range-1  DO BEGIN
	readf, 1,x,y
	wave[i] = x
	flux[i] = y
ENDFOR
close, 1
end
;---------------------------------------------------------

;-----------------------------------------------------------------------
pro printfile, day,file, wave, flux


       
	set_plot,'ps'


	file1='PS-'+day+'/'+file+'.ps'
	device, filename=file1
	range = where((wave ge 8.) and (wave lt 14))

	plot, wave(range), flux, yrange=[0, max(flux(range))], xrange=[8,13.4],$
	xtitle='Wavelength in micron',ytitle='W/cm!E2!N/micron', title=file,$
	position=position
	device, /close
	
	file2='PS-'+day+'/'+file+'Jy.ps'
	device, filename=file2
	Jy=wave^2/3.E-16
	flux=Jy*flux
	
	plot, wave(range), flux, yrange=[0, max(flux(range))], xrange=[8,13.4],$
	xtitle='Wavelength in micron',ytitle='Jy', title=file
	device, /close
	spawn,'gv '+file2
	set_plot,'x'
end


;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;function make_shortname, fname
;  first_char    = STRPOS(fname,'/MIDI.20')+6
;  last_char     = STRPOS(fname,'.fits')
;  short_file_name=STRMID(fname,first_char,last_char-first_char)
;  return, short_file_name
;end

;-----------------------------------------------------------------------
pro AlambdaPro,spec1, spec2,am1, am2, Alambda

diff=am2-am1

Alambda = (alog(spec1)-alog(spec2))/diff[0]

end

;-----------------------------------------------------------------------
function wavecalPrism, range

coef2=-0.00015387618
coef1=0.0094909213
detwin1strx=120
absc=dindgen(range)+detwin1strx
wave = absc^2*coef2+absc*coef1+15.451905  ; In absolute pixel coordinates!!!

return, wave

end
;-----------------------------------------------------------------------
function wavecalGrism, range

;coef2=-1.21122e-6
coef2=-2.21122e-6
coef1=0.0231223
absc=dindgen(range)
wave = absc^2*coef2+absc*coef1+7.54422  ; In absolute pixel coordinates!!!

return, wave

end

;-----------------------------------------------------------------------
pro imp, file
if not file_test("PS") then spawn,'mkdir "PS"'
	set_plot,'ps'


	file1='PS/'+file+'.ps'
	device, filename=file1
end
