pro add_orb_noise, data_file, num

; Add noise to simulated orbital measurements
; Use Gaussian distributed random numbers
 
; Read in data points from data_file

temp1 = 0d
temp2 = 0d
temp3 = 0d	; temporary variables to read data from file
temp4 = 0d
temp5 = 0d

time = dblarr(num)
theta = dblarr(num)
rho = dblarr(num)
dtheta = dblarr(num)
drho = dblarr(num)

openr,lun,data_file,/get_lun

for i=0, num-1 do begin

	readf, lun, temp1, temp2, temp3, temp4, temp5

	time(i) = temp1
	theta(i) = temp2
	dtheta(i) = temp3
	rho(i) = temp4	
	drho(i) = temp5
	
endfor

close,lun

; convert theta and dtheta to radians

theta = theta*!dpi/180
dtheta = dtheta*!dpi/180

; convert data points to x and y coordinates

xarr = rho * cos(theta)	; x coordinate
yarr = rho * sin(theta)	; y coordinate

; propagate errors in sep and PA to x and y:

dx = sqrt(cos(theta)^2*drho^2 + rho^2*sin(theta)^2*dtheta^2)
dy = sqrt(sin(theta)^2*drho^2 + rho^2*cos(theta)^2*dtheta^2)


seed=5L
print,'Enter seed for random generator (ex. 5L):'
read,seed

outfile = data_file+'_e'
openw,1,outfile

for i=0, num-1 do begin

     ; both routines return same sequence
     sig = randomn(seed)
;    sig = random(seed,/NORMAL) 

     xnew = xarr(i) + (sig*dx(i))

     ; both routines return same sequence
     sig = randomn(seed)
;    sig = random(seed,/NORMAL) 

     ynew = yarr(i) + (sig*dy(i))

     ; convert (xnew,ynew) to (PA,sep)
     ; x = rho*sin(theta), y=rho*sin(theta)

     sep = sqrt(xnew^2 + ynew^2)

     ; Get correct sign on PA by entering yorb,xorb separately into atan:
     PA = atan(ynew,xnew)

     if (PA lt 0.0) then PA = 2*!dpi + PA


     printf,1, format='(f10.4,f9.4,f8.4,f9.4,f8.4)', $
       time(i), PA*180d/!dpi, dtheta(i)*180d/!dpi, sep, drho(i)

     ;printf,1, format='(f9.4,f10.4,f8.4,f10.5,f9.5)', $
     ;  time(i), PA*180d/!dpi, dtheta(i)*180d/!dpi, sep, drho(i)


endfor

close,1

end
