pro add_velnoise, datafile, num

; Add noise to simulated SB2 velocity measurements
; Use Gaussian distributed random numbers
; Input data files should already be in the following format:
;      date   V1   V2
; (use make_sb2.pro to create velocity files)
;
; INPUT
; datafile:   date   V1   V2
; num: number of observing dates
;  
; Format of output
;       date   V1   eV1   V2   eV2     
; 
; PROMPTED INPUT
; err = average error in velocity measurements

err_s=' '
print, 'Enter size of 1-sigma uncertainty in V:'
read,err_s

err = double(err_s)

; Read in obs_file

time = dblarr(num)

; Read in velocity measurements from datafile

; relevant variables to store:

time = dblarr(num)
V1 = dblarr(num)
V2 = dblarr(num)

temp1 = 0.0
temp2 = 0.0
temp3 = 0.0

openr,1,datafile

for i=0, num-1 do begin
    
    readf,1, temp1, temp2, temp3

    time(i) = temp1
    V1(i) = temp2
    V2(i) = temp3

endfor
	
close,1

seed=5L
print,'Enter seed for random generator (ex. 5L):'
read,seed

outfile = datafile+'_e'+err_s
openw,1,outfile

for i=0, num-1 do begin

    ; both routines return same sequence
    ; sig = random(seed,/NORMAL) 	

    sig = randomn(seed)
    V1(i) = V1(i) + (sig*err)

    sig = randomn(seed)
    V2(i) = V2(i) + (sig*err)

    printf,1, format='(f9.3,f7.2,f4.1,f7.2,f4.1)', time(i),V1(i),err,V2(i),err

endfor

close,1

end
