pro aiWw, A_cap, B_cap, F_cap, G_cap, true_a, inc, Omega_cap, omega_low

; Determine a,i,Omega,omega from Thiele-Innes elements A,B,F,G
; INPUT: A,B,F,G
; OUTPUT: a,i,Omega,omega

BmF = (B_cap - F_cap)
BpF = (B_cap + F_cap)
AmG = (A_cap - G_cap)
ApG = (A_cap + G_cap)

; Determine sign of (Omega + omega) and (Omega - omega)
;print, "Check sign of (Omega + omega) and (Omega - omega)"

sinOpo = BmF		; sin(Omega + omega) is propotional to (B-F)
cosOpo = ApG		; cos(Omega + omega) is propotional to (A+G)

sinOmo = BpF		; sin(Omega - omega) is propotional to (B+F)
cosOmo = AmG		; cos(Omega - omega) is propotional to (A-G)

Opo = atan((BmF)/(ApG))
Omo = atan((BpF)/(AmG))

;print,"Check sign of Omega +/- omega"
;print,"O+o:", Opo
;print,"O-o:", Omo

if ((sinOpo/abs(sinOpo)) ne (sin(Opo)/abs(sin(Opo)))) then Opo = !dpi+Opo
if ((sinOmo/abs(sinOmo)) ne (sin(Omo)/abs(sin(Omo)))) then Omo = !dpi+Omo

;print,"Corrected O+o:", Opo
;print,"Corrected O-o:", Omo

Omega_cap = (Opo + Omo)/2d

;print,"Check if 0 < Omega < pi"
;print,"Omega:", Omega_cap 

if (Omega_cap gt !dpi) then omega_cap = omega_cap - !dpi
if (Omega_cap lt 0d) then omega_cap = omega_cap + !dpi

;print,"Corrected Omega:", Omega_cap 

omega_low = Opo - Omega_cap

; keep omega_low between 0 and 2Pi

if (omega_low lt 0.0) then omega_low = omega_low + 2*!dpi

inc = 2* atan(sqrt((BpF*sin(Opo))/(BmF*sin(Omo))))

; keep inc between 0 and 2Pi

if (inc lt 0.0) then inc = inc + 2*!dpi

true_a = sqrt((A_cap*G_cap - B_cap*F_cap)/cos(inc))

end
