pro auto_fit_orbit_vbsb1_lunar_vshift, time_vb, theta, dtheta, rho, drho, time_lun,PA_lun, sep_lun, dsep_lun, time_sb1_1, V1_sb1_1, dV1_sb1_1, time_sb1_2, V1_sb1_2, dV1_sb1_2, EL, elfix, print_results = print_results

; NOTE: ALL ANGLES INPUT AS RADIANS (NOT DEGREES)!
;       If /print_results is set, then print results to screen
  
; Fit simultaneous orbit to: visual orbit
; 
; Modified to include lunar occultation projection in orbit fit
;
; Compute the orbital elements through a Newton-Raphson technique.
;
; This program should work directly with the data points (rho,theta,t), not 
; the fitting points. 
;
; The program requires an initial guess that can be calculated from using
; the points from the fitting curves.
;
; Equations:  
; Initial estimates (P0,T0,e0,A0,B0,F0,G0) and a set of observations 
; (ti,rhoi,thetai) are known.
; The eccentric anomalies Ei can be found from: 
;	u(ti - T) = Ei - esin(Ei)
;	where u = 360/P
; True anomaly:
;	tan(nu/2) = E - esin(E)
; Radius vector:
;	r = a(1-e^2)/(1 + ecos(nu))
; The fitted (rho_i,theta_i) positions are determined from the orbital elements
; 	tan(theta - Omega) = tan(nu + omega)*cosi
;	rho = r*cos(nu + omega)*sec(theta - Omega)
;
; Procedure:
; Minimize chi squared between data point positions and fitted positions:
;	chi^2 = sum[(rhodata - rhoi)^2/sigmarho^2 
;		    + (thetadata - thetai)^2/sigmatheta^2]
; Take partial derivatives of chi^2 with respect to the orbital elements,
; (P,T,e,a,i,Omega,omega) and set to zero. Solve for the value of the orbital 
; elements that minimize chi^2.
;
; Since the partial derivatives are non-linear, cannot solve for the orbital
; elements that minimize chi^2 analytically.
;
; In turn, use a Newton-Raphson technique to converge upon the solution.
; Replace (rhoi,thetai) in the chi^2 equation with the Taylor series 
; approximation,
; 	x = x| + dx/dP|(P-P0) + dx/dT|(T-T0) + dx/de|(e-e0) 
;	       + dx/da|(a-Aa) + dx/di|(i-i0) + dx/dW|(W-W0) + dx/dw|(w-w0)
; where x=(rho,theta) and the | represents the value evaluated at for the
; initial estimates for the orbital elements. Now, rhoi and thetai are linear 
; in (P,T,e,a,i,W,w), so the partial derivatives can easily be taken and solved
; by setting up a matrix and using Cramer's method.
;
; Parameters:
;	Period:	 period (P)
;	Tperi: 	 time of periastron passage (T)
;	ecc:	 eccentricity (e)
;	major:	 semi-major axis (in mas) (a)
;	inc:	 inclination (i)
;	Omega:	 position angle of node (W)
;	omega:	 angle between node and periastron (w)
;	ti:	 time of observation
;	rho_d:	 separation - data
;	theta_d: postion angle - data
;	rho_f:	 sep - fit (determined from orbital elements for time of obs.)
;	theta_f: PA - fit (determined from orbital elements for time of obs.)
;
; INPUT:
;	vb_file: file containing data points in the format:
;		      time  theta  etheta  rho  erho
;		      where theta is the position angle, rho is the separation
;                     and etheta, erho are the measurement uncertainties
;		      (enter file name using quotes)
;	num: number of data points contained in vb_file
;	
; Prompted inputs:
;	initial estimates for all the orbital elements: P,T,e,a,i,Omega,omega
;
; Calls the following routines:
;     calc_deriv_vb.pro
;     calc_deriv_lunar
;     calc_Ei.pro
;     solve_trans.pro
;     calc_vbfit.pro - for plotting model orbits!
;
; Began 14 May 2002
; Modified 11 Nov 2003: 
;       This is the current version of NEWT_RAPH.PRO
;	(v1.1 and v1.2 are older versions)
; 	- restructured program into separate subroutines
; 	- add option of holding elements fixed during iterations
; 13 January 2005:
;       Fix bugs
;       - if solving for only one element, don't use cramer.pro to solve eqn's
;       - fix 360 degree roll overs in (PAdata - PAfit)
;       Save version v4 as backup
; 11 July 2005:
;       - Include Marquadt Method of adjusting diagonal elements of
;         the alpha matrix to ensure convergence.
;       - Fixed non-convergence problems 
;           + do not remove P wrap around effects from dx/dP
;             leave (t-T)/P in full form; net effect is that adjustments
;             are smaller
;       Save v5 as backup 
; 13 July 2005:
;       - Change format of plotting routines to include a call to
;         calc_vbfit
;       Save v6 as backup
; 3 May 2006:
;       - Modified to include lunar occultation projection in orbit fit

!P.font=0
!P.multi=0
!P.charsize=1.2
!P.charthick=2.0
!P.thick=2.0
!X.thick=2.0
!Y.thick=2.0
frac=1.2	;scale factor for adjusting size of plotting symbols

; Set color table
;  red=1, green=2, blue=3

tvlct, [255,0,0], [0,255,0], [0,0,255], 1

; If keyword print_results is set, then print results on screen
; keyword_set returns True (1) if showplot is defined, False (0) if undefined
ans_print = keyword_set(print_results)


vb_num = n_elements(time_vb)
lun_num = n_elements(time_lun)
sb1_num1 = n_elements(time_sb1_1)
sb1_num2 = n_elements(time_sb1_2)

; convert data points to x and y coordinates

xarr = rho * cos(theta)	; x coordinate
yarr = rho * sin(theta)	; y coordinate

; propagate errors in sep and PA to x and y:

dx = sqrt(cos(theta)^2*drho^2 + rho^2*sin(theta)^2*dtheta^2)
dy = sqrt(sin(theta)^2*drho^2 + rho^2*cos(theta)^2*dtheta^2)

; Obtain values for P,T,e,a,i,Omega,omega 

period = EL(0)
Tperi = EL(1)
ecc = EL(2)
major = EL(3)
inc = EL(4)
W_cap = EL(5)
w_low = EL(6)
K1 = EL(7)
Vsys1 = EL(8)
Vsys2 = EL(9)

;print,"Enter P,T,e,a,i,Omega,omega,K1(km/s),Vsys,Vsys2:"
;read,period,Tperi,ecc,major,inc,W_cap,w_low,K1,Vsys1,Vsys2

;print, "Vary each orbital element?"
;print, "For each element, enter 0 to hold element fixed, 1 to vary:"
;print, "[P,T,e,a,i,Omega,omega,K1,Vsys1,Vsys2]"
;read, f0,f1,f2,f3,f4,f5,f6,f7,f8,f9

f0 = elfix(0)
f1 = elfix(1)
f2 = elfix(2)
f3 = elfix(3)
f4 = elfix(4)
f5 = elfix(5)
f6 = elfix(6)
f7 = elfix(7)
f8 = elfix(8)
f9 = elfix(9)

;elfix=[f0,f1,f2,f3,f4,f5,f6,f7,f8,f9]
nEl = n_elements(elfix)

elfix_vb=[f0,f1,f2,f3,f4,f5,f6]
nEl_vb = n_elements(elfix_vb)

elfix_lun=[f0,f1,f2,f3,f4,f5,f6]
nEl_lun = n_elements(elfix_lun)

elfix_sb1_1=[f0,f1,f2,f7,f6,f8]
nEl_sb1_1 = n_elements(elfix_sb1_1)

elfix_sb1_2=[f0,f1,f2,f7,f6,f9]
nEl_sb1_2 = n_elements(elfix_sb1_2)

;print,"Initial P,T,e,a,i,Omega,omega,K1,Vsys,Vsys2:"
;print,period,Tperi,ecc,major,inc,W_cap,w_low,K1,Vsys1,Vsys2

;convert i, Omega, omega to radians
;inc = inc*!dpi/180
;W_cap = W_cap*!dpi/180
;w_low = w_low*!dpi/180

k=0
for i=0, nEl-1 do if (elfix(i) eq 0) then k=k+1
mfit = nEl - k 		; number of elements to improve

k=0
for i=0, nEl_vb-1 do if (elfix_vb(i) eq 0) then k=k+1
mfit_vb = nEl_vb - k 		; number of elements to improve

k=0
for i=0, nEl_lun-1 do if (elfix_lun(i) eq 0) then k=k+1
mfit_lun = nEl_lun - k 		; number of elements to improve

k=0
for i=0, nEl_sb1_1-1 do if (elfix_sb1_1(i) eq 0) then k=k+1
mfit_sb1_1 = nEl_sb1_1 - k 		; number of elements to improve

k=0
for i=0, nEl_sb1_2-1 do if (elfix_sb1_2(i) eq 0) then k=k+1
mfit_sb1_2 = nEl_sb1_2 - k 		; number of elements to improve

; determine indices of elements for which to vary
elvar = where(elfix ne 0)

; Note: this first line resets inc, Omega, omega to radians
EL = [period,Tperi,ecc,major,inc,W_cap,w_low,K1,Vsys1,Vsys2]
EL_vb = [period,Tperi,ecc,major,inc,W_cap,w_low]
EL_lun = [period,Tperi,ecc,major,inc,W_cap,w_low]
EL_sb1_1 = [period,Tperi,ecc,K1,w_low,Vsys1]
EL_sb1_2 = [period,Tperi,ecc,K1,w_low,Vsys2]

ELadj = EL
elLabel = ['P','T','e','a','i','Omega','omega_A','K1(km/s)','Vsys1','Vsys2']

; determine which indices of full set are being varied

if (mfit_vb ne 0) then     vb_subset = dblarr(mfit_vb)
if (mfit_lun ne 0) then    lun_subset = dblarr(mfit_lun)
if (mfit_sb1_1 ne 0) then  sb1_subset_1 = dblarr(mfit_sb1_1)
if (mfit_sb1_2 ne 0) then  sb1_subset_2 = dblarr(mfit_sb1_2)

; determine subarray of indices that are VB, SB1, and SB2 parameters

vb_par = dblarr(nEl_vb)
lun_par = dblarr(nEl_lun)
sb1_par_1 = dblarr(nEl_sb1_1)
sb1_par_2 = dblarr(nEl_sb1_2)

; determine indices of elements for which to vary
el_subset = where(elfix ne 0)
Elvar = El(el_subset)

k=0
for i=0, nEl_vb-1 do begin
    ind = where(EL_vb(i) eq EL)
    vb_par(i) = ind
    if (elfix_vb(i) ne 0) then begin
        ind = where(EL_vb(i) eq Elvar)
        vb_subset(k) = ind
        k=k+1
    endif
endfor

k=0
for i=0, nEl_lun-1 do begin
    ind = where(EL_lun(i) eq EL)
    lun_par(i) = ind
    if (elfix_lun(i) ne 0) then begin
        ind = where(EL_lun(i) eq Elvar)
        lun_subset(k) = ind
        k=k+1
    endif
endfor

k=0
for i=0, nEl_sb1_1-1 do begin
    ind = where(EL_sb1_1(i) eq EL)
    sb1_par_1(i) = ind
    if (elfix_sb1_1(i) ne 0) then begin
         ind = where(EL_sb1_1(i) eq Elvar)
         sb1_subset_1(k) = ind
        k=k+1
    endif
endfor

k=0
for i=0, nEl_sb1_2-1 do begin
    ind = where(EL_sb1_2(i) eq EL)
    sb1_par_2(i) = ind
    if (elfix_sb1_2(i) ne 0) then begin
         ind = where(EL_sb1_2(i) eq Elvar)
         sb1_subset_2(k) = ind
        k=k+1
    endif
endfor

; **** Plot model orbits ****

;ans_cont = ' '
;
;; plot model and data of initial guess
;
;tnum=1000.0
;tstep = period/tnum
;tmin = Tperi
;
;tarr = findgen(tnum)*tstep + tmin
;
;calc_vbfit, EL, tarr, theta_mod, rho_mod, /flag_wa
;
;xmod = rho_mod * cos(theta_mod)	; x coordinate
;ymod = rho_mod * sin(theta_mod)	; y coordinate

;; plot best-fit orbit
;
;plot,-yarr,xarr,psym=6
;oplot,-ymod,xmod

;print,'Hit enter to continue'
;read,ans_cont
;
;; plot model and data of initial guess for SB2 data
;
;tnum = 1000.0
;tmin = min([min(time_sb1_1),min(time_sb1_2)])
;tmax = max([max(time_sb1_1),max(time_sb1_2)])
;tstep = (tmax-tmin)/tnum
;
;tarr = findgen(tnum)*tstep + tmin
;
;calc_sb1fit, EL_sb1_1, tarr, V1mod_1
;
;vmax = max([max(V1mod_1),max(V1_sb1_1),max(V1_sb1_2)])
;vmin = min([min(V1mod_1),min(V1_sb1_1),min(V1_sb1_2)])

;print,'SB1 velocity curve'
;plot,time_sb1_1,V1_sb1_1,psym=2,yrange=[vmin,vmax]
;oplot,time_sb1_2,V1_sb1_2 + (Vsys1 - Vsys2),psym=2
;oplot,tarr,V1mod_1

;print,'Hit return to continue'
;read,ans_cont

count = 0

delta_chi = 1.0		; set initially to begin loop

lambda = 0.001   ; Marquardt method to ensure convergence

; ***** Begin while loop ***** 

while(delta_chi gt 0.001) do begin

    ; Determine errors in orbital elements
    ; set up matrices for error determination
    ; Invert matrix through Gauss Jordan elimination (Numerical Recipes in C)

    ; set up covariance matrix and column matrix
    ; alpha = dblarr(7,7)
    ; beta = dblarr(7)

   if (mfit_vb ne 0) then calc_deriv_vb, EL_vb, elfix_vb, mfit_vb, time_vb, theta, rho, dtheta, drho, theta_f, rho_f, alpha_vb, beta_vb, /flag_wa $
   else calc_vbfit, EL_vb, time_vb, theta_f, rho_f, /flag_wa

   if (mfit_lun ne 0) then calc_deriv_lunar, EL_lun, elfix_lun, mfit_lun, time_lun, PA_lun, sep_lun, dsep_lun, sep_f, alpha_lun, beta_lun, /flag_wa $
   else begin
      calc_vbfit, EL_vb, time_lun, theta_lun_f, rho_lun_f, /flag_wa
      sep_f =  rho_lun_f*cos(theta_lun_f - PA_lun)
   endelse
      
   if (mfit_sb1_1 ne 0) then calc_deriv_sb1, EL_sb1_1, elfix_sb1_1, mfit_sb1_1, time_sb1_1, V1_sb1_1, dV1_sb1_1, V1_f_sb1_1, alpha_sb1_1, beta_sb1_1 $
   else calc_sb1fit, EL_sb1_1, time_sb1_1, V1_f_sb1_1


   if (mfit_sb1_2 ne 0) then calc_deriv_sb1, EL_sb1_2, elfix_sb1_2, mfit_sb1_2, time_sb1_2, V1_sb1_2, dV1_sb1_2, V1_f_sb1_2, alpha_sb1_2, beta_sb1_2 $
   else calc_sb1fit, EL_sb1_2, time_sb1_2, V1_f_sb1_2

    ; Determine chi squared

    ; convert data points to x and y coordinates

    xfit = rho_f * cos(theta_f)	; x coordinate
    yfit = rho_f * sin(theta_f)	; y coordinate
			
    ;chi2old = total((xarr-xfit)^2/dx^2 + (yarr-yfit)^2/dy^2)

    diff_theta = theta - theta_f

    ; account for any wrap-arounds from 360 deg to 0 deg

    for k=0, vb_num-1 do begin
        if (diff_theta(k) ge !dpi) then $
          diff_theta(k) = diff_theta(k) - 2*!dpi
        if (diff_theta(k) le -!dpi) then $
          diff_theta(k) = 2*!dpi + diff_theta(k)	
    endfor

    chi2old = total((diff_theta)^2/dtheta^2 + (rho - rho_f)^2/drho^2) $
                    + total((sep_lun - sep_f)^2/dsep_lun^2) $
                    + total((V1_sb1_1 - V1_f_sb1_1)^2/dV1_sb1_1^2) $
                    + total((V1_sb1_2 - V1_f_sb1_2)^2/dV1_sb1_2^2)

    ; combine VB lunar matrices (same number of elements)...

    ; initialize full alpha,beta arrays
    alpha = dblarr(mfit,mfit)
    beta = dblarr(mfit)

    if (mfit_vb ne 0) then begin

       beta(vb_subset) = beta(vb_subset) + beta_vb

       for i=0, mfit_vb-1 do begin
          for j=0, mfit_vb-1 do begin
             alpha(vb_subset(i),vb_subset(j)) = $
                alpha(vb_subset(i),vb_subset(j)) + alpha_vb(i,j)
          endfor
       endfor
       
    endif

    if (mfit_lun ne 0) then begin
       beta(lun_subset) = beta(lun_subset) + beta_lun

       for i=0, mfit_lun-1 do begin
          for j=0, mfit_lun-1 do begin
             alpha(lun_subset(i),lun_subset(j)) = $
                alpha(lun_subset(i),lun_subset(j)) + alpha_lun(i,j)
          endfor
       endfor

    endif

    if (mfit_sb1_1 ne 0) then begin

       beta(sb1_subset_1) = beta(sb1_subset_1) + beta_sb1_1

       for i=0, mfit_sb1_1-1 do begin
          for j=0, mfit_sb1_1-1 do begin
             alpha(sb1_subset_1(i),sb1_subset_1(j)) = $
                alpha(sb1_subset_1(i),sb1_subset_1(j)) + alpha_sb1_1(i,j)
          endfor
       endfor

    endif

    if (mfit_sb1_2 ne 0) then begin

       beta(sb1_subset_2) = beta(sb1_subset_2) + beta_sb1_2

       for i=0, mfit_sb1_2-1 do begin
          for j=0, mfit_sb1_2-1 do begin
             alpha(sb1_subset_2(i),sb1_subset_2(j)) = $
                alpha(sb1_subset_2(i),sb1_subset_2(j)) + alpha_sb1_2(i,j)
          endfor
       endfor

    endif

    invmat = invert(alpha, stat, /double)

    if (ans_print) then print,"stat (0 successful):",stat

    ;determine errors:

    ELerr = dblarr(mfit)

    for i=0, mfit-1 do ELerr(i) = sqrt(invmat(i,i))

    ; adjust alpha matrix by Marquardt parameter lambda

    for i=0, mfit-1 do alpha(i,i) = alpha(i,i)*(1.0 + lambda)

    if (mfit eq 1) then begin
        delta_el = dblarr(1)
        delta_el(0) = beta/alpha
    endif else delta_el = cramer(alpha,beta)   ; adjustments

    ; adjust orbital parameters
    
    ELadj = EL
    ELadj(el_subset) = ELadj(el_subset) + delta_el 

    ELadj_vb  = ELadj(vb_par) 
    ELadj_lun  = ELadj(lun_par) 
    ELadj_sb1_1 = ELadj(sb1_par_1) 
    ELadj_sb1_2 = ELadj(sb1_par_2) 

    if (ans_print) then  begin
    
    k=0
    print,"Orbital Element     Adjustment"
    for i=0, 3 do begin
        if (elfix(i) eq 0) then begin
            print, elLabel(i), ': ', El(i)
        endif else begin
            print, elLabel(i), ': ', El(i), delta_el(k)
            k=k+1
        endelse
    endfor
    for i=4, 6 do begin
         if (elfix(i) eq 0) then begin
             print, elLabel(i), ': ', El(i)*180/!dpi
         endif else begin
             print, elLabel(i), ': ', El(i)*180/!dpi, delta_el(k)*180/!dpi
             k = k+1
         endelse
    endfor
    for i=7, 9 do begin
        if (elfix(i) eq 0) then begin
            print, elLabel(i), ': ', El(i)
        endif else begin
            print, elLabel(i), ': ', El(i), delta_el(k)
            k=k+1
        endelse
    endfor

    print,"Chi2 of current solution:",chi2old

    endif
    
    ; plot visual orbit

;    plot,-yarr,xarr,psym=6
;    oplot,-yfit,xfit,psym=7
;    for l=0, vb_num-1 do oplot,[-yarr(l),-yfit(l)],[xarr(l),xfit(l)]

    ;plot SB velocity curves

;    plot,time_sb1_1,V1_sb1_1,psym=2,yrange=[vmin,vmax],xrange=[tmin,tmax]
;    oplot,time_sb1_2,V1_sb1_2 + (Vsys1 - Vsys2),psym=2
;    oplot,time_sb1_1,V1_f_sb1_1,psym=7
;    oplot,time_sb1_2,V1_f_sb1_2,psym=7
;    for l=0, sb1_num1-1 do oplot,[time_sb1_1(l),time_sb1_1(l)],[V1_sb1_1(l),V1_f_sb1_1(l)]
;    for l=0, sb1_num2-1 do oplot,[time_sb1_2(l),time_sb1_2(l)],[V1_sb1_2(l),V1_f_sb1_2(l)] + (Vsys1 - Vsys2)
;
;    wait,0.1
;
;    if (count eq 0) then begin
;        print,'Hit return to continue'
;        read,ans_cont
;    endif


    ; calculate new chi2 for adjusted parameters

   if (mfit_vb ne 0) then calc_deriv_vb, EL_vb, elfix_vb, mfit_vb, time_vb, theta, rho, dtheta, drho, theta_f, rho_f, alpha_vb, beta_vb, /flag_wa $
   else calc_vbfit, EL_vb, time_vb, theta_f, rho_f, /flag_wa

   if (mfit_lun ne 0) then calc_deriv_lunar, EL_lun, elfix_lun, mfit_lun, time_lun, PA_lun, sep_lun, dsep_lun, sep_f, alpha_lun, beta_lun, /flag_wa $
   else begin
      calc_vbfit, EL_vb, time_lun, theta_lun_f, rho_lun_f, /flag_wa
      sep_f =  rho_lun_f*cos(theta_lun_f - PA_lun)
   endelse
      
   if (mfit_sb1_1 ne 0) then calc_deriv_sb1, EL_sb1_1, elfix_sb1_1, mfit_sb1_1, time_sb1_1, V1_sb1_1, dV1_sb1_1, V1_f_sb1_1, alpha_sb1_1, beta_sb1_1 $
   else calc_sb1fit, EL_sb1_1, time_sb1_1, V1_f_sb1_1


   if (mfit_sb1_2 ne 0) then calc_deriv_sb1, EL_sb1_2, elfix_sb1_2, mfit_sb1_2, time_sb1_2, V1_sb1_2, dV1_sb1_2, V1_f_sb1_2, alpha_sb1_2, beta_sb1_2 $
   else calc_sb1fit, EL_sb1_2, time_sb1_2, V1_f_sb1_2


    ; Determine chi squared

    ; convert data points to x and y coordinates

    xfit = rho_f * cos(theta_f)	; x coordinate
    yfit = rho_f * sin(theta_f)	; y coordinate
			
    ;chi2new = total((xarr-xfit)^2/dx^2 + (yarr-yfit)^2/dy^2)

    diff_theta = theta - theta_f

    ; account for any wrap-arounds from 360 deg to 0 deg

    for k=0, vb_num-1 do begin
        if (diff_theta(k) ge !dpi) then $
          diff_theta(k) = diff_theta(k) - 2*!dpi
        if (diff_theta(k) le -!dpi) then $
          diff_theta(k) = 2*!dpi + diff_theta(k)	
    endfor


    chi2new = total((diff_theta)^2/dtheta^2 + (rho - rho_f)^2/drho^2) $
                    + total((sep_lun - sep_f)^2/dsep_lun^2) $
                    + total((V1_sb1_1 - V1_f_sb1_1)^2/dV1_sb1_1^2) $
                    + total((V1_sb1_2 - V1_f_sb1_2)^2/dV1_sb1_2^2)


    if (ans_print) then print,"chi2 of next modification:",chi2new

    if (chi2new le chi2old) then begin
        EL = ELadj
        EL_vb = ELadj_vb
        EL_lun = ELadj_lun
        EL_sb1_1 = ELadj_sb1_1
        EL_sb1_2 = ELadj_sb1_2
	chi2 = chi2new
        delta_chi = chi2old - chi2new
        lambda = lambda/10.0
        if (ans_print) then print, 'lambda', lambda
    endif else begin
	if (ans_print) then print, "next adjustment does not improve chi2"
        if (ans_print) then print, "increasing lambda by 10.0"
        lambda = lambda*10.0
        if (ans_print) then print, 'lambda', lambda
        delta_chi = 1.0
    endelse

    count = count+1

    ; do not exit unless lambda is less than 0.001

;    if (lambda gt 0.001) and (delta_chi lt 0.001) then delta_chi = 1.0
;    print,'lambda',lambda
;    print,'delta_chi',delta_chi

endwhile

lambda = 0.0

if (ans_print) then print, "Final values:"

period = EL(0)
Tperi = EL(1)
ecc = EL(2)
major =  EL(3)
inc = EL(4)
W_cap = EL(5)
w_low = EL(6)
K1 = EL(7)
Vsys1 = EL(8)
Vsys2 = EL(9)

if (mfit_vb ne 0) then calc_deriv_vb, EL_vb, elfix_vb, mfit_vb, time_vb, theta, rho, dtheta, drho, theta_f, rho_f, alpha_vb, beta_vb, /flag_wa $
else calc_vbfit, EL_vb, time_vb, theta_f, rho_f, /flag_wa

if (mfit_lun ne 0) then calc_deriv_lunar, EL_lun, elfix_lun, mfit_lun, time_lun, PA_lun, sep_lun, dsep_lun, sep_f, alpha_lun, beta_lun, /flag_wa $
else begin
   calc_vbfit, EL_vb, time_lun, theta_lun_f, rho_lun_f, /flag_wa
   sep_f =  rho_lun_f*cos(theta_lun_f - PA_lun)
endelse
      
if (mfit_sb1_1 ne 0) then calc_deriv_sb1, EL_sb1_1, elfix_sb1_1, mfit_sb1_1, time_sb1_1, V1_sb1_1, dV1_sb1_1, V1_f_sb1_1, alpha_sb1_1, beta_sb1_1 $
else calc_sb1fit, EL_sb1_1, time_sb1_1, V1_f_sb1_1


if (mfit_sb1_2 ne 0) then calc_deriv_sb1, EL_sb1_2, elfix_sb1_2, mfit_sb1_2, time_sb1_2, V1_sb1_2, dV1_sb1_2, V1_f_sb1_2, alpha_sb1_2, beta_sb1_2 $
else calc_sb1fit, EL_sb1_2, time_sb1_2, V1_f_sb1_2


; combine VB, SB, and lunar matrices...

; initialize full alpha,beta arrays
alpha = dblarr(mfit,mfit)
beta = dblarr(mfit)

if (mfit_vb ne 0) then begin

   beta(vb_subset) = beta(vb_subset) + beta_vb

   for i=0, mfit_vb-1 do begin
      for j=0, mfit_vb-1 do begin
         alpha(vb_subset(i),vb_subset(j)) = $
            alpha(vb_subset(i),vb_subset(j)) + alpha_vb(i,j)
      endfor
   endfor
   
endif

if (mfit_lun ne 0) then begin
   beta(lun_subset) = beta(lun_subset) + beta_lun
   
   for i=0, mfit_lun-1 do begin
      for j=0, mfit_lun-1 do begin
         alpha(lun_subset(i),lun_subset(j)) = $
            alpha(lun_subset(i),lun_subset(j)) + alpha_lun(i,j)
      endfor
   endfor
   
endif

if (mfit_sb1_1 ne 0) then begin

   beta(sb1_subset_1) = beta(sb1_subset_1) + beta_sb1_1

   for i=0, mfit_sb1_1-1 do begin
      for j=0, mfit_sb1_1-1 do begin
         alpha(sb1_subset_1(i),sb1_subset_1(j)) = $
            alpha(sb1_subset_1(i),sb1_subset_1(j)) + alpha_sb1_1(i,j)
      endfor
   endfor

endif

if (mfit_sb1_2 ne 0) then begin

   beta(sb1_subset_2) = beta(sb1_subset_2) + beta_sb1_2

   for i=0, mfit_sb1_2-1 do begin
      for j=0, mfit_sb1_2-1 do begin
         alpha(sb1_subset_2(i),sb1_subset_2(j)) = $
            alpha(sb1_subset_2(i),sb1_subset_2(j)) + alpha_sb1_2(i,j)
      endfor
   endfor
   
endif




invmat = invert(alpha, stat, /double)

;determine errors:

diff_theta = theta - theta_f

; account for any wrap-arounds from 360 deg to 0 deg

for k=0, vb_num-1 do begin
if (diff_theta(k) ge !dpi) then $
	diff_theta(k) = diff_theta(k) - 2*!dpi
if (diff_theta(k) le -!dpi) then $
	diff_theta(k) = 2*!dpi + diff_theta(k)	
endfor


chi2 = total((diff_theta)^2/dtheta^2 + (rho - rho_f)^2/drho^2) $
             + total((sep_lun - sep_f)^2/dsep_lun^2) $
             + total((V1_sb1_1 - V1_f_sb1_1)^2/dV1_sb1_1^2) $
             + total((V1_sb1_2 - V1_f_sb1_2)^2/dV1_sb1_2^2)

; degrees of freedom
dof = 2d*vb_num + sb1_num1 + sb1_num2 + lun_num - mfit

; reduced chi squared:
chi2red = chi2/dof


; Compute chi2 for each data set separately

chi2_vb = total((diff_theta)^2/dtheta^2 + (rho - rho_f)^2/drho^2)
chi2_lun = total((sep_lun - sep_f)^2/dsep_lun^2)
chi2_sb1_1 = total((V1_sb1_1 - V1_f_sb1_1)^2/dV1_sb1_1^2)
chi2_sb1_2 = total((V1_sb1_2 - V1_f_sb1_2)^2/dV1_sb1_2^2)

redchi2_vb = chi2_vb / (2.0*vb_num - mfit_vb)
redchi2_lun = chi2_lun / (lun_num - mfit_lun)
redchi2_sb1_1 = chi2_sb1_1 / (sb1_num1 - mfit_sb1_1)
redchi2_sb1_2 = chi2_sb1_2 / (sb1_num2 - mfit_sb1_2)

ELerr = dblarr(mfit)
for i=0,mfit-1 do ELerr(i) = sqrt(chi2red)*sqrt(invmat(i,i))

if (ans_print) then begin

k=0
print,"Orbital Element     Error"
for i=0, 3 do begin
    if (elfix(i) eq 0) then begin
        print, elLabel(i), ': ', El(i)
    endif else begin
        print, elLabel(i), ': ', El(i), ELerr(k)
        k=k+1
    endelse
endfor
for i=4, 6 do begin
     if (elfix(i) eq 0) then begin
         print, elLabel(i), ': ', El(i)*180/!dpi
     endif else begin
         print, elLabel(i), ': ', El(i)*180/!dpi, ELerr(k)*180/!dpi
         k = k+1
     endelse
endfor
for i=7,9 do begin
    if (elfix(i) eq 0) then begin
        print, elLabel(i), ': ', El(i)
    endif else begin
        print, elLabel(i), ': ', El(i), ELerr(k)
        k=k+1
    endelse
endfor
print, "Final chi2:", chi2
print, "Reduced chi2:", chi2red
print, 'VB    - chi2 redchi2:', chi2_vb, redchi2_vb
print, 'Lunar - chi2 redchi2:', chi2_lun, redchi2_lun
print, 'SB1   - chi2 redchi2:', chi2_sb1_1, redchi2_sb1_1
print, 'SB1_2 - chi2 redchi2:', chi2_sb1_2, redchi2_sb1_2

print,'Number of iterations:',count
;print,'Final chi2:',chi2

scale_deg = [1.0,1.0,1.0,1.0,180/!dpi,180/!dpi,180/!dpi,1.0,1.0,1.0]

print,EL*scale_deg

endif

;; plot best-fit orbit and data
;
;tnum=1000.0
;tstep = period/tnum
;tmin = Tperi
;
;tarr = findgen(tnum)*tstep + tmin
;
;calc_vbfit, EL_vb, tarr, theta_mod, rho_mod,/flag_wa
;
;xmod = rho_mod * cos(theta_mod)	; x coordinate
;ymod = rho_mod * sin(theta_mod)	; y coordinate
;
; plot data and best-fit positions for visual orbit
;print,'Visual orbit'
;plot,-yarr,xarr,psym=6
;oplot,-yfit,xfit,psym=7
;for l=0, vb_num-1 do oplot,[-yarr(l),-yfit(l)],[xarr(l),xfit(l)]
;
;; plot best-fit orbit
;oplot,-ymod,xmod
;
;print,'Hit return to continue'
;read,ans_cont


;; plot model and data of initial guess for SB2 data
;
;tnum = 1000.0
;tmin = min([min(time_sb1_1),min(time_sb1_2)])
;tmax = max([max(time_sb1_1),max(time_sb1_2)])
;tstep = (tmax-tmin)/tnum
;
;tarr = findgen(tnum)*tstep + tmin
;
;calc_sb1fit, EL_sb1_1, tarr, V1mod_1
;
;vmax = max([max(V1mod_1),max(V1_sb1_1),max(V1_sb1_2)])
;vmin = min([min(V1mod_1),min(V1_sb1_1),min(V1_sb1_2)])
;vrange = tmax - tmin
;vmin = vmin - 0.05*vrange
;vmax = vmax + 0.05*vrange
;
;print,'SB1 velocity curve'
;plot,time_sb1_1,V1_sb1_1,psym=2,yrange=[vmin,vmax]
;oplot,time_sb1_2,V1_sb1_2 + (Vsys1 - Vsys2),psym=2
;oplot,tarr,V1mod_1
;
;
;print,'Lunar occultation separation (meas/calc):'
;print,sep_lun,sep_f



;; Define user symbol to be closed circle
;; Make a vector of 16 points, Z[i] = 2pi/16:
;Z = findgen(17) * (!pi*2/16.)
;
;; Plot measured positions as filled circles
;
;usersym, frac*cos(Z), frac*sin(Z),/fill
;
;sepmax = 1.2*max(abs([yarr,xarr]))
;
;set_plot, 'ps'
;device,/Color,Bits_per_pixel=8,filename='temp_vb.eps',xsize=12,ysize=12,isolatin1=1,/encap
;
;    ploterror,yarr,xarr,dy,dx,xtitle='!9D!3RA (mas)',ytitle='!9D!3DEC (mas)',ISOTROPIC=1, $
;	 xrange=[sepmax,-sepmax], yrange=[-sepmax,sepmax], $
;         xstyle=1,ystyle=1, /nodata, position=[0.19,0.12,0.95,0.98]
;
;    ; Connected measured and fit values
;    for i=0,vb_num-1 do oplot,[yfit(i),yarr(i)],[xfit(i),xarr(i)]
;
;    ; Mark computed location with x
;    oplot,[yfit],[xfit],psym=7
;
;                                ; mark primary with an asterisk
;    oplot,[0],[0],psym=2
;    oplot,[-sepmax,sepmax],[0,0],linestyle=1
;    oplot,[0,0],[-sepmax,sepmax],linestyle=1
;
;    ;Define the symbol to be a closed circle
;    usersym, frac*cos(Z), frac*sin(Z), /fill
;    oplot,yarr,xarr,psym=8
;
;; plot best-fit orbit
;oplot,ymod,xmod,color=3



;; plot lunar occultation projection and projected separation of binary
;
;calc_vbfit, EL_vb, time_lun, theta_fit_lun, rho_fit_lun, /flag_wa
;
;xfit_lun = rho_fit_lun * cos(theta_fit_lun)	; x coordinate
;yfit_lun = rho_fit_lun * sin(theta_fit_lun)	; y coordinate
;
;ra_lun = 150.0*sin(PA_lun)
;dec_lun = 150.0*cos(PA_lun)
;
;oplot,[ra_lun,-ra_lun],[dec_lun,-dec_lun]
;print,ra_lun,dec_lun
;
;ra_lun_meas = sep_lun*sin(PA_lun)
;dec_lun_meas = sep_lun*cos(PA_lun)
;
;if (yfit_lun le 0) then oplot,[0,ra_lun_meas],[0,dec_lun_meas],color=1,thick=5
;if (yfit_lun ge 0) then oplot,[0,-ra_lun_meas],[0,-dec_lun_meas],color=1,thick=5


;; find equation of line that passes through projected separation
;; (perpendicular to lunar occultation PA)
;; b = y - mx
;
;m_slope = -sin(PA_lun)/cos(PA_lun)
;b_int = sep_lun*cos(PA_lun) - m_slope*sep_lun*sin(PA_lun)
;
;;oplot,[150,-150],[150*m_slope+b_int,-150*m_slope+b_int],LineStyle=2
;
;; and equivalent line at minus projected sep
;b_int = -sep_lun*cos(PA_lun) + m_slope*sep_lun*sin(PA_lun)
;
;oplot,[100,-100],[100*m_slope+b_int,-100*m_slope+b_int],LineStyle=2

;; Filled Squares for lunar occultation prediction
;; Define user symbol to be open rectangle
;xrect = frac*[-1.0,-1.0,1.0,1.0,-1.0]
;yrect = frac*[-1.0,1.0,1.0,-1.0,-1.0]
;usersym,xrect,yrect,/fill
;oplot,[yfit_lun],[xfit_lun],psym=8,color=127;,symsize=1.5
;usersym,xrect,yrect
;oplot,[yfit_lun],[xfit_lun],psym=8
;
;device,/close

;tnum = 1000.0
;tmin = min([time_sb1_1,time_sb1_2])
;tmax = max([time_sb1_1,time_sb1_2])
;trange = tmax - tmin
;tmin = tmin - 0.05*trange
;tmax = tmax + 0.05*trange
;tstep = (tmax-tmin)/tnum
;
;tarr = findgen(tnum)*tstep + tmin
;
;calc_sb1fit, EL_sb1_1, tarr, V1mod
;
;vmax = max([max(V1mod),max(V1_sb1_1),max(V1_sb1_2)])
;vmin = min([min(V1mod),min(V1_sb1_1),min(V1_sb1_2)])
;vrange = tmax - tmin
;vmin = vmin - 0.05*vrange
;vmax = vmax + 0.05*vrange


;set_plot,'ps'
;device, /Color, Bits_per_pixel=8, filename='temp_sb.eps',xsize=12,ysize=10,/encap

;toff = 50000.0d               ; RJD offset
;tlabel='JD - 2450000 (days)'
;toff = 0.0d                     ; no offset
;tlabel='Time'


;ploterror,time_sb1_1-toff,V1_sb1_1,dV1_sb1_1,psym=2,yrange=[vmin,vmax],xrange=[tmin,tmax]-toff,/nodata, $
;     xtitle=tlabel,ytitle='RV (km/s)'
;usersym, frac*cos(Z), frac*sin(Z),/fill
;oplot,time_sb1_1-toff,V1_sb1_1,psym=8,color=3
;usersym,xrect,yrect,/fill
;oploterror,time_sb1_2-toff,V1_sb1_2 - (Vsys2 - Vsys1),dV1_sb1_2,psym=8,/nodata
;oplot,time_sb1_2-toff,V1_sb1_2 - (Vsys2 - Vsys1),psym=8,color=1
;oplot,tarr-toff,V1mod

;oplot,time_sb1_2,V1_f_sb1_2 - (Vsys2 - Vsys1),psym=2,color=0

;device,/close

;set_plot,'x'

end
