pro auto_simple_properr,data_file

; Calculator for propagating separation uncertainty into PA
; Assumes equal uncertainties in RA and DEC
;
; works on data file input 
; (see simple_properr.pro for single observation input)
;
; Prompted input:
;	separation
;       error in separation
;       position angle

; Read in data points from data_file

num=10000

temp1 = 0d
temp2 = 0d
temp3 = 0d      ; temporary variables to read data from file
temp4 = 0d
temp5 = 0d

time = dblarr(num)
PA = dblarr(num)
sep = dblarr(num)
dPA = dblarr(num)
dsep = dblarr(num)

openr,1,data_file

i = 0
while not EOF(1) do begin
        readf, 1, temp1, temp2, temp3, temp4, temp5
        time(i) = temp1
        PA(i) = temp2
        sep(i) = temp4
        dsep(i) = temp5
        i = i + 1
endwhile
close,1
num=i
time = time(0:num-1)
PA = PA(0:num-1)
dPA = dPA(0:num-1)
sep = sep(0:num-1)
dsep = dsep(0:num-1)

; set x and y uncertainties equal to separation uncertainty
; (equal uncertainties in x and y)

dx = dsep
dy = dsep

x = sep * cos(PA*!dpi/180.0)	; x coordinate
y = sep * sin(PA*!dpi/180.0)	; y coordinate

; propagate uncertainties:
; sep = sqrt(dx^2 + dy^2)
; PA = atan(y,x)

dsep = sqrt((x*dx)^2 +(y*dy)^2)/sep

dPA  = sqrt((dx*y/x^2)^2 + (dy/x)^2)*(cos(PA*!dpi/180.0))^2

dPA = dPA*180.0/!dpi

openw,1,'temp_data'

for i=0, num-1 do begin

    print,'x:', x(i), dx(i)
    print,'y:', y(i), dy(i)
    print,'sep:', sep(i), dsep(i)
    print,'PA:', PA(i), dPA(i)

    printf,1,format='(f9.4,f8.3,f7.3,f8.3,f5.2)',time(i),PA(i),dPA(i),sep(i),dsep(i)

;    printf,1,format='(f9.4,f9.4,f8.4,f9.4,f8.4)', $
;      time(i), PA(i), dPA(i), sep(i), dsep(i)

endfor

close,1

end
