pro autorun_ephemeris, timefile

; read in file of dates and orbital parameters
; call AUTO_EPHERIS.PRO to compute RAsep and DECsep
;
; auto_ephemeris, EL, time, RAsep, DECsep, noprint=noprint

frac=1.0

period = 0d
Tperi = 0d
ecc = 0d
major = 0d
inc = 0d
W_cap = 0d
w_low = 0d

; Obtain initial values for P,T,e,a,i,W,w

print,"Enter P T e a i W w (period, time of periastron passage, eccentricity):"
read, period, Tperi, ecc, major, inc, W_cap, w_low

;convert angles from degrees to radians

inc = inc*!dpi/180.0
W_cap = W_cap*!dpi/180.0
w_low = w_low*!dpi/180.0

EL = [period, Tperi, ecc, major, inc, W_cap, w_low]


num=1000
time = dblarr(num)
temp=0.0d
openr,1,timefile
i = 0
while not EOF(1) do begin
    readf, 1, temp
    time(i) = temp
    i = i + 1
endwhile
close,1
num = i
time = time(0:num-1)


calc_vbfit, EL, time, PA, sep

xarr = sep*cos(PA)      ; x coordinate
yarr = sep*sin(PA)      ; y coordinate

print, "Period (years):", period
print, "Date PA sep:"

;for i=0,num-1 do print,time(i),PA(i)*180d/!dpi,1.0,sep(i),2.0
for i=0,num-1 do print,format='(f10.4,f8.3,f8.3)',time(i),PA(i)*180d/!dpi,sep(i)
;for i=0,num-1 do print,format='(f9.4,f8.2,f8.2)',time(i),PA(i)*180d/!dpi,sep(i)
;for i=0,num-1 do print,format='(f9.3,f8.2,f8.2)',time(i),PA(i)*180d/!dpi,sep(i)


; Define user symbol to be closed circle
; Make a vector of 16 points, Z[i] = 2pi/16:
Z = findgen(17) * (!pi*2/16.)

;Define the symbol to be a unit circle with 16 points
usersym, frac*cos(Z), frac*sin(Z), /fill

print, "Do you want to save plot as a postscript file?  (Type yes or no):"
pans = ""
read,pans
; Set plotting device to ps if answer is yes
if (pans eq "yes") then begin
        set_plot, 'ps'
        device, /Color, Bits_per_pixel=8, filename='temp.ps' 
endif

                maxx = max(-yarr)
                minx = min(-yarr)
                maxy = max(xarr)
                miny = min(xarr)

                ex = 0d
                print, "x: max min ", maxx,minx
                print, "y: max min ", maxy,miny
                print, "By what value would you like to extend x and y axes?"
                read, ex

plot, -yarr, xarr, psym=8, XSTYLE=1, YSTYLE=1, ISOTROPIC=1, $
        xrange=[minx-ex,maxx+ex], yrange=[miny-ex,maxy+ex], $
        xtitle="E-W sep (mas)", ytitle="N-S sep (mas)"

;plabel = findgen(num) + 1
;plabel = string(plabel)
;plabel = strcompress(plabel,/remove_all)
;plabel = string(format='(a2)',plabel)
;xyouts, -yarr, xarr, plabel

; set plotting device back to terminal if previously saving to ps file
if (pans eq "yes") then begin 
        device, /close
        set_plot, 'x'
endif




end
