pro calc_AFBG, time, xarr, dx, yarr, dy, period, Tperi, ecc, $
	       A_cap, F_cap, B_cap, G_cap, xfit, yfit

; Calculate the Thiele-Innes elements
;
; Calls the following routines:
;     calc_Ei.pro
;     linfith.pro

; Determine the eccentric anomalies Ei: 
; (Ei: array to hold the eccentric anomaly)

calc_Ei, time, period, Tperi, ecc, Ei
	
; Normalized rectangular coordinates Xi & Yi:
;	Xi = cos(Ei) - e
;	Yi = sqrt(1 - e^2)*sin(Ei)

; Xi and Yi are both dblarr(num)

Xi = cos(Ei) - ecc
Yi = sqrt(1 - ecc^2)*sin(Ei)

; print,"Xi:",Xi
; print,"Yi:",Yi

; Four Thiele-Innes elements determined from least 
; squares solution of equations:
;	xi = AXi + FYi
;	yi = BXi + GYi
; Calculate geometric elements a("),i,Omega,omega 
; from (A,F,B,G)

linfith, Xi,Yi,xarr,dx,A_cap,F_cap
linfith, Xi,Yi,yarr,dy,B_cap,G_cap

; Determine fit points

xfit = A_cap*Xi + F_cap*Yi	;fitted points
yfit = B_cap*Xi + G_cap*Yi

end
