pro calc_Ei, time, period, Tperi, ecc, Ei

; Determine the eccentric anomalies Ei: 
;     mu(ti - T) = Ei - esin(Ei)  ... Kepler's Equation
;     where mu = 360/P = 2*pi/P
; Solve this transcendental equation through an 
; iterative procedure.
; Use SOLVE_TRANS.PRO

; array to hold Ei's (the eccentric anomaly)

num = n_elements(time)

Ei = dblarr(num) 

mu = 2*!dpi/period

for i=0, num-1 do begin

	; Mi: mean anomoly - increases uniformly with time
	; zero at time Tperi, 2Pi each orbit

	Mi = mu*(time(i) - Tperi) 

	; reduce to same epoch

	Mi = 2*!dpi*((time(i) - Tperi)/period $	
		- fix((time(i) - Tperi)/period))

	; keep Mi between 0 and 2Pi

	if (Mi lt 0.0) then Mi = Mi + 2*!dpi
	if (Mi gt 2*!dpi) then Mi = Mi - 2*!dpi

	solve_trans,ecc,Mi,Eit

	; keep Ei between 0 and 2Pi

	if (Eit lt 0.0) then Eit = Eit + 2*!dpi
	if (Eit gt 2*!dpi) then Eit = Eit - 2*!dpi

	Ei(i) = Eit

endfor

end
