pro calc_sb1fit, ELarr, time, V1_f, flag_wa = flag_wa

; Compute model velocities for SB1
; Input parameters:
;    ELarr: array of orbital parameters
;           [period,Tperi,ecc,K1,omega,Vsys]
;    time:  array containing times for which to compute velocities
;    sec: conversion factor for period
;    km: conversion factor for velocities
; Output parameters:
;    V1_f: array of model velocities
;
; 31 May 2006: Save unmodified program as version 1
; 31 May 2006: SB1 parameters in terms of K1
;              (as opposed to a1sini)

; Define orbital element parameters

period = ELarr(0)
Tperi = ELarr(1)
ecc = ELarr(2)
K1 = ELarr(3)
omega = ELarr(4)
Vsys = ELarr(5)

; If flag_wa is set then define omega as omega_B
; omega_A = omega_B + 180.0
; keyword_set returns True (1) if psf_name is defined, False (0) if undefined
if (keyword_set(flag_wa)) then omega = omega + !dpi

num = n_elements(time)

; Determine the eccentric anomalies Ei: 
; (Ei: array to the eccentric anomaly)

calc_Ei, time, period, Tperi, ecc, Ei

; Determine true anomalies:

nu = 2*atan(sqrt((1+ecc)/(1-ecc))*tan(Ei/2.0))

; check sign of true anomaly

cosnu = cos(nu)
sinnu = sin(nu)

actualcosnu = (cos(Ei) - ecc)/(1 - ecc*cos(Ei))
actualsinnu = sqrt(1 -ecc^2)*sin(Ei)/(1-ecc*cos(Ei))

for i=0, num-1 do begin
    if (cosnu(i)/abs(cosnu(i)) ne actualcosnu(i)/abs(actualcosnu(i))) and $
       (sinnu(i)/abs(sinnu(i)) ne actualsinnu(i)/abs(actualsinnu(i))) then $
       nu(i) = nu(i) + !dpi
;    print,sin(nu(i)), actualsinnu(i), cos(nu(i)),actualcosnu(i)
;    Strange!  It seems that nu is ALWAYS in the proper quadrant ???
endfor

; Determine (V1_f) velocities from orbital elements and times of 
; observations

V1_f = K1*(ecc*cos(omega) + cos(nu + omega)) + Vsys

end
