pro calc_sb2fit, ELarr, time, V1_f, V2_f

; Compute model velocities for SB2
; Input parameters:
;    ELarr: array of orbital parameters
;           [period,Tperi,ecc,K1,K2,omega,Vsys]
;    time:  array containing times for which to compute velocities
;    sec: conversion factor for period
;    km: conversion factor for velocities
; Output parameters:
;    V1_f: array of model velocities for primary
;    V2_f: array of model velocities for secondary
;
; 31 May 2006: Save unmodified program as version 1
; 31 May 2006: SB2 parameters in terms of K1 and K2
;              (as opposed to a1sini and a2sini)

; Define orbital element parameters

period = ELarr(0)
Tperi = ELarr(1)
ecc = ELarr(2)
K1 = ELarr(3)
K2 = ELarr(4)
omega = ELarr(5)
Vsys = ELarr(6)

num = n_elements(time)

; Determine the eccentric anomalies Ei: 
; (Ei: array to the eccentric anomaly)

calc_Ei, time, period, Tperi, ecc, Ei

; Determine true anomalies:

nu = 2*atan(sqrt((1+ecc)/(1-ecc))*tan(Ei/2.0))

; check sign of true anomaly

cosnu = cos(nu)
sinnu = sin(nu)

actualcosnu = (cos(Ei) - ecc)/(1 - ecc*cos(Ei))
actualsinnu = sqrt(1 -ecc^2)*sin(Ei)/(1-ecc*cos(Ei))

for i=0, num-1 do begin
;   print,'Before/after:'
;   print,sin(nu(i)), actualsinnu(i), cos(nu(i)),actualcosnu(i)
    if (cosnu(i)/abs(cosnu(i)) ne actualcosnu(i)/abs(actualcosnu(i))) and $
       (sinnu(i)/abs(sinnu(i)) ne actualsinnu(i)/abs(actualsinnu(i))) then $
       nu(i) = nu(i) + !dpi
;    print,sin(nu(i)), actualsinnu(i), cos(nu(i)),actualcosnu(i)
;    Strange!  It seems that nu is ALWAYS in the proper quadrant ???
endfor

; Determine (V1_f, V2_f) velocities from orbital elements and times of 
; observations

V1_f = K1*(ecc*cos(omega) + cos(nu + omega)) + Vsys

V2_f = -K2*(ecc*cos(omega) + cos(nu + omega)) + Vsys

end
