pro compute_err

; Sigma Ori - Simultaneous SB2+VB Fit - Use Simon-Diaz et al. (2015) + CTIO RVs
; Elliptical uncertainties - vb_sigori_mirc_covar_avg_wavecor_fiterr_scale
; Apply wavelength calibration correction to MIRC data - fitting errors
P   = 143.20015d
dP  = 0.0024437233d
e   = 0.77895691d
de  = 0.00042795493d
K1  = 72.034870d
dK1 = 0.25459830d
K2  = 95.528362d
dK2 = 0.21526755d
i   = 56.377563d  *!dpi/180.0
di  = 0.084583038d *!dpi/180.0
a   = 4.2859811d-3 ; a in "
da  = sqrt(0.0030569129^2 + 0.0107^2)*1d-3 ; a in "

; Sigma Ori - Simultaneous SB2+VB Fit - Use Simon-Diaz et al. (2015) + CTIO RVs
; Elliptical uncertainties - vb_sigori_mirc_covar_avg_scale 
;P   = 143.19968d
;dP  = 0.0024693120d
;e   = 0.77796054d
;de  = 0.00058330851d
;K1  = 72.007709d
;dK1 = 0.25450344d
;K2  = 95.423626d
;dK2 = 0.21708286d
;i   = 56.489938d  *!dpi/180.0
;di  = 0.12516180d *!dpi/180.0
;a   = 4.2833836d-3 ; a in "
;da  = 0.0045044402d-3 ; a in "

;K1  = 65.18
;K2  = 99.39

; Sigma Ori - Simultaneous SB2+VB Fit - Use Simon-Diaz et al. (2015) RVs
; Elliptical uncertainties - vb_sigori_mirc_covar_avg_scale 
;P   = 143.19930d
;dP  = 0.0034234276d
;e   = 0.77787551d
;de  = 0.00058277759d
;K1  = 72.373668d
;dK1 = 0.24085550d
;K2  = 95.044796d
;dK2 = 0.20956579d
;i   = 56.504395d  *!dpi/180.0
;di  = 0.12131589d *!dpi/180.0
;a   = 4.2832378d-3 ; a in "
;da  = 0.0042855226d-3 ; a in "

; Sigma Ori - Simultaneous SB2+VB Fit - Use Simon-Diaz et al. (2015) RVs
; Elliptical uncertainties - vb_sigori_mirc_covar_split_scale 
;P   = 143.19901d
;dP  = 0.0033867180d
;e   = 0.77798247d
;de  = 0.00058346035d
;K1  = 72.399416d
;dK1 = 0.23875977d
;K2  = 95.055897d
;dK2 = 0.20760879d
;i   = 56.456263d  *!dpi/180.0
;di  = 0.12774994d *!dpi/180.0
;a   = 4.2832721d-3 ; a in "
;da  = 0.0042936808d-3 ; a in "


;dP = 0.0
;de = 0.0
;da = 0.0
;dK1=0.0
;dK2 = 0.0

; K in km/s, P in days, M in Msun, a in AU

;M1sini3 = 1.04099d-7*P*(K1 + K2)^2*K2*(1.0 - e^2)^1.5
;M2sini3 = 1.04099d-7*P*(K1 + K2)^2*K1*(1.0 - e^2)^1.5
;dM1sini3 = M1sini3*sqrt(4.0*dK1^2/(K1 + K2)^2 + (2.0/(K1 + K2) + 1.0/K2)^2*dK2 + dP^2/P^2 + 9.0*e^2*de^2/(1- e^2)^2)
;dM2sini3 = M2sini3*sqrt((2.0/(K1 + K2) + 1.0/K1)^2*dK1 + 4.0*dK2^2/(K1 + K2)^2 + dP^2/P^2 + 9.0*e^2*de^2/(1- e^2)^2)
;print,'M1sini3:',M1sini3,dM1sini3
;print,'M2sini3:',M2sini3,dM2sini3

; Why are these coefficients different from AQ???
;M1 = 1.04099d-7*P*(K1 + K2)^2*K2*(1.0 - e^2)^1.5/sin(i)^3
;M2 = 1.04099d-7*P*(K1 + K2)^2*K1*(1.0 - e^2)^1.5/sin(i)^3

; AQ coefficients
M1 = 1.036d-7*P*(K1 + K2)^2*K2*(1.0 - e^2)^1.5/sin(i)^3
M2 = 1.036d-7*P*(K1 + K2)^2*K1*(1.0 - e^2)^1.5/sin(i)^3

;dM1 = M1*sqrt(4.0*dK1^2/(K1 + K2)^2 + (2.0/(K1 + K2) + 1.0/K2)^2*dK2 + dP^2/P^2 + 9.0*e^2*de^2/(1- e^2)^2 + 9.0*di^2*cos(i)^2/sin(i)^2)
;
;dM2 = M2*sqrt((2.0/(K1 + K2) + 1.0/K1)^2*dK1 + 4.0*dK2^2/(K1 + K2)^2 + dP^2/P^2 + 9.0*e^2*de^2/(1- e^2)^2 + 9.0*di^2*cos(i)^2/sin(i)^2)

dM1 = M1*sqrt(4.0*dK1^2/(K1 + K2)^2 + (2.0/(K1 + K2) + 1.0/K2)^2*dK2^2 + dP^2/P^2 + 9.0*e^2*de^2/(1- e^2)^2 + 9.0*di^2*cos(i)^2/sin(i)^2)

dM2 = M2*sqrt((2.0/(K1 + K2) + 1.0/K1)^2*dK1^2 + 4.0*dK2^2/(K1 + K2)^2 + dP^2/P^2 + 9.0*e^2*de^2/(1- e^2)^2 + 9.0*di^2*cos(i)^2/sin(i)^2)

print,'M1: ', M1, dM1
print,'M2: ', M2, dM2

;a1 = (5.77926d-4/(2.0*!dpi))*P*K1*sqrt(1 - e^2)/sin(i)
;a2 = (5.77926d-4/(2.0*!dpi))*P*K2*sqrt(1 - e^2)/sin(i)

a1 = 0.01375d*P*K1*sqrt(1 - e^2)/sin(i) *1d9 /1.4959787066d11
a2 = 0.01375d*P*K2*sqrt(1 - e^2)/sin(i) *1d9 /1.4959787066d11

da1 = a1*sqrt((dP/P)^2 + (dK1/K1)^2 + (e*de/(1.0 - e^2))^2 + (di*cos(i)/sin(i))^2)

da2 = a2*sqrt((dP/P)^2 + (dK2/K2)^2 + (e*de/(1.0 - e^2))^2 + (di*cos(i)/sin(i))^2)

print,'a1: ', a1, da1
print,'a2: ', a2, da2

parallax = a/(a1 + a2)

dpar = parallax*sqrt((da/a)^2 + da1^2/(a1 + a2)^2 + da2^2/(a1 + a2)^2)

dist = 1.0/parallax   ; (a1 + a2)/a

dd = sqrt(da^2*(a1 + a2)^2/a^4 + (da1/a)^2 + (da2/a)^2)

print,'distance (pc): ', dist, dd
print,'Parallax (mas): ', parallax*1000.0, dpar*1000.0

end
