pro convert_mjd_bjd, data_file, RA=RA, DEC=DEC

; Convert Modified Julian Date (MJD) to Barycentric Julian Date (BJD).
;
; Read in MJD dates.  Convert RJD to BJD.  Output BJD to screen.
; RA = [HH,MM,SS]
; DEC = [DD,MM,SS]

close,1

; Read in data points from data_file

num = 10000
tempstring = ' '

mjd = dblarr(num)

openr,1,data_file
i = 0
while not EOF(1) do begin
    readf, 1, tempstring
    sepvalues = strsplit(tempstring,/extract)
    mjd(i) = double(sepvalues(0))
    i = i + 1
endwhile
close,1
num = i
mjd = mjd(0:num-1)

RJD = MJD + 0.5

RA_hrs = RA(0) + RA(1)/60.0 + RA(2)/60.0/60.0
RA_deg = RA_hrs*180.0/12.0

DEC_deg = DEC(0) + DEC(1)/60.0 + DEC(2)/60.0/60.0

; Heliocentric JD:
hjd = helio_jd(rjd,RA_deg,DEC_deg)
bjd = barycen(mjd,RA_deg,DEC_deg,ephemfile='/home/schaefer/idl/orbfit_lib/JPLEPH.405')

print,' MJD        HJD        BJD'

for i=0,num-1 do begin

   print,format='(f11.4,f11.4,f11.4)',mjd(i),hjd(i),bjd(i)

endfor

print,'RA:  ',RA_deg
print,'DEC: ',DEC_deg


end

