pro convert_mjd_hjd, data_file, RA=RA, DEC=DEC

; Convert Modified Julian Date (MJD) to Heliocentric Julian Date (HJD).
;
; Read in MJD dates.  Convert RJD to HJD.  Output HJD to screen.
; RA = [HH,MM,SS]
; DEC = [DD,MM,SS]

close,1

; Read in data points from data_file

num = 10000
tempstring = ' '

mjd = dblarr(num)

openr,1,data_file
i = 0
while not EOF(1) do begin
    readf, 1, tempstring
    sepvalues = strsplit(tempstring,/extract)
    mjd(i) = double(sepvalues(0))
    i = i + 1
endwhile
close,1
num = i
mjd = mjd(0:num-1)

RJD = MJD + 0.5

RA_hrs = RA(0) + RA(1)/60.0 + RA(2)/60.0/60.0
RA_deg = RA_hrs*180.0/12.0

DEC_deg = DEC(0) + DEC(1)/60.0 + DEC(2)/60.0/60.0

; Heliocentric JD:
hjd = helio_jd(rjd,RA_deg,DEC_deg)

print,'HJD values:'

for i=0,num-1 do begin

   print,format='(f10.4)',hjd(i)

endfor

print,'RA:  ',RA_deg
print,'DEC: ',DEC_deg


end

