pro convert_radec_seppa, data_file

; Input file:  time sepRA err sepDEC err
; Output file: time PA    err sep    err

close,1

; Read in measurements from data file

temp1 = 0d
temp2 = 0d
temp3 = 0d	; temporary variables to read data from file
temp4 = 0d
temp5 = 0d

num = 1000

time = dblarr(num)
sepRA = dblarr(num)
dsepRA = dblarr(num)
sepDEC = dblarr(num)
dsepDEC = dblarr(num)

openr,1,data_file
i = 0
while not EOF(1) do begin
    readf, 1, temp1, temp2, temp3, temp4, temp5
    time(i) = temp1
    sepRA(i) = temp2
    dsepRA(i) = temp3
    sepDEC(i) = temp4
    dsepDEC(i) = temp5
    i = i + 1
endwhile
close,1
num = i
time = time(0:num-1)
sepRA = sepRA(0:num-1)
dsepRA = dsepRA(0:num-1)
sepDEC = sepDEC(0:num-1)
dsepDEC = dsepDEC(0:num-1)



; RAsep  = sep*sin(PA)
; DECsep = sep*cos(PA)

sep = sqrt(sepRA^2 + sepDEC^2)
PA = atan(sepRA,sepDEC)*180.0/!dpi

; flip orientation by 180 ambiguity
;PA = PA + 180.0

for i=0, num-1 do begin

   if (PA(i) lt 0.0) then PA(i) = PA(i) + 360.0
   if (PA(i) ge 360.0) then PA(i) = PA(i) - 360.0

endfor

dsep = sqrt((sepRA*dsepRA)^2  + (sepDEC*dsepDEC)^2)/sep

dPA  = 180.0/!dpi*sqrt((dsepDEC*sepRA/sepDEC^2)^2 + (dsepRA/sepDEC)^2)*(cos(PA*!dpi/180.0))^2

;for i=0,num-1 do print,format='(f10.4,f8.2,f7.2,f7.2,f5.2)',time(i),PA(i),dPA(i),sep(i),dsep(i)
for i=0,num-1 do print,format='(f10.4,f8.2,f7.2,f10.5,f8.5)',time(i),PA(i),dPA(i),sep(i),dsep(i)

chi2sep = total((sep/dsep)^2)
chi2xy = total((sepRA/dsepRA)^2 + (sepDEC/dsepDEC)^2)

print, "chi2(sep):", chi2sep
print, "chi2red:", chi2sep/(2.0*num)
print, "chi2(x,y):", chi2xy
print, "chi2red:", chi2xy/(2.0*num)


end

