pro convert_rjd_hjd, data_file, num, RA=RA, DEC=DEC

; Read in SB2 RV file.  Convert RJD to HJD.  Output RV file again.
; RA = [HH,MM,SS]
; DEC = [DD,MM,SS]

close,1

; Read in data points from data_file

temp1 = 0d
temp2 = 0d
temp3 = 0d	; temporary variables to read data from file
temp4 = 0d
temp5 = 0d

time = dblarr(num)
V1 = dblarr(num)
V2 = dblarr(num)
dV1 = dblarr(num)
dV2 = dblarr(num)

openr,1,data_file

for i=0, num-1 do begin

	readf, 1, temp1, temp2, temp3, temp4, temp5

	time(i) = temp1
	V1(i) = temp2
	dV1(i) = temp3
	V2(i) = temp4	
	dV2(i) = temp5
	
endfor

close,1

RJD = time

RA_hrs = RA(0) + RA(1)/60.0 + RA(2)/60.0/60.0
RA_deg = RA_hrs*180.0/12.0

DEC_deg = DEC(0) + DEC(1)/60.0 + DEC(2)/60.0/60.0

; Heliocentric JD:
hjd = helio_jd(rjd,RA_deg,DEC_deg)

for i=0,num-1 do begin

   print,format='(f9.3,f9.2,f7.2,f9.2,f7.2)',hjd(i),V1(i),dV1(i),V2(i),dV2(i)

endfor

print,'RA:  ',RA_deg
print,'DEC: ',DEC_deg

; Compute UT Dates

openw,1,'temp_utdate'

JD = rjd + 2400000.0d

label_month = ['','Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec']

for i=0,num-1 do begin

   daycnv, jd(i), yr, mn, day, hr

   printf,1,format='(i4,a4,i3,f6.1)',yr,label_month(mn),day,hr

endfor

close,1


end

