pro convert_year, filename

; Given EXPTIME MM DD YY HH MM SS
; Compute besselian and julian years


num=1000

; input file format:    exp. time (sec)   month   day   year   hh   mm  ss
;       date is starting time, hours in 24-hour time
;
; procedure - calculate midpoint of exposure in decimal years and Julian date
; output file format:    JD   decimal year
;
; JD = RJD + 2400000     ; reduced julian date - what juldate.pro spits out
; JD = MJD + 2400000.5   ; modified julian date - what astronomers use

expt = 0d
month = 0d
day = 0d
year = 0d
hour = 0d
min = 0d
sec = 0d
JD = 0d

; read input file

openr,1,filename

outfile = filename + ".year"

openw,2,outfile

printf,2,'MM DD YY HH MM SS RJD MJD JY BY'

while not EOF(1) do begin

   readf, 1, expt, month, day, year, hour, min, sec

   ; find mid point of exposure

   sec = sec + (expt/2d)

   ; convert seconds into minutes

   min_sum = min + (sec/60d)

   ; convert to Julian date (juldate.pro in idl astro library)

   juldate, [year, month, day, hour, min_sum], JD

   ; juldate.pro provides reduced JD:   JD = RJD+2400000

   ; JD = RJD + 2400000     ; reduced julian date - what juldate.pro spits out
   ; JD = MJD + 2400000.5   ; modified julian date - what astronomers use
   ; RJD = JD - 2,400,000
   ; MJD = JD - 2,400,000.5

   MJD = JD - 0.5

         ; 2400000
   J2000 = 2451545.0
   B1900 = 2415020.313


   jyear = 2000.0 + (JD - 51545.0)/365.25d

   ; byear = 1900.0 + (JD - 15020.313)/365.242198781d

   ; Lieske, J. H. 1979, A&A, 73, 282 gives this as:
   byear = 1900.0 + (JD - 15020.31352d)/365.242198781d

   ; reduce hh:mm:ss (exptime was added to seconds)
   ss = sec
   mm = min
   hh = hour
   while (ss ge 60.0) do begin
      ss = ss - 60.0
      mm = mm + 1.0
   endwhile
   while (mm ge 60.0) do begin
      mm = mm - 60.0
      hh = hh + 1.0
   endwhile

   printf, 2, format='(i3,i3,i5,i3,i3,i3,d10.3,d10.3,d10.4,d10.4)', month, day, year, hh, mm, ss, JD, MJD, jyear, byear

endwhile

close,1
close,2

end

