pro create_ellipse, x, y, num, major=major, minor=minor, xcent=xcent, ycent=ycent, theta=theta, showplot=showplot

; Create x,y arrays containing coordinates of ellipse
; num: number of coordinates
;
; Call: create_ellipse, x, y, major=major [, minor=minor, xcent=xcent,
; ycent=ycent, theta=theta, /showplot]
;
; Equation for an ellipse:
; (x/a)^2 + (y/b)^2 = 1
;
; Rotate ellipse:
; x' = x*cos(theta) - y*sin(theta)
; y' = x*sin(theta) + y*cos(theta)
;
; Shift rotated ellipse:
; x' = x' + xcent
; y' = y' + ycent
;
; NOTE: center coordinates (x0,y0) are given in x,y reference frame,
;       not the rotated reference frame
;
; NOTE: theta is given in degrees
;
; Began 2015Sep02 - GHS

if (keyword_set(minor) ne 1) then minor = major

if (keyword_set(xcent) ne 1) then xcent = 0.0

if (keyword_set(ycent) ne 1) then ycent = 0.0

if (keyword_set(theta) ne 1) then theta = 0.0

nhalf = num/2.0

x = dblarr(num+2)
y = dblarr(num+2)

xstep = 2*major/nhalf

xi = -major
count = 0

; Top half of ellipse
for i=0, nhalf do begin
   if (abs(xi) le major) then begin
      x(count) = xi
      y(count) = minor * sqrt(1.0 - (xi/major)^2)
      count = count+1
   endif
   xi = xi + xstep
endfor
if (count le nhalf) then begin
   xi = major
   x(count) = xi
   y(count) = minor * sqrt(1.0 - (xi/major)^2)
   count = count+1
endif

; Bottom half of ellipse
xi = major
for i=0, nhalf do begin
   if (abs(xi) le major) then begin
      x(count) = xi
      y(count) = -minor * sqrt(1.0 - (xi/major)^2)
      count = count+1
   endif
   xi = xi - xstep
endfor
if (count le num+1) then begin
   xi = -major
   x(count) = xi
   y(count) = - minor * sqrt(1.0 - (xi/major)^2)
   count = count+1
endif
x = x(0:count-1)
y = y(0:count-1)

; Now rotate the x and y coordinates by the position angle:
xp = x*cos(theta*!dpi/180.0) - y*sin(theta*!dpi/180.0)
yp = x*sin(theta*!dpi/180.0) + y*cos(theta*!dpi/180.0)

x = xp + xcent
y = yp + ycent

if (keyword_set(showplot)) then $
   plot,x,y,/isotropic,xrange=[-1.1*major,1.1*major],yrange=[-1.1*major,1.1*major]

end
