pro create_histo, xmin, xrange, xstep, data, xbins, h_xarr

; INPUT
; xmid: best fit solution for separation/flux fraction
; xrange: search range   (xmid-xrange:xmid+xrange)
; xstep: step size through search range
; data: array of solutions found in grid that are within 1 chi^2 of best fit
; OUTPUT
; xbins: array of all searched separations/flux fractions
; h_xarr: array to contain the number of values at each step

xnum = round(xrange/double(xstep)) + 3 ; number of separation steps searched

xbins = dblarr(xnum)	; array of all possible separations searched
h_xarr = intarr(xnum)	; array to contain the number of values at each step

x = xmin - xstep

for i=0, xnum-1 do begin

	xbins(i) = x
	x = x + xstep

endfor

datanum = n_elements(data)

for i=long(0), datanum-1 do begin

	for j=long(0), xnum-1 do begin

	if (round(data(i)/xstep)*xstep eq round(xbins(j)/xstep)*xstep) $ 
			then h_xarr(j) = h_xarr(j) + 1

	endfor
endfor

end

