pro draw_circle, a, b, R

print,a,b,R

; This program draws a circle following the equation:
; 	(x-a)^2 + (y-b)^2 - R^2 = 0 
; where (a,b) is the center of the circle and R is the radius.

x1 = dblarr(101)
y1p = dblarr(101)
y1m = dblarr(101)

xroot1 = a-R
xroot2 = a+R

yroot1 = b-R
yroot2 = b+R

print, xroot1, xroot2
print,yroot1,yroot1

xstep = (xroot2 - xroot1)/100d		; xstep = 2a/100

x1(0) = xroot1

for i=0, 100 do begin

	argx = R^2 - (x1(i)-a)^2

	if (abs(argx) lt 1d-10) then argx=0d

	y1p(i) = b + sqrt(argx)
	y1m(i) = b - sqrt(argx)

	if (i lt 100) then begin
		x1(i+1) = x1(i) + xstep
	endif

endfor

plot_name = ""
print,"Title of plot:"
read, plot_name

print, "xmax, xmin:", xroot1, xroot2
print, "ymax, ymin:", yroot1, yroot2
print, "Type in single value to be used as range for axes:"
read, rvalue

plot, x1, y1p, xtitle="RA", ytitle="DEC", title=plot_name, $
	xrange=[-rvalue,+rvalue], yrange=[-rvalue,+rvalue], $
	 XSTYLE=1, YSTYLE=1, ISOTROPIC=1
oplot, x1, y1m

end
