pro draw_ellipse, A,B,C,D,E,F

print,A,B,C,D,E,F

; This program draws an ellipse following the equation:
; 	Ax^2 + Bxy + Cy^2 + Dx + Ey + F = 0 

x1 = dblarr(101)
y1p = dblarr(101)
y1m = dblarr(101)

xroot1 = (-(2*B*E - 4*C*D) - sqrt((2*B*E - 4*C*D)^2 $
		- 4*(B^2 - 4*A*C)*(E^2 - 4*C*F)))/(2*(B^2 - 4*A*C))
xroot2 = (-(2*B*E - 4*C*D) + sqrt((2*B*E - 4*C*D)^2 $
		- 4*(B^2 - 4*A*C)*(E^2 - 4*C*F)))/(2*(B^2 - 4*A*C))

yroot1 = (-(2*B*D - 4*A*E) - sqrt((2*B*D - 4*A*E)^2 $
		- 4*(B^2 - 4*A*C)*(D^2 - 4*A*F)))/(2*(B^2 - 4*A*C))
yroot2 = (-(2*B*D - 4*A*E) + sqrt((2*B*D - 4*A*E)^2 $
		- 4*(B^2 - 4*A*C)*(D^2 - 4*A*F)))/(2*(B^2 - 4*A*C))

print, xroot1, xroot2
print,yroot1,yroot1

xstep = (xroot2 - xroot1)/100d		; xstep = 2a/100

x1(0) = xroot1

for i=0, 100 do begin

	argx = (B*x1(i) + E)^2 - 4*C*(A*x1(i)^2 + D*x1(i) + F)

	if (abs(argx) lt 1d-10) then argx=0d

	y1p(i) = (-(B*x1(i) + E) + sqrt(argx))/(2*C)
	y1m(i) = (-(B*x1(i) + E) - sqrt(argx))/(2*C)

	if (i lt 100) then begin
		x1(i+1) = x1(i) + xstep
	endif

endfor

plot_name = ""
print,"Title of plot:"
read, plot_name

print, "xmax, xmin:", xroot1, xroot2
print, "ymax, ymin:", yroot1, yroot2
print, "Type in single value to be used as range for axes:"
read, rvalue

plot, x1, y1p, xtitle="RA", ytitle="DEC", title=plot_name, $
	xrange=[-rvalue,+rvalue], yrange=[-rvalue,+rvalue], $
	 XSTYLE=1, YSTYLE=1, ISOTROPIC=1
oplot, x1, y1m

end
