; fit_circle

; Fit an ellipse to five data points.
; Five data points of theta, rho are contained in p1,...,p5, each 2-D arrays
; Points are fit to equation:
;	Ax^2 + 2Hxy + By^2 + 2Gx + 2Fy + 1 = 0
; where x = - rho*sin(theta), y = rho*cos(theta).
; Coeffecients A-F are determined using Cramer's method.
; For an ellipse, 4H^2 - 4AB < 0

NUM = 5
index = num-1

;name = "DF Tau"
name = "ZZ Tau"
print, name

;p1 = [-7.4, 76.0]
;p2 = [-32.3, 84.4]
;p3 = [-54.0, 91.10]
;p4 = [-78.7, 97.0]
;p5 = [-96.0, 100.0]

;const = 5.50d4  ;constant of areas in mas^2 * degrees / year
;dconst = 0.71d4 ;error in constant of areas

;zzrev7
;p1 = [172.5, 36.0]	;1995.00
;p2 = [138.5, 43.0]	;1997.00 
;p3 = [122.2, 56.0]	;1998.50
;p4 = [112.4, 58.5]	;1999.75
;p5 = [105.1, 59.4]	;2000.75

;zzrev5
;p1 = [172.5, 36.0]
;p2 = [138.5, 43.0]
;p3 = [122.2, 56.0]
;p4 = [112.4, 58.5]
;p5 = [105.1, 59.4]

;zzrev_data
;p1 = [187.0, 36.0]
;p2 = [129.2, 50.6]
;p3 = [125.0, 55.0]
;p4 = [107.3, 59.7]
;p5 = [105.6, 58.5]

;zzrev8
p1 = [190.0, 33.0]	;1995.00
p2 = [140.0, 46.5]	;1997.00 
p3 = [122.0, 56.0]	;1998.50
p4 = [111.0, 58.5]	;1999.75
p5 = [97.5, 60.0]	;2000.75

const = 2.56d4  ;constant of areas in mas^2 * degrees / year
;dconst = 0.71d4 ;error in constant of areas

theta=[p1(0), p2(0), p3(0), p4(0), p5(0)]
rho=[p1(1), p2(1), p3(1), p4(1), p5(1)]

x = dblarr(num)
y = dblarr(num)
dx = dblarr(num)
dy = dblarr(num)
m0 = dblarr(num,num)
m1 = dblarr(num,num)
m2 = dblarr(num,num)
m3 = dblarr(num,num)
m4 = dblarr(num,num)
m5 = dblarr(num,num)

for i=0, index do begin

        x(i) = - rho(i) * sin(theta(i)*!dpi/180)
        y(i) = rho(i) * cos(theta(i)*!dpi/180)

        m0[i,*] = [x(i)^2, 2*x(i)*y(i), y(i)^2, 2*x(i), 2*y(i)]
        m1[i,*] = [-1d, 2*x(i)*y(i), y(i)^2, 2*x(i), 2*y(i)]
        m2[i,*] = [x(i)^2, -1d, y(i)^2, 2*x(i), 2*y(i)]
        m3[i,*] = [x(i)^2, 2*x(i)*y(i), -1d, 2*x(i), 2*y(i)]
        m4[i,*] = [x(i)^2, 2*x(i)*y(i), y(i)^2, -1d, 2*y(i)]
        m5[i,*] = [x(i)^2, 2*x(i)*y(i), y(i)^2, 2*x(i), -1d]

endfor

detm0 = determ(m0)
detm1 = determ(m1)
detm2 = determ(m2)
detm3 = determ(m3)
detm4 = determ(m4)
detm5 = determ(m5)

A = detm1/detm0
H = detm2/detm0
B = detm3/detm0
G = detm4/detm0
F = detm5/detm0

print, "theta: "
print, theta
print, "rho: "
print, rho
print, "const: ", const
print, "x: "
print, x
print, "y: "
print, y
print, "A H B G F: "
print, A,H,B,G,F

;discriminant:

dis = 4*H^2 - 4*A*B

print, "Discriminant (should be negative for an ellipse): "
print, dis

if dis le 0 then begin

; Rotate coordinate system so that major and minor axes of ellipse lie along
; the new coordinate axes.  Theta is the rotation angle, counterclockwise,
; with respect to the original frame.  (Angle is determined by setting the 
; cross-terms (x'y') in equation for ellipse to zero.)

	theta = atan(2*H/(A-B))/2

	print, "Rotation angle of coordinate system in degrees: "
	print, theta*180/!dpi

; Non-vanishing coefficients of equation for ellipse in rotated coordinate
; system: c1*x^2 + c2*x + c3*y^2 + c4*y + 1 = 0

	c1 = A*cos(theta)^2 + 2*H*sin(theta)*cos(theta) + B*sin(theta)^2
	c2 = 2*G*cos(theta) + 2*F*sin(theta)
	c3 = A*sin(theta)^2 - 2*H*sin(theta)*cos(theta) + B*cos(theta)^2
	c4 = -2*G*sin(theta) + 2*F*cos(theta)

	x_cent = -c2/(2*c1)
	y_cent = -c4/(2*c3)
	xmajor = sqrt((c3*c2^2 + c1*c4^2 - 4*c1*c3)/(4*c1^2*c3))
	yminor = sqrt((c3*c2^2 + c1*c4^2 - 4*c1*c3)/(4*c1*c3^2))

	print, "x_cent   y_cent: "
	print, x_cent, y_cent

	if (xmajor ge yminor) then begin

		print, "major axis along x-axis"
	
		major = xmajor
		minor = yminor
	endif

	if (xmajor lt yminor) then begin 
	
		print, "major axis along y-axis"
			
		major = yminor
		minor = xmajor
	endif

	print, "major   minor: "
	print, major, minor
	
; eccentricity

	ecc = sqrt(1 - (minor/major)^2)

	print, "Eccentricity: "
	print, ecc

; distance between center and foci (ae)

	foci = major*ecc

	print, "Distance between center and foci: "
	print, foci

endif
end
