; fit_circle

; Fit an ellipse to five data points.
; Five data points of theta, rho are contained in p1,...,p5, each 2-D arrays
; Points are fit to equation:
;	Ax^2 + 2Hxy + By^2 + 2Gx + 2Fy + 1 = 0
; where x = - rho*sin(theta), y = rho*cos(theta).
; Coeffecients A-F are determined using Cramer's method.
; For an ellipse, 4H^2 - 4AB < 0

NUM = 5
index = num-1

name = "DF Tau"
print, name

p1 = [-7.4d, 76d]
p2 = [-32.3, 84.4d]
p3 = [-54.0, 91.10]
p4 = [-78.7, 97.0]
p5 = [-96.0, 100.0]

dtheta = 0.6
drho = 1.0

const = 5.50d4  ;constant of areas in mas^2 * degrees / year
dconst = 0.71d4 ;error in constant of areas

theta=[p1(0), p2(0), p3(0), p4(0), p5(0)]
rho=[p1(1), p2(1), p3(1), p4(1), p5(1)]

x = dblarr(num)
y = dblarr(num)
dx = dblarr(num)
dy = dblarr(num)
m0 = dblarr(num,num)
m1 = dblarr(num,num)
m2 = dblarr(num,num)
m3 = dblarr(num,num)
m4 = dblarr(num,num)
m5 = dblarr(num,num)

for i=0, index do begin

        x(i) = - rho(i) * sin(theta(i)*!dpi/180)
        y(i) = rho(i) * cos(theta(i)*!dpi/180)

        dx(i) = sqrt((drho*sin(theta(i)*!dpi/180))^2 $
                + (!dpi*rho(i)*dtheta*cos(theta(i)*!dpi/180)/180)^2)
        dy(i) = sqrt((drho*cos(theta(i)*!dpi/180))^2 $
                + (!dpi*rho(i)*dtheta*sin(theta(i)*!dpi/180)/180)^2)

        m0[i,*] = [x(i)^2, 2*x(i)*y(i), y(i)^2, 2*x(i), 2*y(i)]
        m1[i,*] = [-1d, 2*x(i)*y(i), y(i)^2, 2*x(i), 2*y(i)]
        m2[i,*] = [x(i)^2, -1d, y(i)^2, 2*x(i), 2*y(i)]
        m3[i,*] = [x(i)^2, 2*x(i)*y(i), -1d, 2*x(i), 2*y(i)]
        m4[i,*] = [x(i)^2, 2*x(i)*y(i), y(i)^2, -1d, 2*y(i)]
        m5[i,*] = [x(i)^2, 2*x(i)*y(i), y(i)^2, 2*x(i), -1d]

endfor

detm0 = determ(m0)
detm1 = determ(m1)
detm2 = determ(m2)
detm3 = determ(m3)
detm4 = determ(m4)
detm5 = determ(m5)

A = detm1/detm0
H = detm2/detm0
B = detm3/detm0
G = detm4/detm0
F = detm5/detm0

dA_dx =  dblarr(num)
dA_dy =  dblarr(num)
dH_dx =  dblarr(num)
dH_dy =  dblarr(num)
dB_dx =  dblarr(num)
dB_dy =  dblarr(num)
dG_dx =  dblarr(num)
dG_dy =  dblarr(num)
dF_dx =  dblarr(num)
dF_dy =  dblarr(num)

A_sum = 0
H_sum = 0
B_sum = 0
G_sum = 0
F_sum = 0

for i=0, index do begin

        if (i le 2) then begin
                j=i+1 
                k=i+2
        endif else begin
        	if (i eq 3) then begin
                	j=4
                	k=0
        	endif
        	if (i eq 4) then begin
                	j=0
                	k=1
        	endif
	endelse

	; Derivatives of individual columns in m0 wrt to x,y

	xcol = dblarr(num)
	xcol(i) = 2*x(i)

	ycol = dblarr(num)
	ycol(i) = 2*x(i)

	ccol = dblarr(num)
	ccol(i) = 2

	; The derivative of column (-1 -1 -1 -1 -1) is the null vector and 
	; therefore does no factor in the calculation of determinant derivatives


        ; The sum of the determinants of the follwing matrices is equal to the 
        ; derivative of the determinant for the given matrix m_i wrt x,y.
	; The number following the dx/dy refers to which column the derivative
	; is being taken.  The deteminants of these matrices will then be 
	; summed together (product rule) to form the derivative of the 
	; determinants detm0, detm1, etc.  These derivatives will be given the
	; name dm0_dx, ..., rather than ddetm0_dx

        dm0_dx1 = m0
 	dm0_dx1(*,0) = xcol

	dm0_dx2 = m0
 	dm0_dx2(*,0) = ycol

	dm0_dx4 = m0
 	dm0_dx4(*,0) = ccol

	dm0_dx = determ(dm0_dx1) + determ(dm0_dx2) + determ(dm0_dx4)

        dm0_dy2 = m0
 	dm0_dy2(*,0) = xcol

	dm0_dy3 = m0
 	dm0_dy3(*,0) = ycol

	dm0_dy5 = m0
 	dm0_dy5(*,0) = ccol

	dm0_dy = determ(dm0_dy2) + determ(dm0_dy3) + determ(dm0_dy5)

	dm1_dx2 = m1
 	dm1_dx2(*,0) = ycol

	dm1_dx4 = m1
 	dm1_dx4(*,0) = ccol

	dm1_dx = determ(dm1_dx2) + determ(dm1_dx4)

        dm1_dy2 = m1
 	dm1_dy2(*,0) = xcol

	dm1_dy3 = m1
 	dm1_dy3(*,0) = ycol

	dm1_dy5 = m1
 	dm1_dy5(*,0) = ccol

	dm1_dy = determ(dm1_dy2) + determ(dm1_dy3) + determ(dm1_dy5)

        dm2_dx1 = m2
 	dm2_dx1(*,0) = xcol

	dm2_dx4 = m2
 	dm2_dx4(*,0) = ccol

	dm2_dx = determ(dm2_dx1) + determ(dm2_dx4)

	dm2_dy3 = m2
 	dm2_dy3(*,0) = ycol

	dm2_dy5 = m2
 	dm2_dy5(*,0) = ccol

	dm2_dy = determ(dm0_dy3) + determ(dm0_dy5)

        dm3_dx1 = m3
 	dm3_dx1(*,0) = xcol

	dm3_dx2 = m3
 	dm3_dx2(*,0) = ycol

	dm3_dx4 = m3
 	dm3_dx4(*,0) = ccol

	dm3_dx = determ(dm3_dx1) + determ(dm3_dx2) + determ(dm3_dx4)

        dm3_dy2 = m3
 	dm3_dy2(*,0) = xcol

	dm3_dy5 = m3
 	dm3_dy5(*,0) = ccol

	dm3_dy = determ(dm3_dy2) + determ(dm3_dy5)
 
        dm4_dx1 = m4
 	dm4_dx1(*,0) = xcol

	dm4_dx2 = m4
 	dm4_dx2(*,0) = ycol

	dm4_dx = determ(dm4_dx1) + determ(dm4_dx2)

        dm4_dy2 = m4
 	dm4_dy2(*,0) = xcol

	dm4_dy3 = m4
 	dm4_dy3(*,0) = ycol

	dm4_dy5 = m4
 	dm4_dy5(*,0) = ccol

	dm4_dy = determ(dm4_dy2) + determ(dm4_dy3) + determ(dm4_dy5)

        dm5_dx1 = m5
 	dm5_dx1(*,0) = xcol

	dm5_dx2 = m5
 	dm5_dx2(*,0) = ycol

	dm5_dx4 = m5
 	dm5_dx4(*,0) = ccol

	dm5_dx = determ(dm5_dx1) + determ(dm5_dx2) + determ(dm5_dx4)

        dm5_dy2 = m5
 	dm5_dy2(*,0) = xcol

	dm5_dy3 = m5
 	dm5_dy3(*,0) = ycol

	dm5_dy = determ(dm5_dy2) + determ(dm5_dy3)
 
	dA_dx(i) = (detm0*dm1_dx - detm1*dm0_dx)/detm0^2
	dA_dy(i) = (detm0*dm1_dy - detm1*dm0_dy)/detm0^2

	dH_dx(i) = (detm0*dm2_dx - detm2*dm0_dx)/detm0^2
	dH_dy(i) = (detm0*dm2_dy - detm2*dm0_dy)/detm0^2

	dB_dx(i) = (detm0*dm3_dx - detm3*dm0_dx)/detm0^2
	dB_dy(i) = (detm0*dm3_dy - detm3*dm0_dy)/detm0^2

	dG_dx(i) = (detm0*dm4_dx - detm4*dm0_dx)/detm0^2
	dG_dy(i) = (detm0*dm4_dy - detm4*dm0_dy)/detm0^2

	dF_dx(i) = (detm0*dm5_dx - detm5*dm0_dx)/detm0^2
	dF_dy(i) = (detm0*dm5_dy - detm5*dm0_dy)/detm0^2

        A_sum = A_sum + (dA_dx(i)*dx(i))^2 + (dA_dy(i)*dy(i))^2
        H_sum = H_sum + (dH_dx(i)*dx(i))^2 + (dH_dy(i)*dy(i))^2
        B_sum = B_sum + (dB_dx(i)*dx(i))^2 + (dB_dy(i)*dy(i))^2
        G_sum = G_sum + (dG_dx(i)*dx(i))^2 + (dG_dy(i)*dy(i))^2
        F_sum = F_sum + (dF_dx(i)*dx(i))^2 + (dF_dy(i)*dy(i))^2

endfor

dA = sqrt(A_sum)
dH = sqrt(H_sum)
dB = sqrt(B_sum)
dG = sqrt(G_sum)
dF = sqrt(F_sum)

print, "theta: "
print, theta
print, "rho: "
print, rho
print, "drho, dtheta: "
print, drho, dtheta
print, "const: ", const, dconst
print, "x: "
print, x
print, "dx:"
print, dx
print, "y: "
print, y
print, "dy:"
print, dy
print, "A H B G F: "
print, A,H,B,G,F
print, "dA dH dB dG dF: "
print, dA,dH,dB,dG,dF

;discriminant:

dis = 4*H^2 - 4*A*B

print, "Discriminant (should be negative for an ellipse): "
print, dis

; Rotate coordinate system so that major and minor axes of ellipse lie along
; the new coordinate axes.  Theta is the rotation angle, counterclockwise,
; with respect to the original frame.  (Angle is determined by setting the 
; cross-terms (x'y') in equation for ellipse to zero.)

theta = atan(2*H/(A-B))/2

print, "Rotation angle of coordinate system in degrees: "
print, theta*180/!dpi

; Non-vanishing coefficients of equation for ellipse in rotated coordinate
; system: c1*x^2 + c2*x + c3*y^2 + c4*y + 1 = 0

c1 = A*cos(theta)^2 + 2*H*sin(theta)*cos(theta) + B*sin(theta)^2
c2 = 2*G*cos(theta) + 2*F*sin(theta)
c3 = A*sin(theta)^2 - 2*H*sin(theta)*cos(theta) + B*cos(theta)^2
c4 = -2*G*sin(theta) + 2*F*cos(theta)

x_cent = -c2/(2*c1)
y_cent = -c4/(2*c3)
xmajor = sqrt((c3*c2^2 + c1*c4^2 - 4*c1*c3)/(4*c1^2*c3))
yminor = sqrt((c3*c2^2 + c1*c4^2 - 4*c1*c3)/(4*c1*c3^2))

print, "x_cent   y_cent: "
print, x_cent, y_cent

if (xmajor ge yminor) then begin

	print, "major axis along x-axis"
	
	major = xmajor
	minor = yminor
endif

if (xmajor lt yminor) then begin 

	print, "major axis along y-axis"

	major = yminor
	minor = xmajor
endif

print, "major   minor: "
print, major, minor

; eccentricity

ecc = sqrt(1 - (minor/major)^2)

print, "Eccentricity: "
print, ecc

; distance between center and foci (ae)

foci = major*ecc

print, "Distance between center and foci: "
print, foci

end
