pro gaussj, A, B

; Gauss-Jordan elimination: determine inverse of covariance matrix A
;
;:Code modified from Numerical Recipes in C:
; Linear equation solution by Gauss-Jordan elimination
;
; INPUT
;	A: input (covariance) matrix
;	B: right-hand side vectors
; OUTPUT
;	A is replaced by its matrix inverse
;	B is replaces by corresponding set of solution vectors

num_el = 7	; number of elements varied

ipiv = intarr(num_el)	; The integer arrays ipiv, indxr, and indxc 
indxr = intarr(num_el)	; are used for bookkeeping on the pivoting
indxc = intarr(num_el)	; (ipiv initialized to zero vector)

; Main loop over the columns to be reduced

for i=0, num_el-1 do begin

	big=0d
	
	; outer loop of the search for a pivot element

	for j=0, num_el-1 do begin

	     if (ipiv(j) ne 1) then begin 

	          for k=1, num_el-1 do begin
	
		      if (ipiv(k) eq 0) then begin
	
		            if (abs(A(j,k)) ge big) then begin
			
			         big = abs(A(j,k))
				 irow = j
				 icol = k
			    endif
		      endif else if (ipiv(k) gt 1) then print,"Singular matrix"
		  endfor
	     endif
	endfor

	ipiv(icol) = ipiv(icol) + 1

	; We now have the pivot element, so we interchange roes, if needed,
	; to put the pivot element on the diagonal. The columns are not 
	; physically interchanged, only relabeled: indxc[i]], the column of 
	; the ith pivot element, is the ith column that is reduced, while 
	; indxr[i] is the row in which that pivot element was originally 
	; located. If indxr[i] != indxc[i] there is an implied column 
	; interchange. With this form of bookkeepingm the solution B's will
	; end up in the correct order, and the inverse matrix will be
	; scrambled by columns.

	if (irow ne icol) then begin
	     for l=1, num_el-1 do begin

	          dum = A(irow,l)
		  A(irow,l) = A(icol,l)
		  A(icol,l) = dum
	     endfor
	     
	     dum = B(irow)
	     B(irow) = B(icol)
             B(icol) = dum
	endif
	
	; We are now ready to divide the pivot row by the pivot element, 
	; located at irow and icol

	indxr(i) = irow
	indxc(i) = icol

	if (A(icol,icol) eq 0.0) then print, "Singular matrix-2"

	pivinv = 1d/A(icol,icol)
	A(icol,icol) = 1d

	for l=0, num_el-1 do begin

	     A(icol,l) = A(icol,l)*pivinv
	endfor

	B(icol) = B(icol)*pivinv

	for ll=0, num_el-1 do begin	; Now we reduce the rows...

	     if (ll ne icol) then begin	;...except for the pivot one, of course

	          dum = A(ll,icol)
		  A(ll,icol) = 0d

		  for l=0, num_el-1 do begin

		       A(ll,l) = A(ll,l) - A(icol,l)*dum
		  endfor

		  B(ll) = B(ll) - B(icol)*dum
	     endif
	endfor
endfor

; This is the end of the main loop over columns of the reduction. It only
; remains to unscramble the solution in view of the column interchanges.
; We do this by interchanging pairs of columns in the reverse order that the
; permutation was built up.

for l=0, num_el-1 do begin

	if (indxr(l) ne indxc(l)) then begin

	     for k=0, num_el-1 do begin
	     
	          dum = A(k,indxr(l))
		  A(k,indxr(l)) = A(k,indxc(l))
		  A(k,indxc(l)) = dum
    	     endfor
	endif
endfor

end
