pro l_regress, x, y, err, a, b

;perform linear regression
;Input: independent variable array x
;	dependent variable array y
;	error in dependent variable err
;Output:intercept and error in vector a (a(0): intercept, a(1): error)
;	slope and error in vector b (b(0):slope, b(1):error)
;
; y = a(0) + b(0)*x

num = n_elements(x)
index = num - 1

a = dblarr(2)
b = dblarr(2)

xx_ss = dblarr(num)
y_ss = dblarr(num)
x_ss = dblarr(num)
xy_ss = dblarr(num)
inv_ss = dblarr(num)

for j = 0, index do begin

	xx_ss(j) = x(j)*x(j)/(err(j)*err(j))
	y_ss(j) = y(j)/(err(j)*err(j))
	x_ss(j) = x(j)/(err(j)*err(j))
	xy_ss(j) = x(j)*y(j)/(err(j)*err(j))
	inv_ss(j) = 1/(err(j)*err(j))
	
endfor

s_xx_ss = total(xx_ss)
s_y_ss = total(y_ss)
s_x_ss = total(x_ss)
s_xy_ss = total(xy_ss)
s_1_ss = total(inv_ss)

delta = (s_1_ss * s_xx_ss) - (s_x_ss * s_x_ss)
a(0) = ((s_xx_ss * s_y_ss) - (s_x_ss * s_xy_ss))/delta
b(0) = ((s_1_ss * s_xy_ss) - (s_x_ss * s_y_ss))/delta
a(1) = sqrt((s_xx_ss)/delta)
b(1) = sqrt((s_1_ss)/delta)
	 
end
