pro linfith, X, Y, z, sigz, c, d

; Solve for Thiele-Innes elements - this routine is called by calc_AFBG.pro
; 
; Least squares linear fit to the equation: z = cX + dY
; where z = (x,y), c = (A,B), and d = (F,G)
; sigz = errors in z=(x,y) ... (for a weighted least squares fit)
; The user supplies the X,Y,z arrays and errors in z
; Program returns values for c,d
; The least squares fit is performed in the same manner as Hartkopf's code
; Minimize chi squared with respect to A,B,F,G (set partial derivatives to 0):
; 	chi^2 = sum[(x - AX - FY)^2/sigx^2 + (y - BX - GY)^2/sigy^2]
; Because x is only a function of (A,F), and y is only a funtion of (B,G),
; minimizing chi squared can proceed independently for each of the x,y 
; variables.

num_data = n_elements(z)	;number of data points
ind_data = num_data -1


c = (total(X*Y/sigz^2)*total(z*Y/sigz^2) - $
	total(z*X/sigz^2)*total(Y*Y/sigz^2))/ $
	(total(X*Y/sigz^2)^2 - total(X*X/sigz^2)*total(Y*Y/sigz^2))

d = (total(X*Y/sigz^2)*total(z*X/sigz^2) - $
	total(z*Y/sigz^2)*total(X*X/sigz^2))/ $
	(total(X*Y/sigz^2)^2 - total(X*X/sigz^2)*total(Y*Y/sigz^2))

;print, "e^2:", e2new

end
