pro make_sb2

; make synthetic data file for sb2

; input: P, T, e, a1sini, a2sini, omega, Vsys
; output: time V1 sigV1 V2 sigV2

; try over one period
; then try over two periods
;
; Calls the following routines:
;     calc_Ei.pro
;     solve_trans.pro
;     calc_sb2fit.pro - for plotting model orbits
;

; Obtain values for P,T,e,a1sini,a2sini,omega,Vsys

period = 0d
Tperi = 0d
ecc = 0d
K1 = 0d
K2 = 0d
omega = 0d
Vsys = 0d


print,"Enter P,T,e,K1,K2,omega,Vsys:"
read,period,Tperi,ecc,K1,K2,omega,Vsys

print,"Initial P,T,e,K1,K2,omega,Vsys:"
print,period,Tperi,ecc,K1,K2,omega,Vsys

;convert omega to radians
omega = omega*!dpi/180

EL_sb2 = [period,Tperi,ecc,K1,K2,omega,Vsys]

;ansyd=' '
;print,'Is period in years or days (y/d)?'
;read,ansyd
;
;if (ansyd eq 'y') then y_d = 365.25
;if (ansyd eq 'd') then y_d = 1.0
;
;; conversion factor for y/d to seconds
;; (need to convert period to sections when computing velocities)
;sec = 1.0*y_d*24.0*60.0*60.0
;
;meters = 0.0
;print,'How many meters are in semi-major axis units?'
;print,'(1 Gm = 1d9 m)'
;read,meters
;
;km = meters/1d3

; create data file

tnum = 0.0
norb = 0.0

print,'How many data points over course of orbit?'
read,tnum
print,'How many orbits?'
read,norb

numtot = norb*tnum

tstep = period/tnum
tarr = findgen(numtot+1)*tstep + Tperi
V1mod = dblarr(numtot+1)
V2mod = dblarr(numtot+1)

phase_mod = (tarr-Tperi)/period

calc_sb2fit, EL_sb2, tarr, V1mod, V2mod

vmax = max([max(V1mod),max(V2mod)])
vmin = min([min(V1mod),min(V2mod)])

plot,tarr,V1mod,psym=2,yrange=[vmin,vmax],xrange=[min(tarr),max(tarr)],xstyle=1
oplot,tarr,V2mod,psym=6

;for i=0, (norb*tnum)-1 do print, format='(f9.3,f7.2,%" 2.0",f7.2," 2.0")', tarr(i), V1mod(i), V2mod(i)

for i=0, (norb*tnum)-1 do print, format='(f9.3,f7.2,f7.2)', tarr(i), V1mod(i), V2mod(i)

diff = abs(V1mod - V2mod)

tind = where(diff eq max(diff))

print,'Max RV Diff: ',max(diff)
print,'Time of max RV Diff: ',tarr(tind(0))

;stop,'Type .cont to continue'

end
