pro plot_aiWM, pte_file, fnum,datanum

; Uses result_chi file that contains all orbital parameters
; P T e a i W w chi2
; Create for use with polaris data (and search_chi2_aiW.pro)

; datanum = number of data points (needed for computing degrees of freedom)

; Make colored plots for thesis
;
; Visualize parameter space: 
;	e vs log(P) 
;	log(a) vs log(P) 
;	M vs e 
;	M vs log(P) 
;
; Color scheme: red   = 1-sigma (Deltachi2 = 1)
;		blue  = 2-sigma (Deltachi2 = 4)
;		green = 3-sigma (Deltachi2 = 9)
;
; Computes statistics for orbital elements
;
; Modification of LEAST_PTE.PRO
;
; INPUT:
; 	data_file: name of file containing the observations
;		format: time PA ePA sep esep
;	num: number of lines in data_file
;	pte_file: name of file containing P,T,e,chi2 for possible solutions
;		format: P T e chi2
;	fnum: number of lines in pte_file
;
; PROMPTED INPUTS:
;	system parallax (in mas)
;
; PROCEDURE:
; 	performs least squares fit
; 	computes a,i,Omega,omega,M for each P,T,e set
;	computes min, max, mean, median, and stdev for each orbital element
;
; OUTPUT: 
;	temp.ps: 4-panel colored plots of cross-cuts through M,P,a,e
;            parameter spaces

!P.font=0
!P.charsize=1.0
!P.charthick=2.0
!P.thick=2.0
!X.thick=2.0
!Y.thick=2.0

close,1

; Set color table
;  red=1, green=2, blue=3

tvlct, [255,0,0], [0,255,0], [0,0,255], 1


; Read in pte file names

openr,1,pte_file

period = 0d
Tperi = 0d
ecc = 0d
major = 0d
inc = 0d
W_cap = 0d
w_low = 0d
xchi = 0d

massi = dblarr(fnum)
a_arr = dblarr(fnum)
e_arr = dblarr(fnum)
i_arr = dblarr(fnum)
P_arr = dblarr(fnum)
T_arr = dblarr(fnum)
W_cap_arr = dblarr(fnum)
w_low_arr = dblarr(fnum)
chi_arr = dblarr(fnum)

mratio_arr  = dblarr(fnum)
M1_arr = dblarr(fnum)
M2_arr = dblarr(fnum)

freepar = 1.0		;number of free parameters (up to 7)
	
; degrees of freedom
dof = 2.0*datanum - freepar
	
parallax = 0.0d

print, 'Enter the parallax of the system (in same units as separation):'
print,'(distance of 140, parallax = 7.14 mas)'
read, parallax

K1 = 0.0d
print,'Enter the primary radial velocity in km/s (if unknown enter 0):'
read, K1

ansyd=' '
print,'Is period in years or days (y/d)?'
read,ansyd

if (ansyd eq 'y') then yd = 1.0d
if (ansyd eq 'd') then yd = 1.0d/365.25

print, 'Computing masses...'

for j=0, fnum-1 do begin

	; Read in P,T,e,a,i,W,w from pte_file

	readf, 1, period, Tperi, ecc, major, inc, W_cap, w_low, xchi

	EL = [period,Tperi,ecc,major,inc,W_cap,w_low]

	; calculate mass of system using distance of 140 pc
	; parallax = 7.14 mas
	
	mass = major^3/parallax^3/(yd*period)^2

	massi(j) = mass
	a_arr(j) = major
	e_arr(j) = ecc
	i_arr(j) = 180*inc/!dpi
	P_arr(j) = period
	T_arr(j) = Tperi
	W_cap_arr(j) = 180*W_cap/!dpi
	w_low_arr(j) = 180*w_low/!dpi
	chi_arr(j) = xchi      ; read chi2 in from data file

        if (W_cap_arr(j) ge 360.0) then W_cap_arr(j) = W_cap_arr(j) - 360.0

        if (K1 ne 0) then begin
        mratio_arr(j) = 3.784229924d-5 * K1^3 * (period) * (1.0- ecc^2)^(1.5)
        M2_arr(j) = 0.033573182d * major^2/ parallax^2*K1/(period)/sin(inc)*sqrt(1.0 - ecc^2)
        M1_arr(j) = mass - M2_arr(j)
        endif

endfor

close,1

ind_i = findgen(fnum)

; Select solutions only where M1 and M2 are BOTH positive
if (K1 ne 0) then begin
ans_inc = 'y'
if (ans_inc eq 'y') then begin 

print, 'Select solutions only where M1 and M2 are BOTH postive'
ind_i = where((M1_arr gt  0.0) and (M2_arr gt  0.0),icount)

massi = massi(ind_i)
i_arr = i_arr(ind_i)
a_arr = a_arr(ind_i)
W_cap_arr = W_cap_arr(ind_i)
chi_arr = chi_arr(ind_i)
mratio_arr = mratio_arr(ind_i)
M2_arr = M2_arr(ind_i)
M1_arr = M1_arr(ind_i)
endif
endif

;determine critical inclination that produces negative component masses
plot_icrit = 'n'
if (plot_icrit eq 'y') then begin
ind_i = where((M1_arr gt  0.0) and (M2_arr gt  0.0),icount)
ilim = i_arr(ind_i)
icrit = max(ilim)
print, 'Critical calue of inclination above which produces negative component masses:', icrit
endif



;minchi=min(chi_arr)
;ind_chi4 = where(chi_arr le (minchi+4.0))
;massi = massi(ind_chi4)
;i_arr = i_arr(ind_chi4)
;a_arr = a_arr(ind_chi4)
;W_cap_arr = W_cap_arr(ind_chi4)
;chi_arr = chi_arr(ind_chi4)
;mratio_arr = mratio_arr(ind_chi4)
;M2_arr = M2_arr(ind_chi4)
;M1_arr = M1_arr(ind_chi4)
;
;ind_m1 = where(M1_arr gt 1.0)
;massi = massi(ind_m1)
;i_arr = i_arr(ind_m1)
;a_arr = a_arr(ind_m1)
;W_cap_arr = W_cap_arr(ind_m1)
;chi_arr = chi_arr(ind_m1)
;mratio_arr = mratio_arr(ind_m1)
;M2_arr = M2_arr(ind_m1)
;M1_arr = M1_arr(ind_m1)
;
;ind_imin = where(i_arr eq min(i_arr))
;ind_imax = where(i_arr eq max(i_arr))
;print,'a i Omega Mtot M1 M2 chi2'
;print,'Minimum inclination solution:'
;print,a_arr(ind_imin),i_arr(ind_imin),W_cap_arr(ind_imin),massi(ind_imin),M1_arr(ind_imin),M2_arr(ind_imin),chi_arr(ind_imin)
;print,'Maximum inclination solution:'
;print,a_arr(ind_imax),i_arr(ind_imax),W_cap_arr(ind_imax),massi(ind_imax),M1_arr(ind_imax),M2_arr(ind_imax),chi_arr(ind_imax)


print,"Error estimates: min max mean median stddev"
print,format='(%"Mtot:",f10.4,f10.4,f10.4,f10.4,f10.4)', $
	min(massi),max(massi),mean(massi),median(massi),stddev(massi)
print,format='(%"M1:",f10.4,f10.4,f10.4,f10.4,f10.4)', $
	min(M1_arr),max(M1_arr),mean(M1_arr),median(M1_arr),stddev(M1_arr)
print,format='(%"M2:",f10.4,f10.4,f10.4,f10.4,f10.4)', $
	min(M2_arr),max(M2_arr),mean(M2_arr),median(M2_arr),stddev(M2_arr)
print,format='(%"P:",f10.4,f10.4,f10.4,f10.4,f10.4)', $
	min(P_arr),max(P_arr),mean(P_arr),median(P_arr),stddev(P_arr)
print,format='(%"a:",f10.4,f10.4,f10.4,f10.4,f10.4)', $
	min(a_arr),max(a_arr),mean(a_arr),median(a_arr),stddev(a_arr)
print,format='(%"e:",f10.6,f10.6,f10.6,f10.6,f10.6)', $
	min(e_arr),max(e_arr),mean(e_arr),median(e_arr),stddev(e_arr)
print,format='(%"i:",f10.4,f10.4,f10.4,f10.4,f10.4)', $
	min(i_arr),max(i_arr),mean(i_arr),median(i_arr),stddev(i_arr)
print,format='(%"T:",f10.4,f10.4,f10.4,f10.4,f10.4)', $
	min(T_arr),max(T_arr),mean(T_arr),median(T_arr),stddev(T_arr)
print,format='(%"W:",f10.4,f10.4,f10.4,f10.4,f10.4)', $
	min(W_cap_arr),max(W_cap_arr),mean(W_cap_arr), $
	median(W_cap_arr),stddev(W_cap_arr)
print,format='(%"w:",f10.4,f10.4,f10.4,f10.4,f10.4)', $
	min(w_low_arr),max(w_low_arr),mean(w_low_arr), $
	median(w_low_arr),stddev(w_low_arr)

Mmin = 0.0
Mmax = 0.0

;print,'Enter min max of M range for plot:'
;read,Mmin,Mmax

amin = min(a_arr)
amax = max(a_arr)
imin = min(i_arr)
imax = max(i_arr)
Wmin = min(W_cap_arr)
Wmax = max(W_cap_arr)
Mmin = min(massi)
Mmax = max(massi)
M1min = min(M1_arr)
M1max = max(M1_arr)
M2min = min(M2_arr)
M2max = max(M2_arr)


;amin = 0.10
;amax = 0.14
;imin = 120
;imax = 240
;Wmin = 5 
;Wmax = 20
;Mmin = 3
;Mmax = 7.5

;print,'Enter max P for plotting range'
;read,Pmax
;print,'Enter min P for plotting range'
;read,Pmin

; Separate solutions into 1-, 2-, and 3- sigma intervals

chimin = min(chi_arr)

print,'Minimum chi2:',chimin

sig1 = where(chi_arr le (chimin+1.0), count1)
sig2 = where(chi_arr gt (chimin+1.0) and chi_arr le (chimin+4.0), count2)
sig3 = where(chi_arr gt (chimin+4.0) and chi_arr le (chimin+9.0), count3)

if (sig2(0) lt 0.0) then sig2 = sig1
if (sig3(0) lt 0.0) then sig3 = sig1

; Define user symbol to be closed circle
; Make a vector of 16 points, Z[i] = 2pi/16:
Z = findgen(17) * (!pi*2/16.)

fracsmall = 0.25

; Plot orbits as small filled circles
usersym, fracsmall*cos(Z), fracsmall*sin(Z), /fill

!P.MULTI = [0,2,2]
;Save plots to file temp.ps

;stop,'type .cont to continue'

iunit = ['100','150','200','250']
aunit = ['0.10',' ','0.12',' ','0.14',' ']

set_plot, 'ps'
;device, filename='temp.ps',xsize=18,ysize=13
device, /Color, filename='temp.eps',xsize=15,ysize=13.5,/isolatin1,/encap

;;plot,a_arr,i_arr,psym=3,xtitle='a (")',ytitle='i (!9%!3)',/nodata, $
;plot,a_arr,i_arr,psym=3,xtitle='a (")',ytitle='i ('+string(176b)+')',/nodata, $
;  xrange=[amin,amax],yrange=[imin,imax],xtickinterval=0.004;,ytickinterval=50;,xtickname=aunit
;oplot,a_arr(sig3),i_arr(sig3), psym=8, color=2
;oplot,a_arr(sig2),i_arr(sig2), psym=8, color=3
;oplot,a_arr(sig1),i_arr(sig1), psym=8, color=1
;if (plot_icrit eq 'y') then oplot,[amin-0.1,amax+0.1],[icrit,icrit],linestyle=1

plot,i_arr,a_arr,psym=3,ytitle='a (")',xtitle='i ('+string(176b)+')',/nodata, $
  yrange=[amin,amax],xrange=[imin,imax];,ytickinterval=50;,xtickname=aunit
oplot,i_arr(sig3),a_arr(sig3), psym=8, color=2
oplot,i_arr(sig2),a_arr(sig2), psym=8, color=3
oplot,i_arr(sig1),a_arr(sig1), psym=8, color=1
if (plot_icrit eq 'y') then oplot,[icrit,icrit],[amin-0.1,amax+0.1],linestyle=1

;plot,i_arr,W_cap_arr,psym=3,xtitle='i (!9%!3)',ytitle='!4X!3 (!9%!3)',/nodata, $
plot,i_arr,W_cap_arr,psym=3,xtitle='i ('+string(176b)+')',ytitle='!9W!3 ('+string(176b)+')',/nodata, $
  xrange=[imin,imax],yrange=[Wmin,Wmax];,xtickinterval=50
oplot,i_arr(sig3),W_cap_arr(sig3), psym=8, color=2
oplot,i_arr(sig2),W_cap_arr(sig2), psym=8, color=3
oplot,i_arr(sig1),W_cap_arr(sig1), psym=8, color=1
if (plot_icrit eq 'y') then oplot,[icrit,icrit],[Wmin-10,Wmax+10],linestyle=1

;;plot,a_arr,W_cap_arr,psym=3,xtitle='a (")',ytitle='!4X!3 (!9%!3)',/nodata,$
;plot,a_arr,W_cap_arr,psym=3,xtitle='a (")',ytitle='!9W!3 ('+string(176b)+')',/nodata,$
;  xrange=[amin,amax],yrange=[Wmin,Wmax],xtickinterval=0.004;,xtickname=aunit
;oplot,a_arr(sig3),W_cap_arr(sig3), psym=8, color=2
;oplot,a_arr(sig2),W_cap_arr(sig2), psym=8, color=3
;oplot,a_arr(sig1),W_cap_arr(sig1), psym=8, color=1

;;plot,i_arr,massi,psym=3,xtitle='i (!9%!3)',ytitle='M!dtot!n (M!9!dn!3!n)',/nodata, $
;plot,i_arr,massi,psym=3,xtitle='i ('+string(176b)+')',ytitle='M!dtot!n (Msun)',/nodata, $
;  xrange=[imin,imax],yrange=[Mmin,Mmax];,xtickinterval=50
;oplot,i_arr(sig3),massi(sig3), psym=8, color=2
;oplot,i_arr(sig2),massi(sig2), psym=8, color=3
;oplot,i_arr(sig1),massi(sig1), psym=8, color=1
;if (plot_icrit eq 'y') then oplot,[icrit,icrit],[Mmin-5,Mmax+5],linestyle=1

plot,i_arr,M1_arr,psym=3,xtitle='i ('+string(176b)+')',ytitle='M!d1!n (Msun)',/nodata, $
  xrange=[imin,imax],yrange=[M1min,M1max];,xtickinterval=50
oplot,i_arr(sig3),M1_arr(sig3), psym=8, color=2
oplot,i_arr(sig2),M1_arr(sig2), psym=8, color=3
oplot,i_arr(sig1),M1_arr(sig1), psym=8, color=1


plot,i_arr,M2_arr,psym=3,xtitle='!3 i ('+string(176b)+')',ytitle='!3 M!d2!n (Msun)',/nodata, $
  xrange=[imin,imax],yrange=[M2min,M2max];,xtickinterval=50
oplot,i_arr(sig3),M2_arr(sig3), psym=8, color=2
oplot,i_arr(sig2),M2_arr(sig2), psym=8, color=3
oplot,i_arr(sig1),M2_arr(sig1), psym=8, color=1

device, /close
set_plot,'x'


!P.MULTI = [0,3,1]
!P.charsize=1.4

set_plot, 'ps'
;device, filename='temp.ps',xsize=18,ysize=13
device, /Color, filename='temp_aiWM.eps',xsize=21,ysize=7,/isolatin1,/encap

plot,i_arr,a_arr,psym=3,ytitle='a (")',xtitle='i ('+string(176b)+')',/nodata, $
  yrange=[amin,amax],xrange=[imin,imax];,ytickinterval=50;,xtickname=aunit
oplot,i_arr(sig3),a_arr(sig3), psym=8, color=2
oplot,i_arr(sig2),a_arr(sig2), psym=8, color=3
oplot,i_arr(sig1),a_arr(sig1), psym=8, color=1
if (plot_icrit eq 'y') then oplot,[icrit,icrit],[amin-0.1,amax+0.1],linestyle=1

;plot,i_arr,W_cap_arr,psym=3,xtitle='i (!9%!3)',ytitle='!4X!3 (!9%!3)',/nodata, $
plot,i_arr,W_cap_arr,psym=3,xtitle='i ('+string(176b)+')',ytitle='!9W!3 ('+string(176b)+')',/nodata, $
  xrange=[imin,imax],yrange=[Wmin,Wmax];,xtickinterval=50
oplot,i_arr(sig3),W_cap_arr(sig3), psym=8, color=2
oplot,i_arr(sig2),W_cap_arr(sig2), psym=8, color=3
oplot,i_arr(sig1),W_cap_arr(sig1), psym=8, color=1
if (plot_icrit eq 'y') then oplot,[icrit,icrit],[Wmin-10,Wmax+10],linestyle=1

plot,i_arr,massi,psym=3,xtitle='i ('+string(176b)+')',ytitle='M!dtot!n (Msun)',/nodata, $
  xrange=[imin,imax],yrange=[Mmin,Mmax];,xtickinterval=50
oplot,i_arr(sig3),massi(sig3), psym=8, color=2
oplot,i_arr(sig2),massi(sig2), psym=8, color=3
oplot,i_arr(sig1),massi(sig1), psym=8, color=1
;if (plot_icrit eq 'y') then oplot,[icrit,icrit],[Mmin-5,Mmax+5],linestyle=1

device, /close
set_plot,'x'

!P.MULTI = [0,0,0]
!P.charsize=1.0

set_plot, 'ps'
device, /Color, filename='tempam.ps',xsize=15,ysize=13.5,/isolatin1

;plot,a_arr,massi,psym=3,xtitle='a (arcsec)',ytitle='M (M!9!dn!3!n)',/nodata, $
plot,a_arr,W_cap_arr,psym=3,xtitle='a (")',ytitle='!9W!3 ('+string(176b)+')',/nodata,$
  xrange=[amin,amax],yrange=[Mmin,Mmax]
oplot,a_arr(sig3),massi(sig3), psym=8, color=2
oplot,a_arr(sig2),massi(sig2), psym=8, color=3
oplot,a_arr(sig1),massi(sig1), psym=8, color=1

device, /close
set_plot,'x'

!P.MULTI = [0,0,0]

;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Find specific solutions: ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; minimum inlcination within uncertainty interval:
indimin = where(i_arr eq min(i_arr))
print,'Minimum inclination solution:'
print,P_arr(indimin),T_arr(indimin),e_arr(indimin),a_arr(indimin),i_arr(indimin),W_cap_arr(indimin),w_low_arr(indimin),massi(indimin),M1_arr(indimin),M2_arr(indimin),chi_arr(indimin)

; maximum inclination within uncertainty interval:
indimax = where(i_arr eq max(i_arr))
print,'Maximum inclination solution:'
print,P_arr(indimax),T_arr(indimax),e_arr(indimax),a_arr(indimax),i_arr(indimax),W_cap_arr(indimax),w_low_arr(indimax),massi(indimax),M1_arr(indimax),M2_arr(indimax),chi_arr(indimax)

; minimum major axis within uncertainty interval:
indamin = where(a_arr eq min(a_arr))
print,'Minimum major solution:'
print,P_arr(indamin),T_arr(indamin),e_arr(indamin),a_arr(indamin),i_arr(indamin),W_cap_arr(indamin),w_low_arr(indamin),massi(indamin),chi_arr(indamin)

; maximum major axis within uncertainty interval:
indamax = where(a_arr eq max(a_arr))
print,'Maximum major solution:'
print,P_arr(indamax),T_arr(indamax),e_arr(indamax),a_arr(indamax),i_arr(indamax),W_cap_arr(indamax),w_low_arr(indamax),massi(indamax),chi_arr(indamax)

; minimum Omega within uncertainty interval:
indWmin = where(W_cap_arr eq min(W_cap_arr))
print,'Minimum Omega solution:'
print,P_arr(indWmin),T_arr(indWmin),e_arr(indWmin),a_arr(indWmin),i_arr(indWmin),W_cap_arr(indWmin),w_low_arr(indWmin),massi(indWmin),chi_arr(indWmin)

; minimum Omega within uncertainty interval:
indWmax = where(W_cap_arr eq max(W_cap_arr))
print,'Maximum Omega solution:'
print,P_arr(indWmax),T_arr(indWmax),e_arr(indWmax),a_arr(indWmax),i_arr(indWmax),W_cap_arr(indWmax),w_low_arr(indWmax),massi(indWmax),chi_arr(indWmax)

; minimum mass within uncertainty interval:
indMmin = where(massi eq min(massi))
print,'Minimum mass solution:'
print,P_arr(indMmin),T_arr(indMmin),e_arr(indMmin),a_arr(indMmin),i_arr(indMmin),W_cap_arr(indMmin),w_low_arr(indMmin),massi(indMmin),M1_arr(indMmin),M2_arr(indMmin),chi_arr(indMmin)

; maximum mass within uncertainty interval:
indMmax = where(massi eq max(massi))
print,'Maximum mass solution:'
print,P_arr(indMmax),T_arr(indMmax),e_arr(indMmax),a_arr(indMmax),i_arr(indMmax),W_cap_arr(indMmax),w_low_arr(indMmax),massi(indMmax),M1_arr(indMmax),M2_arr(indMmax),chi_arr(indMmax)


end

