pro plot_aiW_weight, pte_file, fnum, datanum

; Uses result_chi file that contains all orbital parameters
; P T e a i W w chi2
; Create for use with polaris data (and search_chi2_aiW.pro)

; datanum = number of data points (needed for computing degrees of freedom)

; Weight each value in histogram by the chi2 probability.  Output is then
; parameter vs. weighted number of solutions

; Computes statistics for orbital elements
; Make weighted histogram of mass
;
; Modification of LEAST_PTE.PRO
;
; INPUT:
; 	data_file: name of file containing the observations
;		format: time PA ePA sep esep
;	num: number of lines in data_file
;	pte_file: name of file containing P,T,e,chi2 for possible solutions
;		format: P T e chi2
;	fnum: number of lines in pte_file
;
; PROMPTED INPUTS:
;	system parallax (in mas)
;	step sizes and ranges for histograms
;
; PROCEDURE:
; 	performs least squares fit
; 	computes a,i,Omega,omega,M for each P,T,e set
;	computes min, max, mean, median, and stdev for each orbital element
;	computes frequency distribution and histograms for M
;	computes mass errors based on 34% of sample above and below median
;
; OUTPUT: 
;	tempM.ps: weighted mass distribution histogram
;       tempchi.ps: chi2 vs. mass surface
;       tempprob.ps: chi2 probability vs. chi2
;	result_errors: file of statistics for orbital elements
;		min, max, mean, median, and stdev for each element
;		error estimates for mass (+/-34% of sample within median)
;		mass distribution used to calculate errors
;
; 7 October 2003: modified to calculate mass errors based on mass distribution
; 	within the program
; 13 April 2006:  read chi2 in from data file rather than 
;     re-computing in data file.  Reason being: changed
;     hartkopf_mc.pro to scale chi2 (don't need to do that
;     here - would require inputing best-fit solution)
;
; 9 April 2008: Add subroutine compute_histo_uncty.pro that computes
;   median and uncertainties by sorting the arrays, rather than using
;   step sizes to bin the arrays.  Old version saved as plot_aiW_weight_v1.pro

!P.charsize=1.5
!P.charthick=2.0
!P.thick=2.0
!X.thick=2.0
!Y.thick=2.0
frac=1.2

; Read in pte file names

openr,1,pte_file
openw,2,"result_all"
printf,2, "P T e a i Omega omega mass chi2:"

period = 0d
Tperi = 0d
ecc = 0d
major = 0d
inc = 0d
W_cap = 0d
w_low = 0d
xchi = 0d

massi = dblarr(fnum)
a_arr = dblarr(fnum)
e_arr = dblarr(fnum)
i_arr = dblarr(fnum)
P_arr = dblarr(fnum)
T_arr = dblarr(fnum)
W_cap_arr = dblarr(fnum)
w_low_arr = dblarr(fnum)
chi_arr = dblarr(fnum)

mratio_arr  = dblarr(fnum)
M1_arr = dblarr(fnum)
M2_arr = dblarr(fnum)

freepar = 1.0		;number of free parameters (up to 7)
	
; degrees of freedom
dof = 2.0*datanum - freepar
	
parallax = 0.0d

print, 'Enter the parallax of the system (in same units as separation):'
print,'(distance of 140, parallax = 7.14 mas)'
read, parallax

K1 = 0.0d
print,'Enter the primary radial velocity in km/s (if unknown enter 0):'
read, K1

ansyd=' '
print,'Is period in years or days (y/d)?'
read,ansyd

if (ansyd eq 'y') then yd = 1.0d
if (ansyd eq 'd') then yd = 1.0d/365.25

print, 'Computing masses...'

for j=0, fnum-1 do begin

	; Read in P,T,e,a,i,W,w from pte_file

	readf, 1, period, Tperi, ecc, major, inc, W_cap, w_low, xchi

	EL = [period,Tperi,ecc,major,inc,W_cap,w_low]

	; calculate mass of system using distance of 140 pc
	; parallax = 7.14 mas
	
	mass = major^3/parallax^3/(yd*period)^2

	massi(j) = mass
	a_arr(j) = major
	e_arr(j) = ecc
	i_arr(j) = 180*inc/!dpi
	P_arr(j) = period
	T_arr(j) = Tperi
	W_cap_arr(j) = 180*W_cap/!dpi
	w_low_arr(j) = 180*w_low/!dpi
	chi_arr(j) = xchi      ; read chi2 in from data file

        if (K1 ne 0) then begin
        mratio_arr(j) = 3.784229924d-5 * K1^3 * period * (1.0- ecc^2)^(1.5)
        M2_arr(j) = 0.033573182d * major^2/ parallax^2*K1/period/sin(inc)*sqrt(1.0 - ecc^2)
        M1_arr(j) = mass - M2_arr(j)
        endif

	printf,2,EL(0),El(1),EL(2),EL(3),180*EL(4)/!dpi,180*EL(5)/!dpi, $
		180*EL(6)/!dpi, mass, xchi

endfor

close,1
close,2

;ind_i = where(i_arr le 162.14)
;print,'Mass at i<162:',min(massi(ind_i))	
;ind_i = where(i_arr ge 197.86)
;print,'Mass at i>198:',min(massi(ind_i))	

ind_i = findgen(fnum)

;ans_inc = 'y'
;if (ans_inc eq 'y') then print, 'Select only i < 162 or i > 198'
;ind_i = where(i_arr le 162.14 or i_arr ge 197.86, icount)

; Select solutions only where M1 and M2 are BOTH positive
if (K1 ne 0) then begin
ans_inc = 'y'
if (ans_inc eq 'y') then print, 'Select solutions only where M1 and M2 are BOTH postive'
ind_i = where((M1_arr gt  0.0) and (M2_arr gt  0.0),icount)
endif

mass_inc = massi(ind_i)
i_inc = i_arr(ind_i)
a_inc = a_arr(ind_i)
W_cap_inc = W_cap_arr(ind_i)
chi_inc = chi_arr(ind_i)
mratio_inc = mratio_arr(ind_i)
M2_inc = M2_arr(ind_i)
M1_inc = M1_arr(ind_i)

; restrict range of mass to be within Mass_min

Mass_min = 0d

print, "Enter upper bound for mass restriction"
read,Mass_min

massnum = where(massi le Mass_min, mcount)

mrestrict = dblarr(mcount)
Prestrict = dblarr(mcount)
arestrict = dblarr(mcount)
erestrict = dblarr(mcount)
irestrict = dblarr(mcount)
Trestrict = dblarr(mcount)
W_caprestrict = dblarr(mcount)
w_lowrestrict = dblarr(mcount)
chirestrict = dblarr(mcount)

mratio_restrict = dblarr(mcount)
M2_restrict = dblarr(mcount)
M1_restrict = dblarr(mcount)

n=0

for l=0, fnum-1 do begin

	if (massi(l) le Mass_min) then begin

		mrestrict(n) = massi(l)
		Prestrict(n) = P_arr(l)
		arestrict(n) = a_arr(l)
		erestrict(n) = e_arr(l)
		irestrict(n) = i_arr(l)
		Trestrict(n) = T_arr(l)
		W_caprestrict(n) = W_cap_arr(l)
		w_lowrestrict(n) = w_low_arr(l)
		chirestrict(n) = chi_arr(l)

                mratio_restrict(n) = mratio_arr(l)
                M2_restrict(n) = M2_arr(l)
                M1_restrict(n) = M1_arr(l)

		n=n+1
	endif
endfor

if (ans_inc eq 'y') then begin
mcount = icount
mrestrict = mass_inc
chirestrict = chi_inc
irestrict = i_inc
arestrict = a_inc
W_caprestrict = W_cap_inc
mratio_restrict  = mratio_inc
M1_restrict = M1_inc
M2_restrict = M2_inc
chi_inc = chi_arr(ind_i)
endif

chiprob = dblarr(mcount)
chiprob_inc = dblarr(icount)

; Chi2 probability distribution
; compute the probability of exceeding chi2

for i=0, mcount-1 do begin
chiprob(i) = 1.0 - chisqr_pdf(chirestrict(i),dof)
endfor

for i=0, icount-1 do begin
chiprob_inc(i) = 1.0 - chisqr_pdf(chi_inc(i),dof)
endfor

;Save mass histogram to file tempprob.ps
set_plot, 'ps'
device, filename='tempprob.ps',xsize=18,ysize=13

plot,chirestrict,chiprob,psym=3, xtitle='chi2', ytitle='prob(chi2,nu)', $
	title = 'nu = '+string(dof)

device, /close
set_plot,'x'

print,"Error estimates: min max mean median stddev"
print,format='(%"M:",f10.4,f10.4,f10.4,f10.4,f10.4)', $
	min(massi),max(massi),mean(massi),median(massi),stddev(massi)
print,format='(%"P:",f10.4,f10.4,f10.4,f10.4,f10.4)', $
	min(P_arr),max(P_arr),mean(P_arr),median(P_arr),stddev(P_arr)
print,format='(%"a:",f10.4,f10.4,f10.4,f10.4,f10.4)', $
	min(a_arr),max(a_arr),mean(a_arr),median(a_arr),stddev(a_arr)
print,format='(%"e:",f10.6,f10.6,f10.6,f10.6,f10.6)', $
	min(e_arr),max(e_arr),mean(e_arr),median(e_arr),stddev(e_arr)
print,format='(%"i:",f10.4,f10.4,f10.4,f10.4,f10.4)', $
	min(i_arr),max(i_arr),mean(i_arr),median(i_arr),stddev(i_arr)
print,format='(%"T:",f10.4,f10.4,f10.4,f10.4,f10.4)', $
	min(T_arr),max(T_arr),mean(T_arr),median(T_arr),stddev(T_arr)
print,format='(%"W:",f10.4,f10.4,f10.4,f10.4,f10.4)', $
	min(W_cap_arr),max(W_cap_arr),mean(W_cap_arr), $
	median(W_cap_arr),stddev(W_cap_arr)
print,format='(%"w:",f10.4,f10.4,f10.4,f10.4,f10.4)', $
	min(w_low_arr),max(w_low_arr),mean(w_low_arr), $
	median(w_low_arr),stddev(w_low_arr)

if (K1 ne 0) then begin
print,format='(%"M1:",f12.4,f10.4,f10.4,f10.4,f10.4)', $
	min(M1_arr),max(M1_arr),mean(M1_arr),median(M1_arr),stddev(M1_arr)
print,format='(%"M2:",f12.4,f10.4,f10.4,f10.4,f10.4)', $
	min(M2_arr),max(M2_arr),mean(M2_arr),median(M2_arr),stddev(M2_arr)
endif


; convert Mass_min to a string and remove leading white space

Mass_value = string(Mass_min)

Mass_value = strtrim(Mass_min,1)

print,"Restrict mass to be below ", Mass_value, " Msun"
print,format='(%"M:",f10.4,f10.4,f10.4,f10.4,f10.4)', $
	min(mrestrict),max(mrestrict), mean(mrestrict), $
	median(mrestrict),stddev(mrestrict)
print,format='(%"P:",f10.4,f10.4,f10.4,f10.4,f10.4)', $
	min(Prestrict),max(Prestrict), mean(Prestrict), $
	median(Prestrict),stddev(Prestrict)
print,format='(%"a:",f10.4,f10.4,f10.4,f10.4,f10.4)', $
	min(arestrict),max(arestrict), mean(arestrict), $
	median(arestrict),stddev(arestrict)
print,format='(%"e:",f10.6,f10.6,f10.6,f10.6,f10.6)', $
	min(erestrict),max(erestrict), mean(erestrict), $
	median(erestrict),stddev(erestrict)
print,format='(%"i:",f10.4,f10.4,f10.4,f10.4,f10.4)', $
	min(irestrict),max(irestrict), mean(irestrict), $
	median(irestrict),stddev(irestrict)
print,format='(%"T:",f10.4,f10.4,f10.4,f10.4,f10.4)', $
	min(Trestrict),max(Trestrict),mean(Trestrict), $
	median(Trestrict),stddev(Trestrict)
print,format='(%"W:",f10.4,f10.4,f10.4,f10.4,f10.4)', $
	min(W_caprestrict),max(W_caprestrict),mean(W_caprestrict), $
	median(W_caprestrict),stddev(W_caprestrict)
print,format='(%"w:",f10.4,f10.4,f10.4,f10.4,f10.4)', $
	min(w_lowrestrict),max(w_lowrestrict),mean(w_lowrestrict), $
	median(w_lowrestrict),stddev(w_lowrestrict)

if (K1 ne 0) then begin
print,format='(%"M1",f10.4,f10.4,f10.4,f10.4,f10.4)', $
	min(M1_restrict),max(M1_restrict), mean(M1_restrict), $
	median(M1_restrict),stddev(M1_restrict)
print,format='(%"M2",f10.4,f10.4,f10.4,f10.4,f10.4)', $
	min(M2_restrict),max(M2_restrict), mean(M2_restrict), $
	median(M2_restrict),stddev(M2_restrict)
endif

medM = median(mrestrict)
;medP = median(Prestrict)
;meda = median(arestrict)
;mede = median(erestrict)
;meani = mean(irestrict)

mrange = max(mrestrict) - min(mrestrict)
;Prange = max(Prestrict) - min(Prestrict)
;arange = max(arestrict) - min(arestrict)
;erange = max(erestrict) - min(erestrict)
;irange = max(irestrict) - min(irestrict)

; minimum of ranges (needed for creating histogram)

mmin = min(mrestrict) ;+ mrange/2d
;Pmin = min(Prestrict) ;+ Prange/2d
;amin = min(arestrict) ;+ arange/2d
;emin = min(erestrict) ;+ erange/2d
;imin = min(irestrict) ;+ irange/2d

mstep = 0d
;Pstep = 0d
;astep = 0d
;estep = 0d
;istep = 0d

print, "Enter step size for mass histogram:"
read, mstep
;print, "Enter step size for period histogram:"
;read, Pstep
;print, "Enter step size for a histogram:"
;read, astep
;print, "Enter step size for e histogram:"
;read, estep
;print, "Enter step size for i histogram:"
;read, istep

print, "Enter desired Mass minimum:", mmin
read,mmin
;print, "Enter desired P minimum:", Pmin
;read,Pmin
;print, "Enter desired a minimum:", amin
;read,amin
;print, "Enter desired e minimum:", emin
;read,emin
;print, "Enter desired i minimum:", imin
;read,imin

mnum = round(mrange/double(mstep)) + 2 ; number of mass steps searched
;Pnum = round(Prange/double(Pstep)) + 2
;anum = round(arange/double(astep)) + 2
;enum = round(erange/double(estep)) + 2
;inum = round(irange/double(istep)) + 2


print, 'Creating histograms...'

; Create histogram arrays 

mbins = dblarr(mnum)	; array of all possible masses searched
h_marr = dblarr(mnum)	; array to contain the number of values at each step
;Pbins = dblarr(Pnum)	
;h_Parr = intarr(Pnum)
;abins = dblarr(anum)	
;h_aarr = intarr(anum)
;ebins = dblarr(enum)	
;h_earr = intarr(enum)
;ibins = dblarr(inum)	
;h_iarr = intarr(inum)

create_histo_w, mmin, mrange, mstep, mrestrict, chiprob, mbins, h_marr


print,format='(%"M:",f10.4,f10.4,f10.4,f10.4,f10.4)', $
	min(mass_inc),max(mass_inc), mean(mass_inc), $
	median(mass_inc),stddev(mass_inc)
mrange_inc = max(mass_inc) - min(mass_inc)
mmin_inc = min(mass_inc) ;+ mrange_inc/2d
mstep_inc = 0d
print, "Enter step size for mass histogram:"
read, mstep_inc
print, "Enter desired Mass minimum:", mmin_inc
read,mmin_inc
mnum_inc = round(mrange_inc/double(mstep_inc)) + 2 ; number of mass steps searched
mbins_inc = dblarr(mnum_inc)	; array of all possible masses searched
h_marr_inc = dblarr(mnum_inc)	; array to contain the number of values at each step
create_histo_w, mmin_inc, mrange_inc, mstep_inc, mass_inc, chiprob_inc, mbins_inc, h_marr_inc

;create_histo, mmin, mrange, mstep, mrestrict, mbins, h_marr
;create_histo, Pmin, Prange, Pstep, Prestrict, Pbins, h_Parr
;create_histo, amin, arange, astep, arestrict, abins, h_aarr
;create_histo, emin, erange, estep, erestrict, ebins, h_earr
;create_histo, imin, irange, istep, irestrict, ibins, h_iarr

;print, 'Mass bin   Number in each bin'
;for i=0, mnum-1 do print, mbins(i), h_marr(i)

!P.MULTI = [0,3,2]
;;Save histograms to file temp.ps
;mydevice = !d.name
;set_plot, 'ps'
;device, filename='temp.ps',xsize=18,ysize=13
;
;plot,mbins,h_marr,psym=10,xtitle='Mass (Msun)'
;plot,Pbins,h_Parr,psym=10,xtitle='Period (years)'
;plot,abins,h_aarr,psym=10,xtitle='Semi-Major Axis (mas)'
;plot,ebins,h_earr,psym=10,xtitle='Eccentricity'
;plot,ibins,h_iarr,psym=10,xtitle='Inclination (deg)'
;
;device, /close
;set_plot,mydevice

!P.MULTI = [0,0,0]

;ptitle=' '
;print,'Enter plot title:'
;read,ptitle
;xloc = 0.0
;yloc = 0.0
;print,'Enter title location (x,y):'
;read,xloc,yloc

;Save mass histogram to file tempM.ps
mydevice = !d.name
set_plot, 'ps'
device, filename='tempM.ps',xsize=18,ysize=13

plot,mbins,h_marr,psym=10,xtitle='Total Mass (M!9!dn!3!n)', $
 	ytitle="Weighted Number of Solutions", xrange=[2,8],xstyle=1
;, xrange=[0,Mass_min]

oplot,mbins_inc,h_marr_inc,psym=10,linestyle=1

;xyouts,xloc,yloc,ptitle

device, /close
set_plot,mydevice


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; 34% Uncertainty Intervals ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; no longer use step sizes in computing median and uncertainties
; just sort the arrays

; determine error: range of values (away from the median) that contains
; 2/3 of the sample (68%)
; i.e. 34% of total values on either side of median

compute_histo_uncty, mrestrict, chiprob, medM, dM_low, dM_high


print, 'Number of solutions in restricted range:', mcount

;; Determine 95% probability upper mass limit
;
;;num95 = 0.05*mcount	; number of solutions included in 34% of total
;num95 = 0.05*sum_weight	; number of solutions included in 34% of total
;
;sum_95prob = 0.0
;
;arr_i = n_elements(h_marr)
;
;while(sum_95prob le num95) do begin
;
;	arr_i = arr_i - 1
;
;	sum_95prob = sum_95prob + h_marr(arr_i)
;
;endwhile
;
;m95prob = mbins(arr_i)

print,"Error range within +/-34% of median mass:"
print,"Median:", medM
print,'Errors:  +', dM_high  ;merror_upper 
print,'         -', dM_low   ;merror_lower
;print,"Total number of solutions:", sum_weight
;print,'34% of total number:', num34
;print,'Total number in upper error estimate:', sum_lower
;print,'Total number in lower error estimate:', sum_upper
;print, ' '

;print,'There is a 95% probability that the mass is below:',m95prob

;logP = alog10(P_arr)
;loga = alog10(a_arr)
;logM = alog10(massi)
;rlogP = alog10(Prestrict)
;rloga = alog10(arestrict)

;!P.MULTI = [0,3,2]
;Save histograms to file templog.ps

;mydevice = !d.name
;set_plot, 'ps'
;
;device, filename='templog.ps',xsize=18,ysize=13
;plot,logP,e_arr,psym=3,xtitle="log(P) (yrs)",ytitle="e" 
;plot,loga,e_arr,psym=3,xtitle="log(a) (mas)",ytitle="e"
;plot,logP,loga,psym=3,xtitle="log(P) (yrs)",ytitle="log(a) (mas)" 
;plot,e_arr,logM,psym=3,xtitle="e",ytitle="log(M) (Msun)"
;plot,logP,logM,psym=3,xtitle="log(P) (yrs)",ytitle="log(M) (Msun)" 
;plot,loga,logM,psym=3,xtitle="log(a) (mas)",ytitle="log(M) (Msun)"
;plot,e_arr,massi,psym=3,xtitle="e",ytitle="M (Msun)"
;plot,logP,massi,psym=3,xtitle="log(P) (yrs)",ytitle="M (Msun)" 
;plot,loga,massi,psym=3,xtitle="log(a) (mas)",ytitle="M (Msun)"

;plot,rlogP,erestrict,psym=3,xtitle="log(P) (yrs)",ytitle="e" 
;plot,rloga,erestrict,psym=3,xtitle="log(a) (mas)",ytitle="e"
;plot,rlogP,rloga,psym=3,xtitle="log(P) (yrs)",ytitle="log(a) (mas)"
;plot,e_arr,mrestrict,psym=3,xtitle="e",ytitle="M (Msun)"
;plot,rlogP,mrestrict,psym=3,xtitle="log(P) (yrs)",ytitle="M (Msun)"
;plot,rloga,mrestrict,psym=3,xtitle="log(a) (mas)",ytitle="M (Msun)"
;device, /close
;
;set_plot,mydevice
;
;!P.MULTI = [0,0,0]


openw,1,"result_errors"

printf,1,'Results from plot_Pae_weight.pro'
;printf,1,'Data file name:', data_file
printf,1,'Number of lines in data_file:', datanum
printf,1,'PTe file name:', pte_file
printf,1,'Number of lines in pte_file:', fnum

printf,1,' '

printf,1,"Error estimates: min max mean median stddev"
printf,1,format='(%"M:",f10.4,f10.4,f10.4,f10.4,f10.4)', $
	min(massi),max(massi),mean(massi),median(massi),stddev(massi)
printf,1,format='(%"P:",f10.4,f10.4,f10.4,f10.4,f10.4)', $
	min(P_arr),max(P_arr),mean(P_arr),median(P_arr),stddev(P_arr)
printf,1,format='(%"a:",f10.4,f10.4,f10.4,f10.4,f10.4)', $
	min(a_arr),max(a_arr),mean(a_arr),median(a_arr),stddev(a_arr)
printf,1,format='(%"e:",f10.6,f10.6,f10.6,f10.6,f10.6)', $
	min(e_arr),max(e_arr),mean(e_arr),median(e_arr),stddev(e_arr)
printf,1,format='(%"i:",f10.4,f10.4,f10.4,f10.4,f10.4)', $
	min(i_arr),max(i_arr),mean(i_arr),median(i_arr),stddev(i_arr)
printf,1,format='(%"T:",f10.4,f10.4,f10.4,f10.4,f10.4)', $
	min(T_arr),max(T_arr),mean(T_arr),median(T_arr),stddev(T_arr)
printf,1,format='(%"W:",f10.4,f10.4,f10.4,f10.4,f10.4)', $
	min(W_cap_arr),max(W_cap_arr),mean(W_cap_arr), $
	median(W_cap_arr),stddev(W_cap_arr)
printf,1,format='(%"w:",f10.4,f10.4,f10.4,f10.4,f10.4)', $
	min(w_low_arr),max(w_low_arr),mean(w_low_arr), $
	median(w_low_arr),stddev(w_low_arr)

if (K1 ne 0) then begin
printf,1,format='(%"M1:",f10.4,f10.4,f10.4,f10.4,f10.4)', $
	min(M1_arr),max(M1_arr),mean(M1_arr),median(M1_arr),stddev(M1_arr)
printf,1,format='(%"M2:",f10.4,f10.4,f10.4,f10.4,f10.4)', $
	min(M2_arr),max(M2_arr),mean(M2_arr),median(M2_arr),stddev(M2_arr)
endif

; convert Mass_min to a string and remove leading white space

Mass_value = string(Mass_min)

Mass_value = strtrim(Mass_min,1)

printf,1,"Restrict mass to be below ", Mass_value, " Msun"
printf,1,format='(%"M:",f10.4,f10.4,f10.4,f10.4,f10.4)', $
	min(mrestrict),max(mrestrict), mean(mrestrict), $
	median(mrestrict),stddev(mrestrict)
printf,1,format='(%"P:",f10.4,f10.4,f10.4,f10.4,f10.4)', $
	min(Prestrict),max(Prestrict), mean(Prestrict), $
	median(Prestrict),stddev(Prestrict)
printf,1,format='(%"a:",f10.4,f10.4,f10.4,f10.4,f10.4)', $
	min(arestrict),max(arestrict), mean(arestrict), $
	median(arestrict),stddev(arestrict)
printf,1,format='(%"e:",f10.6,f10.6,f10.6,f10.6,f10.6)', $
	min(erestrict),max(erestrict), mean(erestrict), $
	median(erestrict),stddev(erestrict)
printf,1,format='(%"i:",f10.4,f10.4,f10.4,f10.4,f10.4)', $
	min(irestrict),max(irestrict), mean(irestrict), $
	median(irestrict),stddev(irestrict)
printf,1,format='(%"T:",f10.4,f10.4,f10.4,f10.4,f10.4)', $
	min(Trestrict),max(Trestrict),mean(Trestrict), $
	median(Trestrict),stddev(Trestrict)
printf,1,format='(%"W:",f10.4,f10.4,f10.4,f10.4,f10.4)', $
	min(W_caprestrict),max(W_caprestrict),mean(W_caprestrict), $
	median(W_caprestrict),stddev(W_caprestrict)
printf,1,format='(%"w:",f10.4,f10.4,f10.4,f10.4,f10.4)', $
	min(w_lowrestrict),max(w_lowrestrict),mean(w_lowrestrict), $
	median(w_lowrestrict),stddev(w_lowrestrict)

if (K1 ne 0) then begin
printf,1,format='(%"M1",f10.4,f10.4,f10.4,f10.4,f10.4)', $
	min(M1_restrict),max(M1_restrict), mean(M1_restrict), $
	median(M1_restrict),stddev(M1_restrict)
printf,1,format='(%"M2",f10.4,f10.4,f10.4,f10.4,f10.4)', $
	min(M2_restrict),max(M2_restrict), mean(M2_restrict), $
	median(M2_restrict),stddev(M2_restrict)
endif

printf,1," "

printf,1, 'Number of solutions in restricted range:', mcount
;printf,1, 'Sum of weighted number of solutions:', sum_weight
printf,1," "
printf,1,"Error range within +/-34% of median mass:"
printf,1,"Median:", medM
printf,1,'Errors:  +', dM_high  ;merror_upper 
printf,1,'         -', dM_low   ;merror_lower
;printf,1,"Total number of solutions:", sum_weight
;printf,1,'34% of total number:', num34
;printf,1,'Total number in upper error estimate:', sum_lower
;printf,1,'Total number in lower error estimate:', sum_upper
;printf,1, ' '

;printf,1, "Mass Histogram (bin value, number in bin)"
;for l=0, mnum-1 do begin
;
;	printf,1, mbins(l), h_marr(l)
;endfor

close,1

;Make plot of chi2 vs. mass (tempchi.ps)
; View chi2 surface

print,'Min chi2:',min(chi_arr)
print,'Max chi2:',max(chi_arr)

chimin = 0.0
chimax = 0.0
print,'Enter min max of chi range for plot:'
read,chimin,chimax

mydevice = !d.name
set_plot, 'ps'

device, filename='tempchi.ps'
;plot,massi,chi_arr,psym=3,xtitle='Mass (Msun)',ytitle='chi^2',yrange=[chimin,chimax]
plot,massi,chi_arr,psym=3,xtitle='Mass (M!9!dn!3!n)',ytitle='!7v!3!u2!n', $
  xrange=[0,Mass_min], yrange=[chimin,chimax],xstyle=1,ystyle=1
device, /close

set_plot,mydevice

set_plot, 'ps'

device, filename='tempM1M2.ps'
plot,i_arr,M1_arr,psym=3,xtitle='i (deg)',ytitle='M1 (M!9!dn!3!n)', $
  yrange=[-10,10],xrange=[130,230],xstyle=1,ystyle=1
plot,i_arr,M2_arr,psym=3,xtitle='i (deg)',ytitle='M2 (M!9!dn!3!n)', $
  yrange=[-10,10],xrange=[130,230],xstyle=1,ystyle=1
device, /close

set_plot,'x'

end

;
;
;

pro create_histo, xmin, xrange, xstep, data, xbins, h_xarr

; INPUT
; xmid: best fit solution for separation/flux fraction
; xrange: search range   (xmid-xrange:xmid+xrange)
; xstep: step size through search range
; data: array of solutions found in grid that are within 1 chi^2 of best fit
; OUTPUT
; xbins: array of all searched separations/flux fractions
; h_xarr: array to contain the number of values at each step

xnum = round(xrange/double(xstep)) + 2 ; number of separation steps searched

;xbins = dblarr(xnum)	; array of all possible separations searched
;h_xarr = intarr(xnum)	; array to contain the number of values at each step

x = xmin

for i=0, xnum-1 do begin

	xbins(i) = x
	x = x + xstep

endfor

datanum = n_elements(data)

for i=long(0), datanum-1 do begin

	for j=long(0), xnum-1 do begin

	if (round(data(i)/xstep)*xstep eq round(xbins(j)/xstep)*xstep) $ 
			then h_xarr(j) = h_xarr(j) + 1

	endfor
endfor

end

;
;
;

pro create_histo_w, xmin, xrange, xstep, data, prob, xbins, h_xarr

; INPUT
; xmid: best fit solution for separation/flux fraction
; xrange: search range   (xmid-xrange:xmid+xrange)
; xstep: step size through search range
; data: array of solutions found in grid that are within 1 chi^2 of best fit
; OUTPUT
; xbins: array of all searched separations/flux fractions
; h_xarr: array to contain the number of values at each step

xnum = round(xrange/double(xstep)) + 2 ; number of separation steps searched

;xbins = dblarr(xnum)	; array of all possible separations searched
;h_xarr = intarr(xnum)	; array to contain the number of values at each step

x = xmin

for i=0, xnum-1 do begin

	xbins(i) = x
	x = x + xstep

endfor

datanum = n_elements(data)

for i=long(0), datanum-1 do begin

	for j=long(0), xnum-1 do begin

	if (round(data(i)/xstep)*xstep eq round(xbins(j)/xstep)*xstep) $ 
			then h_xarr(j) = h_xarr(j) + 1.0*prob(i)

	endfor
endfor

end

;
;
;

pro compute_histo_uncty, mass_array, chiprob, medM, merror_lower, merror_upper

; no longer use step sizes in computing median and uncertainties
; just sort the arrays

;print,"Error range within +/-34% of median mass:"
;print,"Median:", medM
;print,'Errors:  +', merror_upper 
;print,'         -', merror_lower

; determine error: range of values (away from the median) that contains
; 2/3 of the sample (68%)
; i.e. 34% of total values on either side of median
; print, "Enter finer step size for mass histogram:"


ind_sort = sort(mass_array,/L64)

mass_sort = mass_array(ind_sort)
chi_sort = chiprob(ind_sort)

; check if best fit mass is already given... 
; ... if not, compute median mass
key_medM = keyword_set(medM)

sum_weight = total(chi_sort)

med_num = 0.5*sum_weight
med_sum = 0
med_ind = 0
while(med_sum le 0.5*sum_weight) do begin
	med_sum = med_sum + chi_sort(med_ind)
	med_ind = med_ind + 1.0
endwhile
med_ind = med_ind - 1.0
;med_sum = med_sum - chi_sort(med_ind)
;bin_diff = 0.5*sum_weight - med_sum
;bin_frac = bin_diff/chi_sort(med_ind)
;med_ind = med_ind - 1.0
if (key_medM ne 1) then medM = mass_sort(med_ind) $ ;+ bin_frac*mstep
else med_ind = where(abs(mass_sort - medM) eq min(abs(mass_sort - medM)))

num34 = 0.34*sum_weight	; number of solutions included in 34% of total

print,'Computing errors...'

sum_lower = 0.0
sum_upper = 0.0

; determine lower error bar
arr_i = med_ind
while(sum_lower le num34) do begin
	sum_lower = sum_lower + chi_sort(arr_i)
	arr_i = arr_i - 1
endwhile
mbin_lower = arr_i + 1.0
merror_lower = medM - mass_sort(mbin_lower)

; determine upper error bar
arr_i = med_ind
while(sum_upper le num34) do begin
	sum_upper = sum_upper + chi_sort(arr_i)
	arr_i = arr_i + 1
endwhile
mbin_upper = arr_i - 1.0
merror_upper = mass_sort(mbin_upper) - medM

end

